/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class SixpackImporter
extends ImportFormat {
    public String getFormatName() {
        return "Sixpack";
    }

    public String getCLIId() {
        return "sixpack";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return true;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string = new String(new char[]{'\u0000', '0'});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", "bibtexkey");
        hashMap.put("au", "author");
        hashMap.put("ti", "title");
        hashMap.put("jo", "journal");
        hashMap.put("vo", "volume");
        hashMap.put("nu", "number");
        hashMap.put("pa", "pages");
        hashMap.put("mo", "month");
        hashMap.put("yr", "year");
        hashMap.put("kw", "keywords");
        hashMap.put("ab", "abstract");
        hashMap.put("no", "note");
        hashMap.put("ed", "editor");
        hashMap.put("pu", "publisher");
        hashMap.put("se", "series");
        hashMap.put("ad", "address");
        hashMap.put("en", "edition");
        hashMap.put("ch", "chapter");
        hashMap.put("hp", "howpublished");
        hashMap.put("tb", "booktitle");
        hashMap.put("or", "organization");
        hashMap.put("sc", "school");
        hashMap.put("in", "institution");
        hashMap.put("ty", "type");
        hashMap.put("url", "url");
        hashMap.put("cr", "crossref");
        hashMap.put("fi", "file");
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        bufferedReader.readLine();
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(",");
        String string3 = null;
        BibtexEntry bibtexEntry = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            try {
                String string4;
                String[] stringArray2 = (string3 = string3.replaceAll("<par>", "")).split(string);
                if (stringArray2.length < 2) continue;
                BibtexEntryType bibtexEntryType = BibtexEntryType.getType(stringArray2[1].toLowerCase());
                if (bibtexEntryType == null) {
                    string4 = "";
                    if (stringArray2[1].equals("Masterthesis")) {
                        string4 = "mastersthesis";
                    }
                    if (stringArray2[1].equals("PhD-Thesis")) {
                        string4 = "phdthesis";
                    }
                    if (stringArray2[1].equals("miscellaneous")) {
                        string4 = "misc";
                    }
                    if (stringArray2[1].equals("Conference")) {
                        string4 = "proceedings";
                    }
                    bibtexEntryType = BibtexEntryType.getType(string4.toLowerCase());
                }
                bibtexEntry = new BibtexEntry(Util.createNeutralId(), bibtexEntryType);
                for (int i = 0; i < Math.min(stringArray.length, stringArray2.length); ++i) {
                    string4 = (String)hashMap.get(stringArray[i]);
                    if (string4 == null) continue;
                    if (string4.equals("author") || string4.equals("editor")) {
                        ImportFormatReader.setIfNecessary(bibtexEntry, string4, stringArray2[i].replaceAll(" and ", ", ").replaceAll(", ", " and "));
                        continue;
                    }
                    if (string4.equals("pages")) {
                        ImportFormatReader.setIfNecessary(bibtexEntry, string4, stringArray2[i].replaceAll("-", "--"));
                        continue;
                    }
                    if (string4.equals("file")) {
                        String string5 = "pdf";
                        if (stringArray2[i].endsWith("ps") || stringArray2[i].endsWith("ps.gz")) {
                            string5 = "ps";
                        } else if (stringArray2[i].endsWith("html")) {
                            string5 = "url";
                        }
                        ImportFormatReader.setIfNecessary(bibtexEntry, string5, stringArray2[i]);
                        continue;
                    }
                    ImportFormatReader.setIfNecessary(bibtexEntry, string4, stringArray2[i]);
                }
                arrayList.add(bibtexEntry);
            }
            catch (NullPointerException nullPointerException) {
                Globals.logger("Problem parsing Sixpack entry, ignoring entry.");
            }
        }
        return arrayList;
    }
}

