/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.labelPattern.LabelPattern;

public class LabelPatternUtil {
    private static String CHARS = "abcdefghijklmnopqrstuvwxyz";
    public static ArrayList DEFAULT_LABELPATTERN;
    private static BibtexDatabase _db;

    public static void updateDefaultPattern() {
        DEFAULT_LABELPATTERN = LabelPatternUtil.split(Globals.prefs.get("defaultLabelPattern"));
    }

    public static ArrayList split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]", true);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static BibtexEntry makeLabel(LabelPattern labelPattern, BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        String string;
        int n;
        int n2;
        String string2;
        _db = bibtexDatabase;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        try {
            string2 = bibtexEntry.getType().getName().toLowerCase();
            ArrayList arrayList = labelPattern.getValue(string2);
            int n3 = arrayList.size();
            n2 = 0;
            for (n = 1; n < n3; ++n) {
                string = arrayList.get(n).toString();
                if (string.equals("[")) {
                    n2 = 1;
                    continue;
                }
                if (string.equals("]")) {
                    n2 = 0;
                    continue;
                }
                if (n2 != 0) {
                    CharSequence charSequence;
                    String[] stringArray = string.split(":");
                    string = stringArray[0];
                    CharSequence charSequence2 = new StringBuffer();
                    try {
                        if (string.startsWith("auth") || string.startsWith("pureauth")) {
                            String string3;
                            if (string.startsWith("pure")) {
                                string = string.substring(4);
                                System.out.println("val is now " + string);
                                string3 = bibtexEntry.getField("author").toString();
                                System.out.println("Got authString " + string3);
                            } else {
                                string3 = bibtexEntry.getField("author") == null || bibtexEntry.getField("author").toString().equals("") ? bibtexEntry.getField("editor").toString() : bibtexEntry.getField("author").toString();
                            }
                            if (string.equals("auth")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.firstAuthor(string3));
                            } else if (string.equals("authors")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.allAuthors(string3));
                            } else if (string.equals("authorIni")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.oneAuthorPlusIni(string3));
                            } else if (string.matches("authIni[\\d]+")) {
                                int n4 = Integer.parseInt(string.substring(7));
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authIniN(string3, n4));
                            } else if (string.equals("auth.auth.ea")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authAuthEa(string3));
                            } else if (string.equals("authshort")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authshort(string3));
                            } else if (string.matches("auth[\\d]+_[\\d]+")) {
                                String[] stringArray2 = string.substring(4).split("_");
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authN_M(string3, Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]) - 1));
                            } else if (string.matches("auth\\d+")) {
                                int n5 = Integer.parseInt(string.substring(4));
                                if (n5 > ((String)(charSequence = LabelPatternUtil.firstAuthor(string3))).length()) {
                                    n5 = ((String)charSequence).length();
                                }
                                ((StringBuffer)charSequence2).append(((String)charSequence).substring(0, n5));
                            } else if (string.matches("authors\\d+")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.NAuthors(string3, Integer.parseInt(string.substring(7))));
                            } else {
                                ((StringBuffer)charSequence2).append(bibtexEntry.getField(string).toString());
                            }
                        } else if (string.startsWith("ed")) {
                            if (string.equals("edtr")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.firstAuthor(bibtexEntry.getField("editor").toString()));
                            } else if (string.equals("editors")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.allAuthors(bibtexEntry.getField("editor").toString()));
                            } else if (string.equals("editorIni")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.oneAuthorPlusIni(bibtexEntry.getField("editor").toString()));
                            } else if (string.matches("edtrIni[\\d]+")) {
                                int n6 = Integer.parseInt(string.substring(7));
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authIniN(bibtexEntry.getField("editor").toString(), n6));
                            } else if (string.matches("edtr[\\d]+_[\\d]+")) {
                                String[] stringArray3 = string.substring(4).split("_");
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authN_M(bibtexEntry.getField("editor").toString(), Integer.parseInt(stringArray3[0]), Integer.parseInt(stringArray3[1]) - 1));
                            } else if (string.equals("edtr.edtr.ea")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authAuthEa(bibtexEntry.getField("editor").toString()));
                            } else if (string.equals("edtrshort")) {
                                ((StringBuffer)charSequence2).append(LabelPatternUtil.authshort(bibtexEntry.getField("editor").toString()));
                            } else if (string.matches("edtr\\d+")) {
                                String string4;
                                int n7 = Integer.parseInt(string.substring(4));
                                if (n7 > (string4 = LabelPatternUtil.firstAuthor(bibtexEntry.getField("editor").toString())).length()) {
                                    n7 = string4.length();
                                }
                                ((StringBuffer)charSequence2).append(string4.substring(0, n7));
                            } else {
                                ((StringBuffer)charSequence2).append(bibtexEntry.getField(string).toString());
                            }
                        } else if (string.equals("firstpage")) {
                            ((StringBuffer)charSequence2).append(LabelPatternUtil.firstPage(bibtexEntry.getField("pages").toString()));
                        } else if (string.equals("lastpage")) {
                            ((StringBuffer)charSequence2).append(LabelPatternUtil.lastPage(bibtexEntry.getField("pages").toString()));
                        } else if (string.equals("shorttitle")) {
                            ((StringBuffer)charSequence2).append(LabelPatternUtil.getTitleWords(3, bibtexEntry));
                        } else if (string.equals("shortyear")) {
                            String string5 = bibtexEntry.getField("year").toString();
                            if (string5.startsWith("in") || string5.startsWith("sub")) {
                                ((StringBuffer)charSequence2).append("IP");
                            } else if (string5.length() > 2) {
                                ((StringBuffer)charSequence2).append(string5.substring(string5.length() - 2));
                            } else {
                                ((StringBuffer)charSequence2).append(string5);
                            }
                        } else if (string.equals("veryshorttitle")) {
                            ((StringBuffer)charSequence2).append(LabelPatternUtil.getTitleWords(1, bibtexEntry));
                        } else {
                            ((StringBuffer)charSequence2).append(bibtexEntry.getField(string).toString());
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (stringArray.length > 1) {
                        for (int i = 1; i < stringArray.length; ++i) {
                            String string6 = stringArray[i];
                            if (string6.equals("lower")) {
                                charSequence = ((StringBuffer)charSequence2).toString().toLowerCase();
                                charSequence2 = new StringBuffer((String)charSequence);
                                continue;
                            }
                            if (string6.equals("abbr")) {
                                charSequence = new StringBuffer();
                                String[] stringArray4 = ((StringBuffer)charSequence2).toString().replaceAll("[\\{\\}]", "").split("[ \r\n]");
                                for (int j = 0; j < stringArray4.length; ++j) {
                                    if (stringArray4[j].length() <= 0) continue;
                                    ((StringBuffer)charSequence).append(stringArray4[j].charAt(0));
                                }
                                charSequence2 = charSequence;
                                continue;
                            }
                            Globals.logger("Key generator warning: unknown modifier '" + string6 + "'.");
                        }
                    }
                    stringBuffer.append((StringBuffer)charSequence2);
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        String string7 = Util.checkLegalKey(stringBuffer.toString());
        string2 = Globals.prefs.get("KeyPatternRegex");
        if (string2 != null && string2.trim().length() > 0) {
            String string8 = Globals.prefs.get("KeyPatternReplacement");
            string7 = string7.replaceAll(string2, string8);
        }
        if (bl) {
            string7 = string7.toUpperCase();
        }
        if (bl2) {
            string7 = string7.toLowerCase();
        }
        String string9 = bibtexEntry.getCiteKey();
        n2 = _db.getNumberOfKeyOccurences(string7);
        if (string9 != null && string9.equals(string7)) {
            --n2;
        }
        if (n2 == 0) {
            if (!string7.equals(string9)) {
                _db.setCiteKeyForEntry(bibtexEntry.getId(), string7);
            }
        } else {
            n = 0;
            string = string7 + LabelPatternUtil.getAddition(n);
            n2 = _db.getNumberOfKeyOccurences(string);
            if (string9 != null && string9.equals(string)) {
                --n2;
            }
            while (n2 > 0) {
                string = string7 + LabelPatternUtil.getAddition(++n);
                n2 = _db.getNumberOfKeyOccurences(string);
                if (string9 == null || !string9.equals(string)) continue;
                --n2;
            }
            if (!string.equals(string9)) {
                _db.setCiteKeyForEntry(bibtexEntry.getId(), string);
            }
        }
        return bibtexEntry;
    }

    private static String getAddition(int n) {
        String string = "";
        if (n >= CHARS.length()) {
            int n2 = n % CHARS.length();
            return LabelPatternUtil.getAddition(n / CHARS.length() - 1) + CHARS.substring(n2, n2 + 1);
        }
        return CHARS.substring(n, n + 1);
    }

    static String getTitleWords(int n, BibtexEntry bibtexEntry) {
        String string = new RemoveLatexCommands().format(bibtexEntry.getField("title").toString());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        block0: while (n2 < string.length() && n3 < n) {
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                stringBuffer2.append(string.charAt(n2));
                ++n2;
            }
            ++n2;
            String string2 = stringBuffer2.toString().trim();
            if (string2.length() == 0) continue;
            for (int i = 0; i < Globals.SKIP_WORDS.length; ++i) {
                if (string2.equalsIgnoreCase(Globals.SKIP_WORDS[i])) continue block0;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static boolean isLabelUnique(String string) {
        boolean bl = true;
        int n = _db.getEntryCount();
        for (int i = 0; i < n; ++i) {
            BibtexEntry bibtexEntry = _db.getEntryById(String.valueOf(i));
            if (!bibtexEntry.getField("bibtexkey").equals(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static String firstAuthor(String string) {
        String string2 = "";
        String[] stringArray = AuthorList.fixAuthorForAlphabetization(string).split("\\band\\b");
        if (stringArray.length > 0) {
            String[] stringArray2 = stringArray[0].replaceAll("\\s+", " ").split(" ");
            string2 = string2 + stringArray2[0];
        }
        return string2;
    }

    private static String allAuthors(String string) {
        String string2 = "";
        String[] stringArray = AuthorList.fixAuthorForAlphabetization(string).split("\\band\\b");
        for (int i = 0; stringArray.length > i; ++i) {
            String[] stringArray2 = stringArray[i].replaceAll("\\s+", " ").trim().split(" ");
            string2 = string2 + stringArray2[0];
        }
        return string2;
    }

    private static String NAuthors(String string, int n) {
        String string2 = "";
        String[] stringArray = AuthorList.fixAuthorForAlphabetization(string).split("\\band\\b");
        for (int i = 0; stringArray.length > i && i < n; ++i) {
            String[] stringArray2 = stringArray[i].replaceAll("\\s+", " ").trim().split(" ");
            string2 = string2 + stringArray2[0];
        }
        if (stringArray.length <= n) {
            return string2;
        }
        string2 = string2 + "EtAl";
        return string2;
    }

    private static String oneAuthorPlusIni(String string) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        String string2 = "";
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 0) {
            return string2;
        }
        String[] stringArray2 = stringArray[0].replaceAll("\\s+", " ").split(" ");
        string2 = stringArray2[0].substring(0, Math.min(5, stringArray2[0].length()));
        for (int i = 1; stringArray.length > i; ++i) {
            string2 = string2 + stringArray[i].trim().charAt(0);
        }
        return string2;
    }

    private static String authAuthEa(String string) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 0) {
            return "";
        }
        stringBuffer.append(stringArray[0].split(",")[0]);
        if (stringArray.length >= 2) {
            stringBuffer.append(".").append(stringArray[1].split(",")[0]);
        }
        if (stringArray.length > 2) {
            stringBuffer.append(".ea");
        }
        return stringBuffer.toString();
    }

    private static String authN_M(String string, int n, int n2) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length <= n2 || n < 0 || n2 < 0) {
            return "";
        }
        String string2 = stringArray[n2].split(",")[0].trim();
        if (string2.length() <= n) {
            return string2;
        }
        return string2.substring(0, n);
    }

    private static String authshort(String string) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\band\\b");
        if (stringArray.length == 1) {
            stringBuffer.append(LabelPatternUtil.authN_M(string, string.length(), 0));
        } else if (stringArray.length >= 2) {
            for (int i = 0; stringArray.length > i && i < 3; ++i) {
                stringBuffer.append(LabelPatternUtil.authN_M(string, 1, i));
            }
            if (stringArray.length > 3) {
                stringBuffer.append("+");
            }
        }
        return stringBuffer.toString();
    }

    private static String authIniN(String string, int n) {
        string = AuthorList.fixAuthorForAlphabetization(string);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("\\band\\b");
        int n2 = n / stringArray.length;
        if (stringArray.length == 0) {
            return stringBuffer.toString();
        }
        for (int i = 0; stringArray.length > i; ++i) {
            if (i < n % stringArray.length) {
                stringBuffer.append(LabelPatternUtil.authN_M(string, n2 + 1, i));
                continue;
            }
            stringBuffer.append(LabelPatternUtil.authN_M(string, n2, i));
        }
        if (stringBuffer.length() <= n) {
            return stringBuffer.toString();
        }
        return stringBuffer.toString().substring(0, n);
    }

    private static String firstPage(String string) {
        String[] stringArray = string.split("-");
        return stringArray[0];
    }

    private static String lastPage(String string) {
        String[] stringArray = string.split("-");
        return stringArray[1];
    }

    static {
        LabelPatternUtil.updateDefaultPattern();
    }
}

