/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.export.layout.format.XMLChars;
import net.sf.jabref.mods.PageNumbers;
import net.sf.jabref.mods.PersonName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MODSEntry {
    protected String entryType = "mods";
    protected String id;
    protected List authors = null;
    protected List editors = null;
    protected String issuance = "monographic";
    protected PageNumbers pages = null;
    protected String publisher = null;
    protected String date = null;
    protected String place = null;
    protected String title = null;
    protected String type = "text";
    protected String number;
    protected String volume;
    protected String genre = null;
    protected Set handledExtensions;
    protected MODSEntry host;
    Map extensionFields = new HashMap();
    public static String BIBTEX = "bibtex_";

    public MODSEntry() {
        this.handledExtensions = new HashSet();
    }

    public MODSEntry(BibtexEntry bibtexEntry) {
        this();
        this.handledExtensions.add(BIBTEX + "publisher");
        this.handledExtensions.add(BIBTEX + "title");
        this.handledExtensions.add(BIBTEX + "bibtexkey");
        this.handledExtensions.add(BIBTEX + "author");
        this.populateFromBibtex(bibtexEntry);
    }

    protected void populateFromBibtex(BibtexEntry bibtexEntry) {
        XMLChars xMLChars = new XMLChars();
        if (bibtexEntry.getField("title") != null) {
            this.title = xMLChars.format(bibtexEntry.getField("title").toString());
        }
        if (bibtexEntry.getField("publisher") != null) {
            this.publisher = xMLChars.format(bibtexEntry.getField("publisher").toString());
        }
        if (bibtexEntry.getField("bibtexkey") != null) {
            this.id = bibtexEntry.getField("bibtexkey").toString();
        }
        if (bibtexEntry.getField("place") != null) {
            this.place = xMLChars.format(bibtexEntry.getField("place").toString());
        }
        this.date = this.getDate(bibtexEntry);
        this.genre = this.getMODSgenre(bibtexEntry);
        if (bibtexEntry.getField("author") != null) {
            this.authors = this.getAuthors(bibtexEntry.getField("author").toString());
        }
        if (bibtexEntry.getType() == BibtexEntryType.ARTICLE || bibtexEntry.getType() == BibtexEntryType.INPROCEEDINGS) {
            this.host = new MODSEntry();
            this.host.entryType = "relatedItem";
            this.host.title = (String)bibtexEntry.getField("booktitle");
            this.host.publisher = (String)bibtexEntry.getField("publisher");
            this.host.number = (String)bibtexEntry.getField("number");
            if (bibtexEntry.getField("pages") != null) {
                this.host.volume = (String)bibtexEntry.getField("volume");
            }
            this.host.issuance = "continuing";
            if (bibtexEntry.getField("pages") != null) {
                this.host.pages = new PageNumbers((String)bibtexEntry.getField("pages"));
            }
        }
        this.populateExtensionFields(bibtexEntry);
    }

    protected void populateExtensionFields(BibtexEntry bibtexEntry) {
        Object[] objectArray = bibtexEntry.getAllFields();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            String string2 = (String)bibtexEntry.getField(string);
            string = BIBTEX + string;
            this.extensionFields.put(string, string2);
        }
    }

    protected List getAuthors(String string) {
        LinkedList<PersonName> linkedList = new LinkedList<PersonName>();
        XMLChars xMLChars = new XMLChars();
        if (string.indexOf(" and ") == -1) {
            linkedList.add(new PersonName(xMLChars.format(string)));
        } else {
            String[] stringArray = string.split(" and ");
            for (int i = 0; i < stringArray.length; ++i) {
                linkedList.add(new PersonName(xMLChars.format(stringArray[i])));
            }
        }
        return linkedList;
    }

    protected String getDate(BibtexEntry bibtexEntry) {
        String string = "";
        if (bibtexEntry.getField("year") != null) {
            string = string + bibtexEntry.getField("year").toString();
        }
        if (bibtexEntry.getField("month") != null) {
            string = string + "-" + bibtexEntry.getField("month").toString();
        }
        return string;
    }

    protected String getMODSgenre(BibtexEntry bibtexEntry) {
        String string = bibtexEntry.getType().getName();
        if (string.equals("Mastersthesis")) {
            String string2 = "theses";
        } else {
            String string3 = "conference publication";
        }
        return string;
    }

    public Document getDOMrepresentation() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return document;
    }

    public Element getDOMrepresentation(Document document) {
        Object var2_2 = null;
        try {
            Element element;
            Object object;
            Element element2;
            Object object2;
            Object object3;
            Element element3 = document.createElement(this.entryType);
            element3.setAttribute("version", "3.0");
            if (this.title != null) {
                object3 = document.createElement("titleInfo");
                object2 = document.createElement("title");
                object2.appendChild(document.createTextNode(this.title));
                object3.appendChild((Node)object2);
                element3.appendChild((Node)object3);
            }
            if (this.authors != null) {
                object3 = this.authors.iterator();
                while (object3.hasNext()) {
                    object2 = (PersonName)object3.next();
                    element2 = document.createElement("name");
                    element2.setAttribute("type", "personal");
                    if (((PersonName)object2).getSurname() != null) {
                        object = document.createElement("namePart");
                        object.setAttribute("type", "family");
                        object.appendChild(document.createTextNode(((PersonName)object2).getSurname()));
                        element2.appendChild((Node)object);
                    }
                    if (((PersonName)object2).getGivenNames() != null) {
                        object = document.createElement("namePart");
                        object.setAttribute("type", "given");
                        object.appendChild(document.createTextNode(((PersonName)object2).getGivenNames()));
                        element2.appendChild((Node)object);
                    }
                    object = document.createElement("role");
                    element = document.createElement("roleTerm");
                    element.setAttribute("type", "text");
                    element.appendChild(document.createTextNode("author"));
                    object.appendChild(element);
                    element2.appendChild((Node)object);
                    element3.appendChild(element2);
                }
            }
            object3 = document.createElement("originInfo");
            element3.appendChild((Node)object3);
            if (this.publisher != null) {
                object2 = document.createElement("publisher");
                object2.appendChild(document.createTextNode(this.publisher));
                object3.appendChild((Node)object2);
            }
            if (this.date != null) {
                object2 = document.createElement("dateIssued");
                object2.appendChild(document.createTextNode(this.date));
                object3.appendChild((Node)object2);
            }
            object2 = document.createElement("issuance");
            object2.appendChild(document.createTextNode(this.issuance));
            object3.appendChild((Node)object2);
            if (this.id != null) {
                element2 = document.createElement("identifier");
                element2.appendChild(document.createTextNode(this.id));
                element3.appendChild(element2);
                element3.setAttribute("ID", this.id);
            }
            element2 = document.createElement("typeOfResource");
            element2.appendChild(document.createTextNode(this.type));
            element3.appendChild(element2);
            if (this.genre != null) {
                object = document.createElement("genre");
                object.setAttribute("authority", "marc");
                object.appendChild(document.createTextNode(this.genre));
                element3.appendChild((Node)object);
            }
            if (this.host != null) {
                object = this.host.getDOMrepresentation(document);
                object.setAttribute("type", "host");
                element3.appendChild((Node)object);
            }
            if (this.pages != null) {
                element3.appendChild(this.pages.getDOMrepresentation(document));
            }
            object = this.extensionFields.entrySet().iterator();
            while (object.hasNext()) {
                element = document.createElement("extension");
                Map.Entry entry = (Map.Entry)object.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (this.handledExtensions.contains(string)) continue;
                Element element4 = document.createElement(string);
                element4.appendChild(document.createTextNode(string2));
                element.appendChild(element4);
                element3.appendChild(element);
            }
            return element3;
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
            throw new Error(exception);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMSource dOMSource = new DOMSource(this.getDOMrepresentation());
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return stringWriter.toString();
    }
}

