/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.export.layout.format.RemoveBrackets;

public class BasicSearch
implements SearchRule {
    private boolean caseSensitive;
    private boolean regExp;
    Pattern[] pattern;
    static RemoveBrackets removeBrackets = new RemoveBrackets();

    public BasicSearch(boolean bl, boolean bl2) {
        this.caseSensitive = bl;
        this.regExp = bl2;
    }

    private static void print(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.print("'" + string + "' ");
        }
        System.out.println();
    }

    public int applyRule(String string, BibtexEntry bibtexEntry) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("1", string);
        return this.applyRule(hashMap, bibtexEntry);
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) {
        int n;
        int n2 = 0;
        String string = (String)map.values().iterator().next();
        if (!this.caseSensitive) {
            string = string.toLowerCase();
            n2 = 2;
        }
        ArrayList arrayList = this.parseQuery(string);
        if (this.regExp) {
            this.pattern = new Pattern[arrayList.size()];
            for (int i = 0; i < this.pattern.length; ++i) {
                this.pattern[i] = Pattern.compile((String)arrayList.get(i), n2);
            }
        }
        boolean[] blArray = new boolean[arrayList.size()];
        Object[] objectArray = bibtexEntry.getAllFields();
        for (n = 0; n < objectArray.length; ++n) {
            Object object = bibtexEntry.getField(objectArray[n].toString());
            if (object == null) continue;
            String string2 = removeBrackets.format(object.toString());
            if (!this.caseSensitive) {
                string2 = string2.toLowerCase();
            }
            int n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object2;
                if (!this.regExp) {
                    object2 = (String)arrayList.get(i);
                    blArray[n3] = blArray[n3] || string2.indexOf((String)object2) >= 0;
                } else if (string2 != null) {
                    object2 = this.pattern[i].matcher(removeBrackets.format(string2));
                    blArray[n3] = blArray[n3] || ((Matcher)object2).find();
                }
                ++n3;
            }
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            return 0;
        }
        return 1;
    }

    private ArrayList parseQuery(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl && c == '\\') {
                bl = true;
                continue;
            }
            if (!bl && !bl2 && Character.isWhitespace(c)) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
            } else if (c == '\"') {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                bl2 = !bl2;
            } else {
                stringBuffer.append(c);
            }
            bl = false;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }
}

