/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMPSchemaBibtex
extends XMPSchema {
    public static final String NAMESPACE = "http://jabref.sourceforge.net/bibteXMP/";
    public static final String KEY = "bibtex";
    public static HashMap preserveWhiteSpace = new HashMap();

    public XMPSchemaBibtex(XMPMetadata xMPMetadata) {
        super(xMPMetadata, KEY, NAMESPACE);
    }

    public XMPSchemaBibtex(Element element, String string) {
        super(element, KEY);
    }

    protected String makeProperty(String string) {
        return "bibtex:" + string;
    }

    public List getPersonList(String string) {
        return this.getSequenceList(string);
    }

    public void setPersonList(String string, String string2) {
        AuthorList authorList = AuthorList.getAuthorList(string2);
        int n = authorList.size();
        for (int i = 0; i < n; ++i) {
            this.addSequenceValue(string, authorList.getAuthor(i).getFirstLast(false));
        }
    }

    public String getTextProperty(String string) {
        return super.getTextProperty(this.makeProperty(string));
    }

    public void setTextProperty(String string, String string2) {
        super.setTextProperty(this.makeProperty(string), string2);
    }

    public List getBagList(String string) {
        return super.getBagList(this.makeProperty(string));
    }

    public void removeBagValue(String string, String string2) {
        super.removeBagValue(this.makeProperty(string), string2);
    }

    public void addBagValue(String string, String string2) {
        super.addBagValue(this.makeProperty(string), string2);
    }

    public List getSequenceList(String string) {
        return super.getSequenceList(this.makeProperty(string));
    }

    public void removeSequenceValue(String string, String string2) {
        super.removeSequenceValue(this.makeProperty(string), string2);
    }

    public void addSequenceValue(String string, String string2) {
        super.addSequenceValue(this.makeProperty(string), string2);
    }

    public List getSequenceDateList(String string) throws IOException {
        return super.getSequenceDateList(this.makeProperty(string));
    }

    public void removeSequenceDateValue(String string, Calendar calendar) {
        super.removeSequenceDateValue(this.makeProperty(string), calendar);
    }

    public void addSequenceDateValue(String string, Calendar calendar) {
        super.addSequenceDateValue(this.makeProperty(string), calendar);
    }

    public static String getContents(NodeList nodeList) {
        Element element = (Element)nodeList.item(0);
        StringBuffer stringBuffer = null;
        NodeList nodeList2 = element.getElementsByTagName("rdf:li");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2 = (Element)nodeList2.item(i);
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(XMPSchemaBibtex.getTextContent(element2));
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public static Map getAllProperties(XMPSchema xMPSchema, String string) {
        Object object;
        Object object2;
        Object object3;
        NodeList nodeList = xMPSchema.getElement().getChildNodes();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (nodeList == null) {
            return hashMap;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 2 && node.getNodeType() != 1 || ((String[])(object3 = (string2 = node.getNodeName()).split(":"))).length != 2 || !((String)object3[0]).equals(string)) continue;
            object2 = ((Element)node).getElementsByTagName("rdf:Seq");
            if (object2.getLength() > 0) {
                object = XMPSchemaBibtex.getContents((NodeList)object2);
                if (object == null) continue;
                hashMap.put(object3[1], object);
                continue;
            }
            object = ((Element)node).getElementsByTagName("rdf:Bag");
            if (object.getLength() > 0) {
                String string3 = XMPSchemaBibtex.getContents((NodeList)object);
                if (string3 == null) continue;
                hashMap.put(object3[1], string3);
                continue;
            }
            hashMap.put(object3[1], XMPSchemaBibtex.getTextContent(node));
        }
        NamedNodeMap namedNodeMap = xMPSchema.getElement().getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            object3 = namedNodeMap.item(i);
            object2 = object3.getNodeName();
            object = ((String)object2).split(":");
            if (((String[])object).length != 2 || !object[0].equals(string)) continue;
            hashMap.put(object[1], object3.getNodeValue());
        }
        Set set = hashMap.entrySet();
        object3 = set.iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (String)object2.getKey();
            if (preserveWhiteSpace.containsKey(object)) continue;
            object2.setValue(((String)object2.getValue()).replaceAll("\\s+", " ").trim());
        }
        return hashMap;
    }

    public void setBibtexEntry(BibtexEntry bibtexEntry) {
        int n;
        Object[] objectArray;
        Object[] objectArray2 = bibtexEntry.getAllFields();
        JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        if (jabRefPreferences.getBoolean("useXmpPrivacyFilter")) {
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(jabRefPreferences.getStringArray("xmpPrivacyFilter")));
            objectArray = new Object[objectArray2.length];
            n = 0;
            for (int i = 0; i < objectArray2.length; ++i) {
                if (treeSet.contains(objectArray2[i])) continue;
                objectArray[n++] = objectArray2[i];
            }
        } else {
            objectArray = objectArray2;
            n = objectArray2.length;
        }
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i].toString();
            if (string.equals("author") || string.equals("editor")) {
                this.setPersonList(string, bibtexEntry.getField(string).toString());
                continue;
            }
            this.setTextProperty(string, bibtexEntry.getField(string).toString());
        }
        this.setTextProperty("entrytype", bibtexEntry.getType().getName());
    }

    public BibtexEntry getBibtexEntry() {
        String string = this.getTextProperty("entrytype");
        BibtexEntryType bibtexEntryType = string != null ? BibtexEntryType.getStandardType(string) : BibtexEntryType.OTHER;
        BibtexEntry bibtexEntry = new BibtexEntry(Util.createNeutralId(), bibtexEntryType);
        Map map = XMPSchemaBibtex.getAllProperties(this, KEY);
        map.remove("entrytype");
        bibtexEntry.setField(map);
        return bibtexEntry;
    }

    public static String getTextContent(Node node) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            stringBuffer.append(node2.getNodeValue());
            bl = true;
        }
        return bl ? stringBuffer.toString() : "";
    }

    static {
        preserveWhiteSpace.put("abstract", null);
        preserveWhiteSpace.put("note", null);
        preserveWhiteSpace.put("review", null);
    }
}

