/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;

public class AuxSubGenerator {
    private HashSet mySet = new HashSet(20);
    private Vector notFoundList = new Vector();
    private BibtexDatabase db;
    private BibtexDatabase auxDB;
    private int nestedAuxCounter;
    private int crossreferencedEntriesCount = 0;

    public AuxSubGenerator(BibtexDatabase bibtexDatabase) {
        this.db = bibtexDatabase;
    }

    public final void setReferenceDatabase(BibtexDatabase bibtexDatabase) {
        this.db = bibtexDatabase;
    }

    public final boolean parseAuxFile(String string) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        Pattern pattern = Pattern.compile("\\\\citation\\{.+\\}");
        BufferedReader bufferedReader = null;
        Vector<String> vector = new Vector<String>(5);
        vector.add(string);
        File file = new File(string);
        String string2 = file.getParent();
        string2 = string2 != null ? string2 + File.separator : "";
        this.nestedAuxCounter = -1;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            try {
                bufferedReader = new BufferedReader(new FileReader(string3));
                bl = true;
                bl3 = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot locate input file! " + fileNotFoundException.getMessage());
                bl2 = false;
                bl = false;
                bl3 = false;
            }
            while (bl) {
                String string4;
                try {
                    string4 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    string4 = null;
                    bl = false;
                }
                if (string4 != null) {
                    String string5;
                    int n;
                    int n2;
                    Matcher matcher = pattern.matcher(string4);
                    while (matcher.find()) {
                        String string6;
                        String[] stringArray;
                        int n3 = matcher.end() - matcher.start();
                        if (n3 <= 11 || (stringArray = (string6 = matcher.group().substring(matcher.start() + 10, matcher.end() - 1)).split(",")) == null) continue;
                        int n4 = stringArray.length;
                        for (int j = 0; j < n4; ++j) {
                            String string7 = stringArray[j];
                            if (string7 == null) continue;
                            this.mySet.add(string7.trim());
                        }
                    }
                    int n5 = string4.indexOf("\\@input{");
                    if (n5 < 0 || (n2 = string4.indexOf("}", n = n5 + 8)) <= n || vector.contains(string5 = string2 + string4.substring(n5 + 8, n2))) continue;
                    vector.add(string5);
                    continue;
                }
                bl = false;
            }
            if (!bl3) continue;
            try {
                bufferedReader.close();
                ++this.nestedAuxCounter;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl2;
    }

    public final void resolveTags() {
        this.auxDB = new BibtexDatabase();
        this.notFoundList.clear();
        Iterator iterator = this.mySet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BibtexEntry bibtexEntry = this.db.getEntryByKey(string);
            if (bibtexEntry == null) {
                this.notFoundList.add(string);
                continue;
            }
            this.insertEntry(this.auxDB, bibtexEntry);
            String string2 = (String)bibtexEntry.getField("crossref");
            if (string2 == null || this.mySet.contains(string2)) continue;
            BibtexEntry bibtexEntry2 = this.db.getEntryByKey(string2);
            if (bibtexEntry == null) {
                this.notFoundList.add(string2);
                continue;
            }
            this.insertEntry(this.auxDB, bibtexEntry2);
            ++this.crossreferencedEntriesCount;
        }
    }

    private void insertEntry(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        try {
            BibtexEntry bibtexEntry2 = (BibtexEntry)bibtexEntry.clone();
            bibtexEntry2.setId(Util.createNeutralId());
            bibtexDatabase.insertEntry(bibtexEntry2);
        }
        catch (KeyCollisionException keyCollisionException) {
            keyCollisionException.printStackTrace();
        }
    }

    public final Vector generate(String string, BibtexDatabase bibtexDatabase) {
        this.setReferenceDatabase(bibtexDatabase);
        this.parseAuxFile(string);
        this.resolveTags();
        return this.notFoundList;
    }

    public BibtexDatabase getGeneratedDatabase() {
        if (this.auxDB == null) {
            this.auxDB = new BibtexDatabase();
        }
        return this.auxDB;
    }

    public final int getFoundKeysInAux() {
        return this.mySet.size();
    }

    public final int getResolvedKeysCount() {
        return this.auxDB.getEntryCount() - this.crossreferencedEntriesCount;
    }

    public final int getNotResolvedKeysCount() {
        return this.notFoundList.size();
    }

    public final int getCrossreferencedEntriesCount() {
        return this.crossreferencedEntriesCount;
    }

    public final void clear() {
        this.mySet.clear();
        this.notFoundList.clear();
        this.crossreferencedEntriesCount = 0;
    }

    public Vector getNotFoundList() {
        return this.notFoundList;
    }

    public int getNestedAuxCounter() {
        return this.nestedAuxCounter;
    }
}

