/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.util.List;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;

public class XMPSchemaRightsManagement
extends XMPSchema {
    public static final String NAMESPACE = "http://ns.adobe.com/xap/1.0/rights/";

    public XMPSchemaRightsManagement(XMPMetadata parent) {
        super(parent, "xmpRights", NAMESPACE);
    }

    public XMPSchemaRightsManagement(Element element, String prefix) {
        super(element, prefix);
    }

    public void setCertificateURL(String certificate) {
        this.setTextProperty("xmpRights:Certificate", certificate);
    }

    public String getCertificateURL() {
        return this.getTextProperty(this.prefix + ":Certificate");
    }

    public void setMarked(Boolean marked) {
        this.setBooleanProperty(this.prefix + ":Marked", marked);
    }

    public Boolean getMarked() {
        return this.getBooleanProperty(this.prefix + ":Marked");
    }

    public void removeOwner(String owner) {
        this.removeBagValue(this.prefix + ":Ownder", owner);
    }

    public void addOwner(String owner) {
        this.addBagValue(this.prefix + ":Owner", owner);
    }

    public List getOwners() {
        return this.getBagList(this.prefix + ":Owner");
    }

    public void setUsageTerms(String terms) {
        this.setLanguageProperty(this.prefix + ":UsageTerms", null, terms);
    }

    public String getUsageTerms() {
        return this.getLanguageProperty(this.prefix + ":UsageTerms", null);
    }

    public void setDescription(String language, String terms) {
        this.setLanguageProperty(this.prefix + ":UsageTerms", language, terms);
    }

    public String getUsageTerms(String language) {
        return this.getLanguageProperty(this.prefix + ":UsageTerms", language);
    }

    public List getUsageTermsLanguages() {
        return this.getLanguagePropertyLanguages(this.prefix + ":UsageTerms");
    }

    public void setWebStatement(String webStatement) {
        this.setTextProperty(this.prefix + ":WebStatement", webStatement);
    }

    public String getWebStatement() {
        return this.getTextProperty(this.prefix + ":WebStatement");
    }

    public void setCopyright(String copyright) {
        this.setTextProperty(this.prefix + ":Copyright", copyright);
    }

    public String getCopyright() {
        return this.getTextProperty(this.prefix + ":Copyright");
    }
}

