/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.pdfbox.pdmodel.interactive.form.PDChoiceButton;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.pdfbox.util.BitFlagHelper;

public class PDRadioCollection
extends PDChoiceButton {
    public static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDRadioCollection(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return BitFlagHelper.getFlag(this.getDictionary(), "Ff", 0x2000000);
    }

    public void setValue(String value) throws IOException {
        this.getDictionary().setString("V", value);
        List kids = this.getKids();
        for (int i = 0; i < kids.size(); ++i) {
            PDCheckbox btn = (PDCheckbox)kids.get(i);
            if (btn.getOnValue().equals(value)) {
                btn.check();
                continue;
            }
            btn.unCheck();
        }
    }

    public String getValue() throws IOException {
        String retval = null;
        List kids = this.getKids();
        for (int i = 0; i < kids.size(); ++i) {
            PDCheckbox btn = (PDCheckbox)kids.get(i);
            if (!btn.isChecked()) continue;
            retval = btn.getOnValue();
        }
        if (retval == null) {
            retval = this.getDictionary().getNameAsString("V");
        }
        return retval;
    }

    public List getKids() throws IOException {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDField> kidsList = new ArrayList<PDField>();
            for (int i = 0; i < kids.size(); ++i) {
                kidsList.add(PDFieldFactory.createField(this.getAcroForm(), (COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }
}

