/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradient;

import com.michaelbaranov.microba.Microba;
import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.gradient.DefaultGradientModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class GradientBar
extends JComponent {
    public static final String PROPERTY_DATA_MODEL = "dataModel";
    public static final String PROPERTY_ALPHA_MODEL = "alphaModel";
    public static final String PROPERTY_COLOR_POSITION_COLUMN = "colorPositionColumn";
    public static final String PROPERTY_ALPHA_POSITION_COLUMN = "alphaPositionColumn";
    public static final String PROPERTY_COLOR_COLUMN = "colorColumn";
    public static final String PROPERTY_ALPHA_COLUMN = "alphaColumn";
    public static final String PROPERTY_ORIENTATION = "orientation";
    private static final String uiClassID = "microba.GradientUI";
    protected BoundedTableModel dataModel;
    protected BoundedTableModel alphaModel;
    protected int colorPositionColumn = 0;
    protected int alphaPositionColumn = 0;
    protected int colorColumn = 1;
    protected int alphaColumn = 1;
    protected int orientation = 0;

    public ComponentUI getUI() {
        return this.ui;
    }

    public void updateUI() {
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public GradientBar() {
        this.dataModel = new DefaultGradientModel();
        this.setFocusable(false);
        this.updateUI();
    }

    public GradientBar(BoundedTableModel model) {
        this.dataModel = model;
        this.setFocusable(false);
        this.updateUI();
    }

    public GradientBar(BoundedTableModel model, int orientation) {
        this.dataModel = model;
        this.orientation = orientation;
        this.setFocusable(false);
        this.updateUI();
    }

    public int getColorColumn() {
        return this.colorColumn;
    }

    public void setColorColumn(int colorColumn) {
        int old = this.colorColumn;
        this.colorColumn = colorColumn;
        this.firePropertyChange(PROPERTY_COLOR_COLUMN, old, colorColumn);
    }

    public int getAlphaColumn() {
        return this.alphaColumn;
    }

    public void setAlphaColumn(int alphaColumn) {
        int old = this.colorColumn;
        this.alphaColumn = alphaColumn;
        this.firePropertyChange(PROPERTY_ALPHA_COLUMN, old, alphaColumn);
    }

    public BoundedTableModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(BoundedTableModel dataModel) {
        BoundedTableModel old = this.dataModel;
        this.dataModel = dataModel;
        this.firePropertyChange(PROPERTY_DATA_MODEL, old, dataModel);
    }

    public BoundedTableModel getAlphaModel() {
        return this.alphaModel;
    }

    public void setAlphaModel(BoundedTableModel alphaModel) {
        BoundedTableModel old = this.alphaModel;
        this.alphaModel = alphaModel;
        this.firePropertyChange(PROPERTY_ALPHA_MODEL, old, alphaModel);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        int old = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange(PROPERTY_ORIENTATION, old, orientation);
    }

    public int getColorPositionColumn() {
        return this.colorPositionColumn;
    }

    public void setColorPositionColumn(int positionColumn) {
        int old = this.colorPositionColumn;
        this.colorPositionColumn = positionColumn;
        this.firePropertyChange(PROPERTY_COLOR_POSITION_COLUMN, old, positionColumn);
    }

    public int getAlphaPositionColumn() {
        return this.alphaPositionColumn;
    }

    public void setAlphaPositionColumn(int positionColumn) {
        int old = this.alphaPositionColumn;
        this.alphaPositionColumn = positionColumn;
        this.firePropertyChange(PROPERTY_ALPHA_POSITION_COLUMN, old, positionColumn);
    }

    static {
        Microba.init();
    }
}

