/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.journals.JournalAbbreviations;
import net.sf.jabref.remote.RemoteListener;

public class AdvancedTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    HelpDialog helpDiag;
    HelpAction remoteHelp;
    JPanel pan = new JPanel();
    JPanel lnf = new JPanel();
    JLabel lab;
    JCheckBox useDefault;
    JCheckBox useRemoteServer;
    JCheckBox useNativeFileDialogOnMac;
    JCheckBox filechooserDisableRename;
    JCheckBox useIEEEAbrv;
    JTextField className;
    JTextField remoteServerPort;
    JButton def1 = new JButton(Globals.lang("Default"));
    JButton def2 = new JButton(Globals.lang("Default"));
    JPanel p1 = new JPanel();
    JPanel p2 = new JPanel();
    String oldLnf = "";
    boolean oldUseDef;
    int oldPort = -1;

    public AdvancedTab(JabRefPreferences prefs, HelpDialog diag) {
        this._prefs = prefs;
        this.remoteHelp = new HelpAction(diag, GUIGlobals.remoteHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.useDefault = new JCheckBox(Globals.lang("Use other look and feel"));
        this.useRemoteServer = new JCheckBox(Globals.lang("Listen for remote operation on port") + ":");
        this.useNativeFileDialogOnMac = new JCheckBox(Globals.lang("Use native file dialog"));
        this.filechooserDisableRename = new JCheckBox(Globals.lang("Disable file renaming in non-native file dialog"));
        this.useIEEEAbrv = new JCheckBox(Globals.lang("Use IEEE LaTeX abbreviations"));
        this.remoteServerPort = new JTextField();
        final JTextField clName = this.className = new JTextField(50);
        this.useDefault.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                clName.setEnabled(((JCheckBox)e.getSource()).isSelected());
            }
        });
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        if (!Globals.ON_MAC) {
            builder.appendSeparator(Globals.lang("Look and feel"));
            JLabel lab = new JLabel(Globals.lang("Default look and feel") + ": " + (Globals.ON_WIN ? GUIGlobals.windowsDefaultLookAndFeel : GUIGlobals.linuxDefaultLookAndFeel));
            builder.nextLine();
            builder.append(pan);
            builder.append(lab);
            builder.nextLine();
            builder.append(pan);
            builder.append(this.useDefault);
            builder.nextLine();
            builder.append(pan);
            JPanel pan2 = new JPanel();
            lab = new JLabel(Globals.lang("Class name") + ":");
            pan2.add(lab);
            pan2.add(this.className);
            builder.append(pan2);
            builder.nextLine();
            builder.append(pan);
            lab = new JLabel(Globals.lang("Note that you must specify the fully qualified class name for the look and feel,"));
            builder.append(lab);
            builder.nextLine();
            builder.append(pan);
            lab = new JLabel(Globals.lang("and the class must be available in your classpath next time you start JabRef."));
            builder.append(lab);
            builder.nextLine();
        }
        builder.appendSeparator(Globals.lang("Remote operation"));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(new JLabel("<html>" + Globals.lang("This feature lets new files be opened or imported into an already running instance of JabRef<BR>instead of opening a new instance. For instance, this is useful when you open a file in JabRef<br>from your web browser.<BR>Note that this will prevent you from running more than one instance of JabRef at a time.") + "</html>"));
        builder.nextLine();
        builder.append(new JPanel());
        JPanel p = new JPanel();
        p.add(this.useRemoteServer);
        p.add(this.remoteServerPort);
        p.add(this.remoteHelp.getIconButton());
        builder.append(p);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("File dialog"));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.useNativeFileDialogOnMac);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.filechooserDisableRename);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Search IEEEXplore"));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.useIEEEAbrv);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)pan, "Center");
    }

    public void setValues() {
        this.oldUseDef = this._prefs.getBoolean("useDefaultLookAndFeel");
        this.oldLnf = this._prefs.get("lookAndFeel");
        this.useDefault.setSelected(!this.oldUseDef);
        this.className.setText(this.oldLnf);
        this.className.setEnabled(!this.oldUseDef);
        this.useRemoteServer.setSelected(this._prefs.getBoolean("useRemoteServer"));
        this.oldPort = this._prefs.getInt("remoteServerPort");
        this.remoteServerPort.setText(String.valueOf(this.oldPort));
        this.useNativeFileDialogOnMac.setSelected(Globals.prefs.getBoolean("useNativeFileDialogOnMac"));
        this.filechooserDisableRename.setSelected(Globals.prefs.getBoolean("filechooserDisableRename"));
        this.useIEEEAbrv.setSelected(Globals.prefs.getBoolean("useIEEEAbrv"));
    }

    public void storeSettings() {
        this._prefs.putBoolean("useDefaultLookAndFeel", !this.useDefault.isSelected());
        this._prefs.put("lookAndFeel", this.className.getText());
        this._prefs.putBoolean("useNativeFileDialogOnMac", this.useNativeFileDialogOnMac.isSelected());
        this._prefs.putBoolean("filechooserDisableRename", this.filechooserDisableRename.isSelected());
        UIManager.put("FileChooser.readOnly", this.filechooserDisableRename.isSelected());
        this._prefs.putBoolean("useIEEEAbrv", this.useIEEEAbrv.isSelected());
        if (this.useIEEEAbrv.isSelected()) {
            Globals.journalAbbrev = new JournalAbbreviations("/resource/IEEEJournalList.txt");
        }
        try {
            int port = Integer.parseInt(this.remoteServerPort.getText());
            if (port != this.oldPort) {
                this._prefs.putInt("remoteServerPort", port);
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        this._prefs.putBoolean("useRemoteServer", this.useRemoteServer.isSelected());
        if (this.useRemoteServer.isSelected() && JabRef.remoteListener == null) {
            JabRef.remoteListener = RemoteListener.openRemoteListener(JabRef.singleton);
            if (JabRef.remoteListener != null) {
                JabRef.remoteListener.start();
            }
        } else if (!this.useRemoteServer.isSelected() && JabRef.remoteListener != null) {
            JabRef.remoteListener.disable();
            JabRef.remoteListener = null;
        }
        if (this.useDefault.isSelected() == this.oldUseDef || !this.oldLnf.equals(this.className.getText())) {
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the look and feel setting. You must restart JabRef for this to come into effect."), Globals.lang("Changed look and feel settings"), 2);
        }
    }

    public boolean readyToClose() {
        try {
            Integer.parseInt(this.remoteServerPort.getText());
            return true;
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, Globals.lang("You must enter an integer value in the text field for") + " '" + Globals.lang("Remote server port") + "'", Globals.lang("Remote server port"), 0);
            return false;
        }
    }

    public String getTabName() {
        return Globals.lang("Advanced");
    }
}

