/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsDialog3;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.external.ExternalFileTypeEditor;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.external.PushToApplicationButton;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToVim;
import net.sf.jabref.external.PushToWinEdt;

public class ExternalTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    JTextField pdfDir;
    JTextField regExpTextField;
    JTextField fileDir;
    JTextField psDir;
    JCheckBox runAutoFileSearch;
    JButton editFileTypes;
    ItemListener regExpListener;
    JRadioButton useRegExpComboBox;
    JRadioButton matchExactKeyOnly = new JRadioButton(Globals.lang("Autolink only files that match the BibTeX key"));
    JRadioButton matchStartsWithKey = new JRadioButton(Globals.lang("Autolink files with names starting with the BibTeX key"));

    public ExternalTab(JabRefFrame frame, PrefsDialog3 prefsDiag, JabRefPreferences prefs, HelpDialog helpDialog) {
        this._prefs = prefs;
        this._frame = frame;
        this.setLayout(new BorderLayout());
        this.psDir = new JTextField(25);
        this.pdfDir = new JTextField(25);
        this.fileDir = new JTextField(25);
        this.editFileTypes = new JButton(Globals.lang("Manage external file types"));
        this.runAutoFileSearch = new JCheckBox(Globals.lang("When opening file link, search for matching file if no link is defined"));
        this.regExpTextField = new JTextField(25);
        this.useRegExpComboBox = new JRadioButton(Globals.lang("Use Regular Expression Search"));
        this.regExpListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExternalTab.this.regExpTextField.setEditable(ExternalTab.this.useRegExpComboBox.isSelected());
            }
        };
        this.useRegExpComboBox.addItemListener(this.regExpListener);
        this.editFileTypes.addActionListener(ExternalFileTypeEditor.getAction(prefsDiag));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.matchExactKeyOnly);
        bg.add(this.matchStartsWithKey);
        bg.add(this.useRegExpComboBox);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("External file links"));
        JPanel pan = new JPanel();
        builder.append(pan);
        JLabel lab = new JLabel(Globals.lang("Main file directory") + ":");
        builder.append(lab);
        builder.append(this.fileDir);
        BrowseAction browse = new BrowseAction(this._frame, this.fileDir, true);
        builder.append(new JButton(browse));
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.matchStartsWithKey, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.matchExactKeyOnly, 3);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append(this.useRegExpComboBox);
        builder.append(this.regExpTextField);
        HelpAction helpAction = new HelpAction(helpDialog, GUIGlobals.regularExpressionSearchHelp, Globals.lang("Help on Regular Expression Search"), GUIGlobals.getIconUrl("helpSmall"));
        builder.append(helpAction.getIconButton());
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.runAutoFileSearch, 3);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Legacy file fields"));
        pan = new JPanel();
        builder.append(pan);
        builder.append((Component)new JLabel("<html>" + Globals.lang("Note that these settings are used for the legacy <b>pdf</b> and <b>ps</b> fields only.<br>For most users, setting the <b>Main file directory</b> above should be sufficient.") + "</html>"), 5);
        builder.nextLine();
        pan = new JPanel();
        builder.append(pan);
        lab = new JLabel(Globals.lang("Main PDF directory") + ":");
        builder.append(lab);
        builder.append(this.pdfDir);
        browse = new BrowseAction(this._frame, this.pdfDir, true);
        builder.append(new JButton(browse));
        builder.nextLine();
        pan = new JPanel();
        builder.append(pan);
        lab = new JLabel(Globals.lang("Main PS directory") + ":");
        builder.append(lab);
        builder.append(this.psDir);
        browse = new BrowseAction(this._frame, this.psDir, true);
        builder.append(new JButton(browse));
        builder.nextLine();
        builder.appendSeparator(Globals.lang("External programs"));
        builder.nextLine();
        this.addSettingsButton(new PushToLyx(), builder);
        this.addSettingsButton(new PushToEmacs(), builder);
        this.addSettingsButton(new PushToWinEdt(), builder);
        this.addSettingsButton(new PushToVim(), builder);
        this.addSettingsButton(new PushToLatexEditor(), builder);
        builder.append(pan);
        builder.append(this.editFileTypes);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    private void addSettingsButton(final PushToApplication pt, DefaultFormBuilder b) {
        b.append(new JPanel());
        b.append(Globals.lang("Settings for %0", pt.getName()) + ":");
        JButton button = new JButton(pt.getIcon());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PushToApplicationButton.showSettingsDialog(ExternalTab.this._frame, pt, pt.getSettingsPanel());
            }
        });
        b.append(button);
        b.nextLine();
    }

    public void setValues() {
        this.pdfDir.setText(this._prefs.get("pdfDirectory"));
        this.psDir.setText(this._prefs.get("psDirectory"));
        this.fileDir.setText(this._prefs.get("fileDirectory"));
        this.runAutoFileSearch.setSelected(this._prefs.getBoolean("runAutomaticFileSearch"));
        this.regExpTextField.setText(this._prefs.get("regExpSearchExpression"));
        if (this._prefs.getBoolean("useRegExpSearch")) {
            this.useRegExpComboBox.setSelected(true);
        } else if (this._prefs.getBoolean("autolinkExactKeyOnly")) {
            this.matchExactKeyOnly.setSelected(true);
        } else {
            this.matchStartsWithKey.setSelected(true);
        }
    }

    public void storeSettings() {
        this._prefs.putBoolean("useRegExpSearch", this.useRegExpComboBox.isSelected());
        if (this.useRegExpComboBox.isSelected()) {
            this._prefs.put("regExpSearchExpression", this.regExpTextField.getText());
        }
        this._prefs.put("pdfDirectory", this.pdfDir.getText());
        this._prefs.put("psDirectory", this.psDir.getText());
        this._prefs.put("fileDirectory", this.fileDir.getText());
        this._prefs.putBoolean("autolinkExactKeyOnly", this.matchExactKeyOnly.isSelected());
        this._prefs.putBoolean("runAutomaticFileSearch", this.runAutoFileSearch.isSelected());
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("External programs");
    }
}

