/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.util.CaseChangeMenu;

public class FieldTextMenu
implements MouseListener {
    private FieldEditor myFieldName;
    private JPopupMenu inputMenu = new JPopupMenu();
    private CopyAction copyAct = new CopyAction();
    private PasteAction pasteAct = new PasteAction();

    public FieldTextMenu(FieldEditor fieldComponent) {
        this.myFieldName = fieldComponent;
        this.inputMenu.add(this.pasteAct);
        this.inputMenu.add(this.copyAct);
        this.inputMenu.addSeparator();
        this.inputMenu.add(new ReplaceAction());
        if (this.myFieldName.getTextComponent() instanceof JTextComponent) {
            this.inputMenu.add(new CaseChangeMenu((JTextComponent)this.myFieldName.getTextComponent()));
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger() && this.myFieldName != null) {
            this.myFieldName.requestFocus();
            String txt = this.myFieldName.getSelectedText();
            boolean cStat = false;
            if (txt != null && txt.length() > 0) {
                cStat = true;
            }
            this.copyAct.setEnabled(cStat);
            this.inputMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static String generalFixAuthor(String in) {
        String[] authors = in.split("( |,)and ", -1);
        for (int i = 0; i < authors.length; ++i) {
            authors[i] = authors[i].trim();
        }
        String author = authors[authors.length - 1];
        boolean lnfn = author.indexOf(",") > 0;
        StringBuffer sb = new StringBuffer();
        if (lnfn) {
            for (int i = 0; i < authors.length; ++i) {
                String[] parts = authors[i].split(",", -1);
                if (parts.length == 2) {
                    parts[0] = parts[0].trim().replaceAll(" ", "~");
                    parts[1] = parts[1].trim().replaceAll(" ", "~");
                    sb.append(parts[1] + " " + parts[0]);
                } else {
                    sb.append(authors[i]);
                }
                if (i >= authors.length - 1) continue;
                sb.append(" and ");
            }
        } else {
            for (int i = 0; i < authors.length; ++i) {
                String[] iAuthors = authors[i].split(",");
                for (int j = 0; j < iAuthors.length; ++j) {
                    iAuthors[j] = iAuthors[j].trim();
                    String[] ijparts = iAuthors[j].split(" ", -1);
                    for (int k = 0; k < ijparts.length; ++k) {
                        sb.append(ijparts[k]);
                        if (k < ijparts.length - 2) {
                            sb.append('~');
                            continue;
                        }
                        if (k != ijparts.length - 2) continue;
                        sb.append(' ');
                    }
                    if (j >= iAuthors.length - 1 && i >= authors.length - 1) continue;
                    sb.append(" and ");
                }
            }
        }
        return sb.toString();
    }

    class ReplaceAction
    extends BasicAction {
        public ReplaceAction() {
            super("Replace comma by and where appropriate");
        }

        public void actionPerformed(ActionEvent evt) {
            if (FieldTextMenu.this.myFieldName.getText().equals("")) {
                return;
            }
            String input = FieldTextMenu.this.myFieldName.getText();
            FieldTextMenu.this.myFieldName.setText(FieldTextMenu.generalFixAuthor(input));
        }
    }

    class CopyAction
    extends BasicAction {
        public CopyAction() {
            super("Copy to clipboard", "Copy to clipboard", GUIGlobals.getIconUrl("copy"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String data;
                if (FieldTextMenu.this.myFieldName != null && (data = FieldTextMenu.this.myFieldName.getSelectedText()) != null && data.length() > 0) {
                    ClipBoardManager.clipBoard.setClipboardContents(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste from clipboard", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String data = ClipBoardManager.clipBoard.getClipboardContents();
                if (data != null && data.length() > 0 && FieldTextMenu.this.myFieldName != null) {
                    FieldTextMenu.this.myFieldName.paste(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    abstract class BasicAction
    extends AbstractAction {
        public BasicAction(String text, String description, URL icon) {
            super(Globals.lang(text), new ImageIcon(icon));
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public BasicAction(String text, String description, URL icon, KeyStroke key) {
            super(Globals.lang(text), new ImageIcon(icon));
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public BasicAction(String text) {
            super(Globals.lang(text));
        }

        public BasicAction(String text, KeyStroke key) {
            super(Globals.lang(text));
            this.putValue("AcceleratorKey", key);
        }

        public abstract void actionPerformed(ActionEvent var1);
    }
}

