/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class XmpPrefsTab
extends JPanel
implements PrefsTab {
    boolean tableChanged = false;
    int rowCount;
    JTable table;
    JCheckBox privacyFilterCheckBox = new JCheckBox(Globals.lang("Do not write the following fields to XMP Metadata:"));
    Vector<Object> tableRows = new Vector(10);

    public XmpPrefsTab() {
        this.setLayout(new BorderLayout());
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return XmpPrefsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= XmpPrefsTab.this.tableRows.size()) {
                    return "";
                }
                Object rowContent = XmpPrefsTab.this.tableRows.elementAt(row);
                if (rowContent == null) {
                    return "";
                }
                return rowContent;
            }

            @Override
            public String getColumnName(int col) {
                return Globals.lang("Field to filter");
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                XmpPrefsTab.this.tableChanged = true;
                if (XmpPrefsTab.this.tableRows.size() <= row) {
                    XmpPrefsTab.this.tableRows.setSize(row + 1);
                }
                XmpPrefsTab.this.tableRows.setElementAt(value, row);
            }
        };
        this.table = new JTable(tm);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(140);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        scrollPane.setMinimumSize(new Dimension(250, 300));
        tablePanel.add((Component)scrollPane, "Center");
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        toolbar.setBorder(null);
        toolbar.add(new AddRowAction());
        toolbar.add(new DeleteRowAction());
        tablePanel.add((Component)toolbar, "East");
        builder.appendSeparator(Globals.lang("XMP Export Privacy Settings"));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.privacyFilterCheckBox);
        builder.nextLine();
        builder.append(pan);
        builder.append(tablePanel);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    public void setValues() {
        this.tableRows.clear();
        String[] names = JabRefPreferences.getInstance().getStringArray("xmpPrivacyFilters");
        for (int i = 0; i < names.length; ++i) {
            this.tableRows.add(names[i]);
        }
        this.rowCount = this.tableRows.size() + 5;
        this.privacyFilterCheckBox.setSelected(JabRefPreferences.getInstance().getBoolean("useXmpPrivacyFilter"));
    }

    public void storeSettings() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged || this.privacyFilterCheckBox.isSelected() && !Globals.prefs.hasKey("xmpPrivacyFilters")) {
            for (int i = this.tableRows.size() - 1; i >= 0; --i) {
                if (!this.tableRows.elementAt(i).equals("")) continue;
                this.tableRows.removeElementAt(i);
            }
            JabRefPreferences.getInstance().putStringArray("xmpPrivacyFilters", this.tableRows.toArray(new String[this.tableRows.size()]));
        }
        JabRefPreferences.getInstance().putBoolean("useXmpPrivacyFilter", this.privacyFilterCheckBox.isSelected());
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("XMP metadata");
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = XmpPrefsTab.this.table.getSelectedRows();
            if (rows.length == 0) {
                ++XmpPrefsTab.this.rowCount;
                XmpPrefsTab.this.table.revalidate();
                XmpPrefsTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.add(rows[i] + i, "");
            }
            XmpPrefsTab.this.rowCount += rows.length;
            if (rows.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = XmpPrefsTab.this.table.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.remove(rows[i]);
            }
            XmpPrefsTab.this.rowCount -= rows.length;
            if (rows.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }
}

