/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.SearchGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroup {
    protected String m_name;
    protected int m_context = 0;
    public static final int INDEPENDENT = 0;
    public static final int REFINING = 1;
    public static final int INCLUDING = 2;
    protected static final char QUOTE_CHAR = '\\';
    protected static final String SEPARATOR = ";";

    public abstract String getTypeId();

    public AbstractGroup(String name, int context) {
        this.m_name = name;
        this.setHierarchicalContext(context);
    }

    public abstract SearchRule getSearchRule();

    public static AbstractGroup fromString(String s, BibtexDatabase db, int version) throws Exception {
        if (s.startsWith("KeywordGroup:")) {
            return KeywordGroup.fromString(s, db, version);
        }
        if (s.startsWith("AllEntriesGroup:")) {
            return AllEntriesGroup.fromString(s, db, version);
        }
        if (s.startsWith("SearchGroup:")) {
            return SearchGroup.fromString(s, db, version);
        }
        if (s.startsWith("ExplicitGroup:")) {
            return ExplicitGroup.fromString(s, db, version);
        }
        return null;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public abstract boolean supportsAdd();

    public abstract boolean supportsRemove();

    public abstract AbstractUndoableEdit add(BibtexEntry[] var1);

    public abstract AbstractUndoableEdit remove(BibtexEntry[] var1);

    public abstract boolean contains(Map<String, String> var1, BibtexEntry var2);

    public abstract boolean contains(BibtexEntry var1);

    public boolean containsAny(BibtexEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            if (!this.contains(entries[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BibtexEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            if (this.contains(entries[i])) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDynamic();

    public void setHierarchicalContext(int context) {
        if (context != 0 && context != 1 && context != 2) {
            return;
        }
        this.m_context = context;
    }

    public int getHierarchicalContext() {
        return this.m_context;
    }

    public abstract String getDescription();

    public abstract AbstractGroup deepCopy();

    public abstract String getShortDescription();

    public void refreshForNewDatabase(BibtexDatabase db) {
    }
}

