/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Vector;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

public class UndoableModifySubtree
extends AbstractUndoableEdit {
    private final GroupTreeNode m_subtreeBackup;
    private final int[] m_subtreeRootPath;
    private final GroupSelector m_groupSelector;
    private Vector<TreeNode> m_modifiedSubtree = new Vector();
    private boolean m_revalidate = true;
    private final String m_name;

    public UndoableModifySubtree(GroupSelector groupSelector, GroupTreeNode subtree, String name) {
        this.m_subtreeBackup = subtree.deepCopy();
        this.m_subtreeRootPath = subtree.getIndexedPath();
        this.m_groupSelector = groupSelector;
        this.m_name = name;
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + this.m_name;
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + this.m_name;
    }

    public void undo() {
        int i;
        super.undo();
        this.m_modifiedSubtree.clear();
        GroupTreeNode subtreeRoot = this.m_groupSelector.getGroupTreeRoot().getNode(this.m_subtreeRootPath);
        for (i = 0; i < subtreeRoot.getChildCount(); ++i) {
            this.m_modifiedSubtree.add(subtreeRoot.getChildAt(i));
        }
        subtreeRoot.removeAllChildren();
        for (i = 0; i < this.m_subtreeBackup.getChildCount(); ++i) {
            subtreeRoot.add(((GroupTreeNode)this.m_subtreeBackup.getChildAt(i)).deepCopy());
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void redo() {
        super.redo();
        GroupTreeNode subtreeRoot = this.m_groupSelector.getGroupTreeRoot().getNode(this.m_subtreeRootPath);
        subtreeRoot.removeAllChildren();
        for (int i = 0; i < this.m_modifiedSubtree.size(); ++i) {
            subtreeRoot.add((GroupTreeNode)this.m_modifiedSubtree.elementAt(i));
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void setRevalidate(boolean revalidate) {
        this.m_revalidate = revalidate;
    }
}

