/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MergeDialog;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableInsertString;

public class AppendDatabaseAction
extends BaseAction {
    private JabRefFrame frame;
    private BasePanel panel;
    private List<File> filesToOpen = new ArrayList<File>();

    public AppendDatabaseAction(JabRefFrame frame, BasePanel panel) {
        this.frame = frame;
        this.panel = panel;
    }

    public void action() {
        this.filesToOpen.clear();
        final MergeDialog md = new MergeDialog(this.frame, Globals.lang("Append database"), true);
        Util.placeDialog(md, this.panel);
        md.setVisible(true);
        if (md.isOkPressed()) {
            String[] chosen = FileDialogs.getMultipleFiles(this.frame, new File(Globals.prefs.get("workingDirectory")), null, false);
            if (chosen == null) {
                return;
            }
            for (int i = 0; i < chosen.length; ++i) {
                this.filesToOpen.add(new File(chosen[i]));
            }
            new Thread(){

                public void run() {
                    AppendDatabaseAction.this.openIt(md.importEntries(), md.importStrings(), md.importGroups(), md.importSelectorWords());
                }
            }.start();
        }
    }

    void openIt(boolean importEntries, boolean importStrings, boolean importGroups, boolean importSelectorWords) {
        if (this.filesToOpen.size() == 0) {
            return;
        }
        for (File file : this.filesToOpen) {
            try {
                Globals.prefs.put("workingDirectory", file.getPath());
                String encoding = Globals.prefs.get("defaultEncoding");
                ParserResult pr = OpenDatabaseAction.loadDatabase(file, encoding);
                AppendDatabaseAction.mergeFromBibtex(this.frame, this.panel, pr, importEntries, importStrings, importGroups, importSelectorWords);
                this.panel.output(Globals.lang("Imported from database") + " '" + file.getPath() + "'");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.panel, ex.getMessage(), "Open database", 0);
            }
        }
    }

    public static void mergeFromBibtex(JabRefFrame frame, BasePanel panel, ParserResult pr, boolean importEntries, boolean importStrings, boolean importGroups, boolean importSelectorWords) throws KeyCollisionException {
        GroupTreeNode newGroups;
        BibtexDatabase fromDatabase = pr.getDatabase();
        ArrayList<BibtexEntry> appendedEntries = new ArrayList<BibtexEntry>();
        ArrayList<BibtexEntry> originalEntries = new ArrayList<BibtexEntry>();
        BibtexDatabase database = panel.database();
        NamedCompound ce = new NamedCompound(Globals.lang("Append database"));
        MetaData meta = new MetaData(pr.getMetaData(), pr.getDatabase());
        if (importEntries) {
            boolean overwriteOwner = Globals.prefs.getBoolean("overwriteOwner");
            boolean overwriteTimeStamp = Globals.prefs.getBoolean("overwriteTimeStamp");
            for (String key : fromDatabase.getKeySet()) {
                BibtexEntry originalEntry = fromDatabase.getEntryById(key);
                BibtexEntry be = (BibtexEntry)originalEntry.clone();
                be.setId(Util.createNeutralId());
                Util.setAutomaticFields(be, overwriteOwner, overwriteTimeStamp);
                database.insertEntry(be);
                appendedEntries.add(be);
                originalEntries.add(originalEntry);
                ce.addEdit(new UndoableInsertEntry(database, be, panel));
            }
        }
        if (importStrings) {
            for (BibtexString bs : fromDatabase.getStringValues()) {
                if (database.hasStringLabel(bs.getName())) continue;
                database.addString(bs);
                ce.addEdit(new UndoableInsertString(panel, database, bs));
            }
        }
        if (importGroups && (newGroups = meta.getGroups()) != null) {
            if (newGroups.getGroup() instanceof AllEntriesGroup) {
                ExplicitGroup group = new ExplicitGroup("Imported", 0);
                newGroups.setGroup(group);
                for (int i = 0; i < appendedEntries.size(); ++i) {
                    group.addEntry((BibtexEntry)appendedEntries.get(i));
                }
            }
            frame.groupSelector.addGroups(newGroups, ce);
            Enumeration<GroupTreeNode> e = newGroups.preorderEnumeration();
            while (e.hasMoreElements()) {
                GroupTreeNode node = e.nextElement();
                if (!(node.getGroup() instanceof ExplicitGroup)) continue;
                ExplicitGroup group = (ExplicitGroup)node.getGroup();
                for (int i = 0; i < originalEntries.size(); ++i) {
                    BibtexEntry entry = (BibtexEntry)originalEntries.get(i);
                    if (!group.contains(entry)) continue;
                    group.removeEntry(entry);
                    group.addEntry((BibtexEntry)appendedEntries.get(i));
                }
            }
            frame.groupSelector.revalidateGroups();
        }
        if (importSelectorWords) {
            for (String s : meta) {
                if (!s.startsWith("selector_")) continue;
                panel.metaData().putData(s, meta.getData(s));
            }
        }
        ce.end();
        panel.undoManager.addEdit(ce);
        panel.markBaseChanged();
    }
}

