/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search;

import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.search.RegExNode;
import net.sf.jabref.search.SearchExpressionTreeParserTokenTypes;

public class SearchExpressionTreeParser
extends TreeParser
implements SearchExpressionTreeParserTokenTypes {
    static RemoveLatexCommands removeLatexCommands = new RemoveLatexCommands();
    private static final int MATCH_EXACT = 0;
    private static final int MATCH_CONTAINS = 1;
    private static final int MATCH_DOES_NOT_CONTAIN = 2;
    private BibtexEntry bibtexEntry;
    private Object[] searchKeys;
    private static final int PSEUDOFIELD_TYPE = 1;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"and\"", "\"or\"", "\"not\"", "\"contains\"", "\"matches\"", "white space", "'('", "')'", "'='", "'=='", "'!='", "'\\\"'", "a text literal", "a letter", "a field type", "RegularExpression", "And", "Or", "Not", "ExpressionSearch"};

    public int apply(AST ast, BibtexEntry bibtexEntry) throws RecognitionException {
        this.bibtexEntry = bibtexEntry;
        this.searchKeys = bibtexEntry.getAllFields().toArray();
        return this.tSearchExpression(ast) ? 1 : 0;
    }

    public SearchExpressionTreeParser() {
        this.tokenNames = _tokenNames;
    }

    public final boolean tSearchExpression(AST _t) throws RecognitionException, PatternSyntaxException {
        boolean ret;
        block21: {
            ret = false;
            AST tSearchExpression_AST_in = _t == ASTNULL ? null : _t;
            boolean a = false;
            boolean b = false;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 20: {
                        AST __t87 = _t;
                        AST tmp1_AST_in = _t;
                        this.match(_t, 20);
                        _t = _t.getFirstChild();
                        a = this.tSearchExpression(_t);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() >= 20 && _t.getType() <= 23 && a) {
                            b = this.tSearchExpression(_t);
                            _t = this._retTree;
                        } else if (_t.getType() >= 4 && _t.getType() <= 23) {
                            AST tmp2_AST_in = _t;
                            if (_t == null) {
                                throw new MismatchedTokenException();
                            }
                            _t = _t.getNextSibling();
                        } else {
                            throw new NoViableAltException(_t);
                        }
                        _t = __t87;
                        _t = _t.getNextSibling();
                        ret = a && b;
                        break;
                    }
                    case 21: {
                        AST __t89 = _t;
                        AST tmp3_AST_in = _t;
                        this.match(_t, 21);
                        _t = _t.getFirstChild();
                        a = this.tSearchExpression(_t);
                        _t = this._retTree;
                        if (_t == null) {
                            _t = ASTNULL;
                        }
                        if (_t.getType() >= 20 && _t.getType() <= 23 && !a) {
                            b = this.tSearchExpression(_t);
                            _t = this._retTree;
                        } else if (_t.getType() >= 4 && _t.getType() <= 23) {
                            AST tmp4_AST_in = _t;
                            if (_t == null) {
                                throw new MismatchedTokenException();
                            }
                            _t = _t.getNextSibling();
                        } else {
                            throw new NoViableAltException(_t);
                        }
                        _t = __t89;
                        _t = _t.getNextSibling();
                        ret = a || b;
                        break;
                    }
                    case 22: {
                        AST __t91 = _t;
                        AST tmp5_AST_in = _t;
                        this.match(_t, 22);
                        _t = _t.getFirstChild();
                        a = this.tSearchExpression(_t);
                        _t = this._retTree;
                        _t = __t91;
                        _t = _t.getNextSibling();
                        ret = !a;
                        break;
                    }
                    case 23: {
                        ret = this.tExpressionSearch(_t);
                        _t = this._retTree;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block21;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return ret;
    }

    public final boolean tExpressionSearch(AST _t) throws RecognitionException, PatternSyntaxException {
        boolean ret;
        block12: {
            ret = false;
            AST var_f = null;
            AST var_v = null;
            int matchType = 0;
            try {
                AST __t94 = _t;
                AST tmp6_AST_in = _t;
                this.match(_t, 23);
                var_f = _t = _t.getFirstChild();
                this.match(_t, 19);
                _t = _t.getNextSibling();
                matchType = this.tSearchType(_t);
                var_v = _t = this._retTree;
                this.match(_t, 19);
                _t = _t.getNextSibling();
                Pattern fieldSpec = ((RegExNode)var_f).getPattern();
                Pattern valueSpec = ((RegExNode)var_v).getPattern();
                boolean noSuchField = true;
                block10: for (int i = 0; i < this.searchKeys.length + 1 && !ret; ++i) {
                    String content;
                    switch (i - this.searchKeys.length + 1) {
                        case 1: {
                            if (!fieldSpec.matcher("entrytype").matches()) continue block10;
                            content = this.bibtexEntry.getType().getName();
                            break;
                        }
                        default: {
                            if (!fieldSpec.matcher(this.searchKeys[i].toString()).matches()) continue block10;
                            content = removeLatexCommands.format(this.bibtexEntry.getField(this.searchKeys[i].toString()));
                        }
                    }
                    noSuchField = false;
                    if (content == null) continue;
                    Matcher matcher = valueSpec.matcher(content);
                    switch (matchType) {
                        case 1: {
                            ret = matcher.find();
                            continue block10;
                        }
                        case 0: {
                            ret = matcher.matches();
                            continue block10;
                        }
                        case 2: {
                            ret = !matcher.find();
                        }
                    }
                }
                if (noSuchField && matchType == 2) {
                    ret = true;
                }
                _t = __t94;
                _t = _t.getNextSibling();
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block12;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return ret;
    }

    public final int tSearchType(AST _t) throws RecognitionException {
        int matchType;
        block10: {
            matchType = 0;
            AST tSearchType_AST_in = _t == ASTNULL ? null : _t;
            try {
                if (_t == null) {
                    _t = ASTNULL;
                }
                switch (_t.getType()) {
                    case 7: {
                        AST tmp7_AST_in = _t;
                        this.match(_t, 7);
                        _t = _t.getNextSibling();
                        matchType = 1;
                        break;
                    }
                    case 8: {
                        AST tmp8_AST_in = _t;
                        this.match(_t, 8);
                        _t = _t.getNextSibling();
                        matchType = 0;
                        break;
                    }
                    case 12: {
                        AST tmp9_AST_in = _t;
                        this.match(_t, 12);
                        _t = _t.getNextSibling();
                        matchType = 1;
                        break;
                    }
                    case 13: {
                        AST tmp10_AST_in = _t;
                        this.match(_t, 13);
                        _t = _t.getNextSibling();
                        matchType = 0;
                        break;
                    }
                    case 14: {
                        AST tmp11_AST_in = _t;
                        this.match(_t, 14);
                        _t = _t.getNextSibling();
                        matchType = 2;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                if (_t == null) break block10;
                _t = _t.getNextSibling();
            }
        }
        this._retTree = _t;
        return matchType;
    }
}

