/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import java.util.Vector;
import java.util.WeakHashMap;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.format.CreateDocBookAuthors;

public class AuthorList {
    private Vector<Author> authors;
    private String authorsNatbib = null;
    private String authorsFirstFirstAnds = null;
    private String authorsAlph = null;
    private String[] authorsFirstFirst = new String[4];
    private String[] authorsLastOnly = new String[2];
    private String[] authorLastFirstAnds = new String[2];
    private String[] authorsLastFirst = new String[4];
    private String[] authorsLastFirstFirstLast = new String[2];
    private String orig;
    private int token_start;
    private int token_end;
    private int token_abbr;
    private char token_term;
    private boolean token_case;
    private Vector<Object> tokens;
    private static final int TOKEN_GROUP_LENGTH = 4;
    private static final int OFFSET_TOKEN = 0;
    private static final int OFFSET_TOKEN_ABBR = 1;
    private static final int OFFSET_TOKEN_TERM = 2;
    int von_start;
    int last_start;
    int comma_first;
    int comma_second;
    private static final int TOKEN_EOF = 0;
    private static final int TOKEN_AND = 1;
    private static final int TOKEN_COMMA = 2;
    private static final int TOKEN_WORD = 3;
    private static final HashSet<String> tex_names = new HashSet();
    static WeakHashMap<String, AuthorList> authorCache;

    protected AuthorList(String bibtex_authors) {
        this.authors = new Vector(5);
        this.orig = bibtex_authors;
        this.token_start = 0;
        this.token_end = 0;
        while (this.token_start < this.orig.length()) {
            Author author = this.getAuthor();
            if (author == null) continue;
            this.authors.add(author);
        }
        this.orig = null;
        this.tokens = null;
    }

    public static AuthorList getAuthorList(String authors) {
        AuthorList authorList = authorCache.get(authors);
        if (authorList == null) {
            authorList = new AuthorList(authors);
            authorCache.put(authors, authorList);
        }
        return authorList;
    }

    public static String fixAuthor_firstNameFirstCommas(String authors, boolean abbr, boolean oxfordComma) {
        return AuthorList.getAuthorList(authors).getAuthorsFirstFirst(abbr, oxfordComma);
    }

    public static String fixAuthor_firstNameFirst(String authors) {
        return AuthorList.getAuthorList(authors).getAuthorsFirstFirstAnds();
    }

    public static String fixAuthor_lastNameFirstCommas(String authors, boolean abbr, boolean oxfordComma) {
        return AuthorList.getAuthorList(authors).getAuthorsLastFirst(abbr, oxfordComma);
    }

    public static String fixAuthor_lastNameFirst(String authors) {
        return AuthorList.getAuthorList(authors).getAuthorsLastFirstAnds(false);
    }

    public static String fixAuthor_lastNameFirst(String authors, boolean abbreviate) {
        return AuthorList.getAuthorList(authors).getAuthorsLastFirstAnds(abbreviate);
    }

    public static String fixAuthor_lastNameOnlyCommas(String authors, boolean oxfordComma) {
        return AuthorList.getAuthorList(authors).getAuthorsLastOnly(oxfordComma);
    }

    public static String fixAuthorForAlphabetization(String authors) {
        return AuthorList.getAuthorList(authors).getAuthorsForAlphabetization();
    }

    public static String fixAuthor_Natbib(String authors) {
        return AuthorList.getAuthorList(authors).getAuthorsNatbib();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Author getAuthor() {
        String string;
        boolean jrAsFirstname;
        int jr_part_end;
        int last_part_end;
        int von_part_end;
        int first_part_end;
        int jr_part_start;
        int last_part_start;
        int von_part_start;
        int first_part_start;
        block30: {
            block29: {
                this.tokens = new Vector();
                this.von_start = -1;
                this.last_start = -1;
                this.comma_first = -1;
                this.comma_second = -1;
                block5: while (true) {
                    int token = this.getToken();
                    switch (token) {
                        case 0: 
                        case 1: {
                            break block5;
                        }
                        case 2: {
                            if (this.comma_first < 0) {
                                this.comma_first = this.tokens.size();
                                break;
                            }
                            if (this.comma_second >= 0) break;
                            this.comma_second = this.tokens.size();
                            break;
                        }
                        case 3: {
                            this.tokens.add(this.orig.substring(this.token_start, this.token_end));
                            this.tokens.add(this.orig.substring(this.token_start, this.token_abbr));
                            this.tokens.add(new Character(this.token_term));
                            this.tokens.add(this.token_case);
                            if (this.comma_first >= 0 || this.last_start >= 0) break;
                            if (this.von_start < 0) {
                                if (this.token_case) break;
                                this.von_start = this.tokens.size() - 4;
                                break;
                            }
                            if (this.last_start >= 0 || !this.token_case) break;
                            this.last_start = this.tokens.size() - 4;
                        }
                    }
                }
                if (this.tokens.size() == 0) {
                    return null;
                }
                first_part_start = -1;
                von_part_start = -1;
                last_part_start = -1;
                jr_part_start = -1;
                first_part_end = 0;
                von_part_end = 0;
                last_part_end = 0;
                jr_part_end = 0;
                jrAsFirstname = false;
                if (this.comma_first >= 0) break block29;
                if (this.von_start < 0) {
                    Character ch;
                    last_part_end = this.tokens.size();
                    last_part_start = this.tokens.size() - 4;
                    int index = this.tokens.size() - 8 + 2;
                    if (index > 0 && (ch = (Character)this.tokens.elementAt(index)).charValue() == '-') {
                        last_part_start -= 4;
                    }
                    if ((first_part_end = last_part_start) > 0) {
                        first_part_start = 0;
                    }
                    break block30;
                } else {
                    if (this.last_start >= 0) {
                        last_part_end = this.tokens.size();
                        von_part_end = last_part_start = this.last_start;
                    } else {
                        von_part_end = this.tokens.size();
                    }
                    first_part_end = von_part_start = this.von_start;
                    if (first_part_end > 0) {
                        first_part_start = 0;
                    }
                }
                break block30;
            }
            first_part_end = this.tokens.size();
            if (this.comma_second < 0) {
                if (this.comma_first < first_part_end) {
                    first_part_start = this.comma_first;
                }
            } else {
                if (this.comma_second < first_part_end) {
                    first_part_start = this.comma_second;
                }
                if (this.comma_first < (jr_part_end = this.comma_second)) {
                    jr_part_start = this.comma_first;
                }
            }
            if (this.von_start != 0) {
                last_part_end = this.comma_first;
                if (last_part_end > 0) {
                    last_part_start = 0;
                }
            } else {
                if (this.last_start < 0) {
                    von_part_end = this.comma_first;
                } else {
                    last_part_end = this.comma_first;
                    von_part_end = last_part_start = this.last_start;
                }
                von_part_start = 0;
            }
        }
        if (first_part_start == -1 && last_part_start == -1 && von_part_start != -1) {
            last_part_start = von_part_start;
            last_part_end = von_part_end;
            von_part_start = -1;
            von_part_end = -1;
        }
        if (jrAsFirstname) {
            // empty if block
        }
        String string2 = first_part_start < 0 ? null : this.concatTokens(first_part_start, first_part_end, 0, false);
        String string3 = first_part_start < 0 ? null : this.concatTokens(first_part_start, first_part_end, 1, true);
        String string4 = von_part_start < 0 ? null : this.concatTokens(von_part_start, von_part_end, 0, false);
        String string5 = last_part_start < 0 ? null : this.concatTokens(last_part_start, last_part_end, 0, false);
        if (jr_part_start < 0) {
            string = null;
            return new Author(string2, string3, string4, string5, string);
        }
        string = this.concatTokens(jr_part_start, jr_part_end, 0, false);
        return new Author(string2, string3, string4, string5, string);
    }

    private String concatTokens(int start, int end, int offset, boolean dot_after) {
        StringBuffer res = new StringBuffer();
        res.append((String)this.tokens.get(start + offset));
        if (dot_after) {
            res.append('.');
        }
        start += 4;
        while (start < end) {
            res.append(this.tokens.get(start - 4 + 2));
            res.append((String)this.tokens.get(start + offset));
            if (dot_after) {
                res.append('.');
            }
            start += 4;
        }
        return res.toString();
    }

    private int getToken() {
        char c;
        this.token_start = this.token_end;
        while (this.token_start < this.orig.length() && ((c = this.orig.charAt(this.token_start)) == '~' || c == '-' || Character.isWhitespace(c))) {
            ++this.token_start;
        }
        this.token_end = this.token_start;
        if (this.token_start >= this.orig.length()) {
            return 0;
        }
        if (this.orig.charAt(this.token_start) == ',') {
            ++this.token_end;
            return 2;
        }
        this.token_abbr = -1;
        this.token_term = (char)32;
        this.token_case = true;
        int braces_level = 0;
        int current_backslash = -1;
        boolean first_letter_is_found = false;
        while (this.token_end < this.orig.length()) {
            char c2 = this.orig.charAt(this.token_end);
            if (c2 == '{') {
                ++braces_level;
            }
            if (braces_level > 0 && c2 == '}') {
                --braces_level;
            }
            if (first_letter_is_found && this.token_abbr < 0 && braces_level == 0) {
                this.token_abbr = this.token_end;
            }
            if (!first_letter_is_found && current_backslash < 0 && Character.isLetter(c2)) {
                this.token_case = Character.isUpperCase(c2);
                first_letter_is_found = true;
            }
            if (current_backslash >= 0 && !Character.isLetter(c2)) {
                String tex_cmd_name;
                if (!first_letter_is_found && tex_names.contains(tex_cmd_name = this.orig.substring(current_backslash + 1, this.token_end))) {
                    this.token_case = Character.isUpperCase(tex_cmd_name.charAt(0));
                    first_letter_is_found = true;
                }
                current_backslash = -1;
            }
            if (c2 == '\\') {
                current_backslash = this.token_end;
            }
            if (braces_level == 0 && (c2 == ',' || c2 == '~' || c2 == '-' || Character.isWhitespace(c2))) break;
            ++this.token_end;
        }
        if (this.token_abbr < 0) {
            this.token_abbr = this.token_end;
        }
        if (this.token_end < this.orig.length() && this.orig.charAt(this.token_end) == '-') {
            this.token_term = (char)45;
        }
        if (this.orig.substring(this.token_start, this.token_end).equalsIgnoreCase("and")) {
            return 1;
        }
        return 3;
    }

    public int size() {
        return this.authors.size();
    }

    public Author getAuthor(int i) {
        return this.authors.get(i);
    }

    public String getAuthorsNatbib() {
        if (this.authorsNatbib != null) {
            return this.authorsNatbib;
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            res.append(this.getAuthor(0).getLastOnly());
            if (this.size() == 2) {
                res.append(" and ");
                res.append(this.getAuthor(1).getLastOnly());
            } else if (this.size() > 2) {
                res.append(" et al.");
            }
        }
        this.authorsNatbib = res.toString();
        return this.authorsNatbib;
    }

    public String getAuthorsLastOnly(boolean oxfordComma) {
        int abbrInt;
        int n = abbrInt = oxfordComma ? 0 : 1;
        if (this.authorsLastOnly[abbrInt] != null) {
            return this.authorsLastOnly[abbrInt];
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            int i;
            res.append(this.getAuthor(0).getLastOnly());
            for (i = 1; i < this.size() - 1; ++i) {
                res.append(", ");
                res.append(this.getAuthor(i).getLastOnly());
            }
            if (this.size() > 2 && oxfordComma) {
                res.append(",");
            }
            if (this.size() > 1) {
                res.append(" and ");
                res.append(this.getAuthor(i).getLastOnly());
            }
        }
        this.authorsLastOnly[abbrInt] = res.toString();
        return this.authorsLastOnly[abbrInt];
    }

    public String getAuthorsLastFirst(boolean abbreviate, boolean oxfordComma) {
        int abbrInt = abbreviate ? 0 : 1;
        if (this.authorsLastFirst[abbrInt += oxfordComma ? 0 : 2] != null) {
            return this.authorsLastFirst[abbrInt];
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            int i;
            res.append(this.getAuthor(0).getLastFirst(abbreviate));
            for (i = 1; i < this.size() - 1; ++i) {
                res.append(", ");
                res.append(this.getAuthor(i).getLastFirst(abbreviate));
            }
            if (this.size() > 2 && oxfordComma) {
                res.append(",");
            }
            if (this.size() > 1) {
                res.append(" and ");
                res.append(this.getAuthor(i).getLastFirst(abbreviate));
            }
        }
        this.authorsLastFirst[abbrInt] = res.toString();
        return this.authorsLastFirst[abbrInt];
    }

    public String toString() {
        return this.getAuthorsLastFirstAnds(false);
    }

    public String getAuthorsLastFirstAnds(boolean abbreviate) {
        int abbrInt;
        int n = abbrInt = abbreviate ? 0 : 1;
        if (this.authorLastFirstAnds[abbrInt] != null) {
            return this.authorLastFirstAnds[abbrInt];
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            res.append(this.getAuthor(0).getLastFirst(abbreviate));
            for (int i = 1; i < this.size(); ++i) {
                res.append(" and ");
                res.append(this.getAuthor(i).getLastFirst(abbreviate));
            }
        }
        this.authorLastFirstAnds[abbrInt] = res.toString();
        return this.authorLastFirstAnds[abbrInt];
    }

    public String getAuthorsLastFirstFirstLastAnds(boolean abbreviate) {
        int abbrInt;
        int n = abbrInt = abbreviate ? 0 : 1;
        if (this.authorsLastFirstFirstLast[abbrInt] != null) {
            return this.authorsLastFirstFirstLast[abbrInt];
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            res.append(this.getAuthor(0).getLastFirst(abbreviate));
            for (int i = 1; i < this.size(); ++i) {
                res.append(" and ");
                res.append(this.getAuthor(i).getFirstLast(abbreviate));
            }
        }
        this.authorsLastFirstFirstLast[abbrInt] = res.toString();
        return this.authorsLastFirstFirstLast[abbrInt];
    }

    public String getAuthorsFirstFirst(boolean abbr, boolean oxfordComma) {
        int abbrInt = abbr ? 0 : 1;
        if (this.authorsFirstFirst[abbrInt += oxfordComma ? 0 : 2] != null) {
            return this.authorsFirstFirst[abbrInt];
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            int i;
            res.append(this.getAuthor(0).getFirstLast(abbr));
            for (i = 1; i < this.size() - 1; ++i) {
                res.append(", ");
                res.append(this.getAuthor(i).getFirstLast(abbr));
            }
            if (this.size() > 2 && oxfordComma) {
                res.append(",");
            }
            if (this.size() > 1) {
                res.append(" and ");
                res.append(this.getAuthor(i).getFirstLast(abbr));
            }
        }
        this.authorsFirstFirst[abbrInt] = res.toString();
        return this.authorsFirstFirst[abbrInt];
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuthorList)) {
            return false;
        }
        AuthorList a = (AuthorList)o;
        return this.authors.equals(a.authors);
    }

    public String getAuthorsFirstFirstAnds() {
        if (this.authorsFirstFirstAnds != null) {
            return this.authorsFirstFirstAnds;
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            res.append(this.getAuthor(0).getFirstLast(false));
            for (int i = 1; i < this.size(); ++i) {
                res.append(" and ");
                res.append(this.getAuthor(i).getFirstLast(false));
            }
        }
        this.authorsFirstFirstAnds = res.toString();
        return this.authorsFirstFirstAnds;
    }

    public String getAuthorsForAlphabetization() {
        if (this.authorsAlph != null) {
            return this.authorsAlph;
        }
        StringBuffer res = new StringBuffer();
        if (this.size() > 0) {
            res.append(this.getAuthor(0).getNameForAlphabetization());
            for (int i = 1; i < this.size(); ++i) {
                res.append(" and ");
                res.append(this.getAuthor(i).getNameForAlphabetization());
            }
        }
        this.authorsAlph = res.toString();
        return this.authorsAlph;
    }

    public static void main(String[] args) {
        String s = "Olaf von Nilsen, Jr.";
        AuthorList al = AuthorList.getAuthorList(s);
        for (int i = 0; i < al.size(); ++i) {
            Author a = al.getAuthor(i);
            System.out.println(i + 1 + ": first = '" + a.getFirst() + "'");
            System.out.println(i + 1 + ": last = '" + a.getLast() + "'");
            System.out.println(i + 1 + ": jr = '" + a.getJr() + "'");
            System.out.println(i + 1 + ": von = '" + a.getVon() + "'");
        }
        System.out.println(new CreateDocBookAuthors().format(s));
    }

    static {
        tex_names.add("aa");
        tex_names.add("ae");
        tex_names.add("l");
        tex_names.add("o");
        tex_names.add("oe");
        tex_names.add("i");
        tex_names.add("AA");
        tex_names.add("AE");
        tex_names.add("L");
        tex_names.add("O");
        tex_names.add("OE");
        tex_names.add("j");
        authorCache = new WeakHashMap();
    }

    public static class Author {
        private final String first_part;
        private final String first_abbr;
        private final String von_part;
        private final String last_part;
        private final String jr_part;

        public boolean equals(Object o) {
            if (!(o instanceof Author)) {
                return false;
            }
            Author a = (Author)o;
            return Util.equals(this.first_part, a.first_part) && Util.equals(this.first_abbr, a.first_abbr) && Util.equals(this.von_part, a.von_part) && Util.equals(this.last_part, a.last_part) && Util.equals(this.jr_part, a.jr_part);
        }

        public Author(String first, String firstabbr, String von, String last, String jr) {
            this.first_part = first;
            this.first_abbr = firstabbr;
            this.von_part = von;
            this.last_part = last;
            this.jr_part = jr;
        }

        public String getFirst() {
            return this.first_part;
        }

        public String getFirstAbbr() {
            return this.first_abbr;
        }

        public String getVon() {
            return this.von_part;
        }

        public String getLast() {
            return this.last_part;
        }

        public String getJr() {
            return this.jr_part;
        }

        public String getLastOnly() {
            if (this.von_part == null) {
                return this.last_part == null ? "" : this.last_part;
            }
            return this.last_part == null ? this.von_part : this.von_part + " " + this.last_part;
        }

        public String getLastFirst(boolean abbr) {
            String res = this.getLastOnly();
            if (this.jr_part != null) {
                res = res + ", " + this.jr_part;
            }
            if (abbr) {
                if (this.first_abbr != null) {
                    res = res + ", " + this.first_abbr;
                }
            } else if (this.first_part != null) {
                res = res + ", " + this.first_part;
            }
            return res;
        }

        public String getFirstLast(boolean abbr) {
            String res = this.getLastOnly();
            res = abbr ? (this.first_abbr == null ? "" : this.first_abbr + " ") + res : (this.first_part == null ? "" : this.first_part + " ") + res;
            if (this.jr_part != null) {
                res = res + ", " + this.jr_part;
            }
            return res;
        }

        public String getNameForAlphabetization() {
            StringBuffer res = new StringBuffer();
            if (this.last_part != null) {
                res.append(this.last_part);
            }
            if (this.jr_part != null) {
                res.append(", ");
                res.append(this.jr_part);
            }
            if (this.first_abbr != null) {
                res.append(", ");
                res.append(this.first_abbr);
            }
            while (res.length() > 0 && res.charAt(0) == '{') {
                res.deleteCharAt(0);
            }
            return res.toString();
        }
    }
}

