/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jabref.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryEditorTabList {
    private List<List<String>> list = null;
    private List<String> names = null;

    public EntryEditorTabList() {
        this.init();
    }

    private void init() {
        this.list = new ArrayList<List<String>>();
        this.names = new ArrayList<String>();
        int i = 0;
        if (Globals.prefs.hasKey("customTabName_" + 0)) {
            while (true) {
                if (Globals.prefs.hasKey("customTabName_" + i)) {
                    String name = Globals.prefs.get("customTabName_" + i);
                    String[] fields = Globals.prefs.get("customTabFields_" + i).split(";");
                    List<String> entry = Arrays.asList(fields);
                    this.names.add(name);
                    this.list.add(entry);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                if (Globals.prefs.get("customTabName_" + "_def" + i) == null) break;
                String name = Globals.prefs.get("customTabName_" + "_def" + i);
                String[] fields = Globals.prefs.get("customTabFields_" + "_def" + i).split(";");
                List<String> entry = Arrays.asList(fields);
                this.names.add(name);
                this.list.add(entry);
                ++i;
            }
        }
    }

    public int getTabCount() {
        return this.list.size();
    }

    public String getTabName(int tab) {
        return this.names.get(tab);
    }

    public List<String> getTabFields(int tab) {
        return this.list.get(tab);
    }
}

