/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntrySorter
implements DatabaseChangeListener {
    final ArrayList<BibtexEntry> set = new ArrayList();
    Comparator<BibtexEntry> comp;
    String[] idArray;
    BibtexEntry[] entryArray;
    private boolean outdated = false;
    private boolean changed = false;

    public EntrySorter(Map<String, BibtexEntry> entries, Comparator<BibtexEntry> comp) {
        this.comp = comp;
        Set<String> keySet = entries.keySet();
        if (keySet != null) {
            Iterator<String> i = keySet.iterator();
            while (i.hasNext()) {
                this.set.add(entries.get(i.next()));
            }
            this.changed = true;
            this.index();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            if (this.changed) {
                Collections.sort(this.set, this.comp);
                this.changed = false;
            }
            int count = this.set.size();
            this.idArray = new String[count];
            this.entryArray = new BibtexEntry[count];
            int piv = 0;
            for (BibtexEntry entry : this.set) {
                this.idArray[piv] = entry.getId();
                this.entryArray[piv] = entry;
                ++piv;
            }
        }
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdAt(int pos) {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            return this.idArray[pos];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BibtexEntry getEntryAt(int pos) {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            return this.entryArray[pos];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            if (this.entryArray != null) {
                return this.entryArray.length;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            if (e.getType() == DatabaseChangeEvent.ADDED_ENTRY) {
                int pos = -Collections.binarySearch(this.set, e.getEntry(), this.comp) - 1;
                this.set.add(pos, e.getEntry());
            } else if (e.getType() == DatabaseChangeEvent.REMOVED_ENTRY) {
                this.set.remove(e.getEntry());
                this.changed = true;
            } else if (e.getType() == DatabaseChangeEvent.CHANGED_ENTRY) {
                int pos = Collections.binarySearch(this.set, e.getEntry(), this.comp);
                int posOld = this.set.indexOf(e.getEntry());
                if (pos < 0) {
                    this.set.remove(posOld);
                    this.set.add(-pos - 1, e.getEntry());
                }
            }
        }
    }
}

