/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class GeneralRenderer
extends DefaultTableCellRenderer {
    Color background;
    Color selBackground = null;

    public GeneralRenderer(Color c) {
        this.background = c;
        this.setBackground(c);
    }

    public GeneralRenderer(Color c, Color fg) {
        this(c);
        this.background = c;
        this.setForeground(fg);
    }

    public GeneralRenderer(Color c, Color fg, Color sel) {
        this(c);
        this.background = c;
        this.setForeground(fg);
        this.selBackground = sel;
    }

    public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.selBackground == null) {
            return super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
        }
        Component c = super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
        if (isSelected) {
            c.setBackground(this.selBackground);
        } else {
            c.setBackground(this.background);
        }
        return c;
    }

    public void firePropertyChange(String propertyName, boolean old, boolean newV) {
    }

    public void firePropertyChange(String propertyName, Object old, Object newV) {
    }

    protected void setValue(Object value) {
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText(null);
        } else if (value instanceof JLabel) {
            JLabel lab = (JLabel)value;
            this.setIcon(lab.getIcon());
            this.setToolTipText(lab.getToolTipText());
            if (lab.getIcon() != null) {
                this.setText(null);
            }
        } else {
            this.setIcon(null);
            this.setToolTipText(null);
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText(null);
            }
        }
    }
}

