/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchTextListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextAreaWithHighlighting
extends JTextArea
implements SearchTextListener {
    private ArrayList<String> wordsToHighlight;

    public JTextAreaWithHighlighting() {
    }

    public JTextAreaWithHighlighting(String text) {
        super(text);
    }

    public JTextAreaWithHighlighting(Document doc) {
        super(doc);
    }

    public JTextAreaWithHighlighting(int rows, int columns) {
        super(rows, columns);
    }

    public JTextAreaWithHighlighting(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    public JTextAreaWithHighlighting(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
    }

    private void highLight(ArrayList<String> words) {
        Highlighter h = this.getHighlighter();
        h.removeAllHighlights();
        if (words == null || words.isEmpty() || words.get(0).isEmpty()) {
            return;
        }
        String content = this.getText();
        if (content.isEmpty()) {
            return;
        }
        Matcher matcher = Globals.getPatternForWords(words).matcher(content);
        while (matcher.find()) {
            try {
                h.addHighlight(matcher.start(), matcher.end(), DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException ble) {
                System.out.println(ble);
            }
        }
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.highLight(this.wordsToHighlight);
        }
    }

    @Override
    public void searchText(ArrayList<String> words) {
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.wordsToHighlight = words;
            this.highLight(words);
        } else if (this.wordsToHighlight != null) {
            this.wordsToHighlight = null;
            this.highLight(null);
        }
    }
}

