/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class TableColumnsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private boolean tableChanged = false;
    private JTable colSetup;
    private int rowCount = -1;
    private int ncWidth = -1;
    private Vector<TableRow> tableRows = new Vector(10);
    private JabRefFrame frame;

    public TableColumnsTab(JabRefPreferences prefs, JabRefFrame frame) {
        this._prefs = prefs;
        this.frame = frame;
        this.setLayout(new BorderLayout());
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TableColumnsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row == 0) {
                    return column == 0 ? GUIGlobals.NUMBER_COL : "" + TableColumnsTab.this.ncWidth;
                }
                if (--row >= TableColumnsTab.this.tableRows.size()) {
                    return "";
                }
                Object rowContent = TableColumnsTab.this.tableRows.elementAt(row);
                if (rowContent == null) {
                    return "";
                }
                TableRow tr = (TableRow)rowContent;
                switch (column) {
                    case 0: {
                        return tr.name;
                    }
                    case 1: {
                        return tr.length > 0 ? Integer.toString(tr.length) : "";
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int col) {
                return col == 0 ? Globals.lang("Field name") : Globals.lang("Column width");
            }

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return String.class;
                }
                return Integer.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return row != 0 || col != 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                TableColumnsTab.this.tableChanged = true;
                while (row >= TableColumnsTab.this.tableRows.size()) {
                    TableColumnsTab.this.tableRows.add(new TableRow("", -1));
                }
                if (row == 0 && col == 1) {
                    TableColumnsTab.this.ncWidth = Integer.parseInt(value.toString());
                    return;
                }
                TableRow rowContent = (TableRow)TableColumnsTab.this.tableRows.elementAt(row - 1);
                if (col == 0) {
                    rowContent.name = value.toString();
                    if (((String)this.getValueAt(row, 1)).equals("")) {
                        this.setValueAt("" + GUIGlobals.DEFAULT_FIELD_LENGTH, row, 1);
                    }
                } else {
                    rowContent.length = value == null ? -1 : Integer.parseInt(value.toString());
                }
            }
        };
        this.colSetup = new JTable(tm);
        TableColumnModel cm = this.colSetup.getColumnModel();
        cm.getColumn(0).setPreferredWidth(140);
        cm.getColumn(1).setPreferredWidth(80);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        JPanel tabPanel = new JPanel();
        tabPanel.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.colSetup, 20, 31);
        this.colSetup.setPreferredScrollableViewportSize(new Dimension(250, 200));
        sp.setMinimumSize(new Dimension(250, 300));
        tabPanel.add((Component)sp, "Center");
        JToolBar tlb = new JToolBar(1);
        tlb.setFloatable(false);
        AddRowAction ara = new AddRowAction();
        DeleteRowAction dra = new DeleteRowAction();
        MoveRowUpAction moveUp = new MoveRowUpAction();
        MoveRowDownAction moveDown = new MoveRowDownAction();
        tlb.setBorder(null);
        tlb.add(ara);
        tlb.add(dra);
        tlb.addSeparator();
        tlb.add(moveUp);
        tlb.add(moveDown);
        tabPanel.add((Component)tlb, "East");
        builder.appendSeparator(Globals.lang("Entry table columns"));
        builder.nextLine();
        builder.append(pan);
        builder.append(tabPanel);
        builder.nextLine();
        builder.append(pan);
        JButton buttonWidth = new JButton(new UpdateWidthsAction());
        JButton buttonOrder = new JButton(new UpdateOrderAction());
        builder.append(buttonWidth);
        builder.nextLine();
        builder.append(pan);
        builder.append(buttonOrder);
        builder.nextLine();
        builder.append(pan);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    public void setValues() {
        this.tableRows.clear();
        String[] names = this._prefs.getStringArray("columnNames");
        String[] lengths = this._prefs.getStringArray("columnWidths");
        for (int i = 0; i < names.length; ++i) {
            if (i < lengths.length) {
                this.tableRows.add(new TableRow(names[i], Integer.parseInt(lengths[i])));
                continue;
            }
            this.tableRows.add(new TableRow(names[i]));
        }
        this.rowCount = this.tableRows.size() + 5;
        this.ncWidth = this._prefs.getInt("numberColWidth");
    }

    public void storeSettings() {
        if (this.colSetup.isEditing()) {
            int col = this.colSetup.getEditingColumn();
            int row = this.colSetup.getEditingRow();
            this.colSetup.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged) {
            int i = 0;
            while (i < this.tableRows.size()) {
                if (this.tableRows.elementAt((int)i).name.equals("")) {
                    this.tableRows.removeElementAt(i);
                    continue;
                }
                ++i;
            }
            String[] names = new String[this.tableRows.size()];
            String[] widths = new String[this.tableRows.size()];
            int[] nWidths = new int[this.tableRows.size()];
            this._prefs.putInt("numberColWidth", this.ncWidth);
            for (i = 0; i < this.tableRows.size(); ++i) {
                TableRow tr = this.tableRows.elementAt(i);
                names[i] = tr.name.toLowerCase();
                nWidths[i] = tr.length;
                widths[i] = "" + tr.length;
            }
            this._prefs.putStringArray("columnNames", names);
            this._prefs.putStringArray("columnWidths", widths);
        }
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("Entry table columns");
    }

    class UpdateWidthsAction
    extends AbstractAction {
        public UpdateWidthsAction() {
            super(Globals.lang("Update to current column widths"));
        }

        public void actionPerformed(ActionEvent e) {
            BasePanel panel = TableColumnsTab.this.frame.basePanel();
            if (panel == null) {
                return;
            }
            TableColumnModel colMod = panel.mainTable.getColumnModel();
            TableColumnsTab.this.colSetup.setValueAt("" + colMod.getColumn(0).getWidth(), 0, 1);
            for (int i = 1; i < colMod.getColumnCount(); ++i) {
                block6: {
                    try {
                        String name = panel.mainTable.getColumnName(i).toLowerCase();
                        int width = colMod.getColumn(i).getWidth();
                        if (i <= TableColumnsTab.this.tableRows.size() && ((String)TableColumnsTab.this.colSetup.getValueAt(i, 0)).toLowerCase().equals(name)) {
                            TableColumnsTab.this.colSetup.setValueAt("" + width, i, 1);
                            break block6;
                        }
                        for (int j = 0; j < TableColumnsTab.this.colSetup.getRowCount(); ++j) {
                            if (j >= TableColumnsTab.this.tableRows.size() || !((String)TableColumnsTab.this.colSetup.getValueAt(j, 0)).toLowerCase().equals(name)) continue;
                            TableColumnsTab.this.colSetup.setValueAt("" + width, j, 1);
                            break;
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
            }
        }
    }

    class UpdateOrderAction
    extends AbstractAction {
        public UpdateOrderAction() {
            super(Globals.lang("Update to current column order"));
        }

        public void actionPerformed(ActionEvent e) {
            BasePanel panel = TableColumnsTab.this.frame.basePanel();
            if (panel == null) {
                return;
            }
            final HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 1; i < panel.mainTable.getColumnCount(); ++i) {
                String name = panel.mainTable.getColumnName(i);
                if (name == null || name.length() == 0) continue;
                map.put(name.toLowerCase(), i);
            }
            Collections.sort(TableColumnsTab.this.tableRows, new Comparator<TableRow>(){

                @Override
                public int compare(TableRow o1, TableRow o2) {
                    Integer n1 = (Integer)map.get(o1.name);
                    Integer n2 = (Integer)map.get(o2.name);
                    if (n1 == null || n2 == null) {
                        return 0;
                    }
                    return n1.compareTo(n2);
                }
            });
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class MoveRowDownAction
    extends AbstractMoveRowAction {
        public MoveRowDownAction() {
            super("Down", GUIGlobals.getImage("down"));
            this.putValue("ShortDescription", Globals.lang("Down"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] selected = TableColumnsTab.this.colSetup.getSelectedRows();
            Arrays.sort(selected);
            int last = selected.length - 1;
            boolean[] newSelected = new boolean[TableColumnsTab.this.colSetup.getRowCount()];
            if (selected.length > 0 && selected[last] < TableColumnsTab.this.tableRows.size()) {
                int i;
                for (i = last; i >= 0; --i) {
                    this.swap(selected[i] - 1, selected[i]);
                    newSelected[selected[i] + 1] = true;
                }
                TableColumnsTab.this.colSetup.setRowSelectionInterval(0, TableColumnsTab.this.colSetup.getRowCount() - 1);
                for (i = 0; i < TableColumnsTab.this.colSetup.getRowCount(); ++i) {
                    if (newSelected[i]) continue;
                    TableColumnsTab.this.colSetup.removeRowSelectionInterval(i, i);
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                TableColumnsTab.this.tableChanged = true;
            }
        }
    }

    class MoveRowUpAction
    extends AbstractMoveRowAction {
        public MoveRowUpAction() {
            super("Up", GUIGlobals.getImage("up"));
            this.putValue("ShortDescription", Globals.lang("Move up"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] selected = TableColumnsTab.this.colSetup.getSelectedRows();
            Arrays.sort(selected);
            if (selected.length > 0 && selected[0] > 1) {
                boolean[] newSelected = new boolean[TableColumnsTab.this.colSetup.getRowCount()];
                for (int i : selected) {
                    this.swap(i - 1, i - 2);
                    newSelected[i - 1] = true;
                }
                TableColumnsTab.this.colSetup.setRowSelectionInterval(0, TableColumnsTab.this.colSetup.getRowCount() - 1);
                for (int i = 0; i < TableColumnsTab.this.colSetup.getRowCount(); ++i) {
                    if (newSelected[i]) continue;
                    TableColumnsTab.this.colSetup.removeRowSelectionInterval(i, i);
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                TableColumnsTab.this.tableChanged = true;
            }
        }
    }

    abstract class AbstractMoveRowAction
    extends AbstractAction {
        public AbstractMoveRowAction(String string, ImageIcon image) {
            super(string, image);
        }

        protected void swap(int i, int j) {
            if (i < 0 || i >= TableColumnsTab.this.tableRows.size()) {
                return;
            }
            if (j < 0 || j >= TableColumnsTab.this.tableRows.size()) {
                return;
            }
            TableRow tmp = (TableRow)TableColumnsTab.this.tableRows.get(i);
            TableColumnsTab.this.tableRows.set(i, TableColumnsTab.this.tableRows.get(j));
            TableColumnsTab.this.tableRows.set(j, tmp);
        }
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = TableColumnsTab.this.colSetup.getSelectedRows();
            if (rows.length == 0) {
                TableColumnsTab.this.rowCount++;
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i - 1 >= TableColumnsTab.this.tableRows.size()) continue;
                TableColumnsTab.this.tableRows.add(Math.max(0, rows[i] + i - 1), new TableRow(GUIGlobals.DEFAULT_FIELD_LENGTH));
            }
            TableColumnsTab.this.rowCount += rows.length;
            if (rows.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = TableColumnsTab.this.colSetup.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            int offs = 0;
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[i] > TableColumnsTab.this.tableRows.size() || rows[i] == 0) continue;
                TableColumnsTab.this.tableRows.remove(rows[i] - 1);
                ++offs;
            }
            TableColumnsTab.this.rowCount -= offs;
            if (rows.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class TableRow {
        String name;
        int length;

        public TableRow(String name) {
            this.name = name;
            this.length = GUIGlobals.DEFAULT_FIELD_LENGTH;
        }

        public TableRow(int length) {
            this.length = length;
            this.name = "";
        }

        public TableRow(String name, int length) {
            this.name = name;
            this.length = length;
        }
    }
}

