/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.util.Stack;
import net.sf.jabref.bst.BibtexTextPrefix;
import net.sf.jabref.bst.VM;
import net.sf.jabref.bst.VMException;

public class TextPrefixFunction
implements VM.BstFunction {
    VM vm;

    public TextPrefixFunction(VM vm) {
        this.vm = vm;
    }

    public void execute(VM.BstEntry context) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation text.prefix$");
        }
        Object o1 = stack.pop();
        Object o2 = stack.pop();
        if (!(o1 instanceof Integer)) {
            this.vm.warn("An integer is needed as first parameter to text.prefix$");
            stack.push("");
            return;
        }
        if (!(o1 instanceof String)) {
            this.vm.warn("A string is needed as second parameter to text.prefix$");
            stack.push("");
            return;
        }
        stack.push(BibtexTextPrefix.textPrefix((Integer)o1, (String)o2, this.vm));
    }
}

