/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataChange
extends Change {
    static final int ADD = 1;
    static final int REMOVE = 2;
    static final int MODIFY = 3;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);
    private MetaData md;
    private MetaData mdSecondary;
    ArrayList<MetaDataChangeUnit> changes = new ArrayList();

    public MetaDataChange(MetaData md, MetaData mdSecondary) {
        super(Globals.lang("Metadata change"));
        this.md = md;
        this.mdSecondary = mdSecondary;
        this.tp.setText("<html>" + Globals.lang("Metadata change") + "</html>");
    }

    public int getChangeCount() {
        return this.changes.size();
    }

    public void insertMetaDataAddition(String key, Vector<String> value) {
        this.changes.add(new MetaDataChangeUnit(1, key, value));
    }

    public void insertMetaDataRemoval(String key) {
        this.changes.add(new MetaDataChangeUnit(2, key, null));
    }

    public void insertMetaDataChange(String key, Vector<String> value) {
        this.changes.add(new MetaDataChangeUnit(3, key, value));
    }

    @Override
    JComponent description() {
        StringBuilder sb = new StringBuilder("<html>" + Globals.lang("Changes have been made to the following metadata elements") + ":<p>");
        for (MetaDataChangeUnit unit : this.changes) {
            sb.append("<br>&nbsp;&nbsp;");
            sb.append(unit.key);
        }
        sb.append("</html>");
        this.tp.setText(sb.toString());
        return this.sp;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        for (MetaDataChangeUnit unit : this.changes) {
            switch (unit.type) {
                case 1: {
                    this.md.putData(unit.key, unit.value);
                    this.mdSecondary.putData(unit.key, unit.value);
                    break;
                }
                case 2: {
                    this.md.remove(unit.key);
                    this.mdSecondary.remove(unit.key);
                    break;
                }
                case 3: {
                    this.md.putData(unit.key, unit.value);
                    this.mdSecondary.putData(unit.key, unit.value);
                }
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetaDataChangeUnit {
        int type;
        String key;
        Vector<String> value;

        public MetaDataChangeUnit(int type, String key, Vector<String> value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }
    }
}

