/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import java.util.TreeMap;
import net.sf.jabref.Globals;
import net.sf.jabref.export.ExportFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomExportList {
    private EventList<String[]> list;
    private SortedList<String[]> sorted;
    private TreeMap<String, ExportFormat> formats = new TreeMap();
    private Object[] array;

    public CustomExportList(Comparator<String[]> comp) {
        this.list = new BasicEventList<String[]>();
        this.sorted = new SortedList<String[]>(this.list, comp);
    }

    public TreeMap<String, ExportFormat> getCustomExportFormats() {
        this.formats.clear();
        this.readPrefs();
        return this.formats;
    }

    public int size() {
        return this.list.size();
    }

    public EventList<String[]> getSortedList() {
        return this.sorted;
    }

    private void readPrefs() {
        String[] s;
        this.formats.clear();
        this.list.clear();
        int i = 0;
        while ((s = Globals.prefs.getStringArray("customExportFormat" + i)) != null) {
            ExportFormat format = this.createFormat(s);
            if (format != null) {
                this.formats.put(format.getConsoleName(), format);
                this.list.add(s);
            } else {
                System.out.println(Globals.lang("Error initializing custom export format from string '%0'", Globals.prefs.get("customExportFormat" + i)));
            }
            ++i;
        }
    }

    private ExportFormat createFormat(String[] s) {
        if (s.length < 3) {
            return null;
        }
        String lfFileName = s[1].endsWith(".layout") ? s[1].substring(0, s[1].length() - 7) : s[1];
        ExportFormat format = new ExportFormat(s[0], s[0], lfFileName, null, s[2]);
        format.setCustomExport(true);
        return format;
    }

    public String[] getElementAt(int pos) {
        return (String[])this.array[pos];
    }

    public void addFormat(String[] s) {
        this.list.add(s);
        ExportFormat format = this.createFormat(s);
        this.formats.put(format.getConsoleName(), format);
    }

    public void remove(String[] toRemove) {
        ExportFormat format = this.createFormat(toRemove);
        this.formats.remove(format.getConsoleName());
        this.list.remove(toRemove);
    }

    public void store() {
        if (this.list.size() == 0) {
            this.purge(0);
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Globals.prefs.putStringArray("customExportFormat" + i, (String[])this.list.get(i));
            }
            this.purge(this.list.size());
        }
    }

    private void purge(int from) {
        int i = from;
        while (Globals.prefs.getStringArray("customExportFormat" + i) != null) {
            Globals.prefs.remove("customExportFormat" + i);
            ++i;
        }
    }
}

