/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.FieldComparatorStack;
import net.sf.jabref.export.layout.format.GetOpenOfficeType;
import net.sf.jabref.export.layout.format.RemoveBrackets;
import net.sf.jabref.export.layout.format.RemoveWhitespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOCalcDatabase {
    protected Collection<BibtexEntry> entries;

    public OOCalcDatabase(BibtexDatabase bibtex, Set<String> keySet) {
        ArrayList<FieldComparator> comparators = new ArrayList<FieldComparator>();
        comparators.add(new FieldComparator("author"));
        comparators.add(new FieldComparator("year"));
        comparators.add(new FieldComparator("bibtexkey"));
        BasicEventList<BibtexEntry> entryList = new BasicEventList<BibtexEntry>();
        if (keySet == null) {
            entryList.addAll(bibtex.getEntries());
        } else {
            for (String key : keySet) {
                entryList.add(bibtex.getEntryById(key));
            }
        }
        this.entries = new SortedList<BibtexEntry>(entryList, new FieldComparatorStack(comparators));
    }

    public Document getDOMrepresentation() {
        Document result = null;
        try {
            DocumentBuilder dbuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            result = dbuild.newDocument();
            Element collection = result.createElement("office:document-content");
            collection.setAttribute("xmlns:office", "http://openoffice.org/2000/office");
            collection.setAttribute("xmlns:style", "http://openoffice.org/2000/style");
            collection.setAttribute("xmlns:text", "http://openoffice.org/2000/text");
            collection.setAttribute("xmlns:table", "http://openoffice.org/2000/table");
            collection.setAttribute("xmlns:office:class", "spreadsheet");
            collection.setAttribute("xmlns:office:version", "1.0");
            collection.setAttribute("xmlns:fo", "http://www.w3.org/1999/XSL/Format");
            Element el = result.createElement("office:script");
            collection.appendChild(el);
            el = result.createElement("office:automatic-styles");
            Element el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ro1");
            el2.setAttribute("style:family", "table-row");
            Element el3 = result.createElement("style.properties");
            el3.setAttribute("style:row-height", "0.1681inch");
            el3.setAttribute("fo:break-before", "auto");
            el3.setAttribute("style:use-optimal-row-height", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            el2 = result.createElement("style:style");
            el2.setAttribute("style:name", "ta1");
            el2.setAttribute("style:family", "table");
            el2.setAttribute("style:master-page-name", "Default");
            el3 = result.createElement("style:properties");
            el3.setAttribute("table:display", "true");
            el2.appendChild(el3);
            el.appendChild(el2);
            collection.appendChild(el);
            Element body = result.createElement("office:body");
            Element table = result.createElement("table:table");
            table.setAttribute("table:name", "biblio");
            table.setAttribute("table.style-name", "ta1");
            Element row = result.createElement("table:table-row");
            row.setAttribute("table.style-name", "ro1");
            this.addTableCell(result, row, "Type");
            this.addTableCell(result, row, "ISBN");
            this.addTableCell(result, row, "Identifier");
            this.addTableCell(result, row, "Author");
            this.addTableCell(result, row, "Title");
            this.addTableCell(result, row, "Journal");
            this.addTableCell(result, row, "Volume");
            this.addTableCell(result, row, "Number");
            this.addTableCell(result, row, "Month");
            this.addTableCell(result, row, "Pages");
            this.addTableCell(result, row, "Year");
            this.addTableCell(result, row, "Address");
            this.addTableCell(result, row, "Note");
            this.addTableCell(result, row, "URL");
            this.addTableCell(result, row, "Booktitle");
            this.addTableCell(result, row, "Chapter");
            this.addTableCell(result, row, "Edition");
            this.addTableCell(result, row, "Series");
            this.addTableCell(result, row, "Editor");
            this.addTableCell(result, row, "Publisher");
            this.addTableCell(result, row, "ReportType");
            this.addTableCell(result, row, "Howpublished");
            this.addTableCell(result, row, "Institution");
            this.addTableCell(result, row, "Organization");
            this.addTableCell(result, row, "School");
            this.addTableCell(result, row, "Annote");
            this.addTableCell(result, row, "Custom1");
            this.addTableCell(result, row, "Custom2");
            this.addTableCell(result, row, "Custom3");
            this.addTableCell(result, row, "Custom4");
            this.addTableCell(result, row, "Custom5");
            table.appendChild(row);
            for (BibtexEntry e : this.entries) {
                row = result.createElement("table:table-row");
                this.addTableCell(result, row, new GetOpenOfficeType().format(e.getType().getName()));
                this.addTableCell(result, row, this.getField(e, "isbn"));
                this.addTableCell(result, row, this.getField(e, "bibtexkey"));
                this.addTableCell(result, row, this.getField(e, "author"));
                this.addTableCell(result, row, new RemoveWhitespace().format(new RemoveBrackets().format(this.getField(e, "title"))));
                this.addTableCell(result, row, this.getField(e, "journal"));
                this.addTableCell(result, row, this.getField(e, "volume"));
                this.addTableCell(result, row, this.getField(e, "number"));
                this.addTableCell(result, row, this.getField(e, "month"));
                this.addTableCell(result, row, this.getField(e, "pages"));
                this.addTableCell(result, row, this.getField(e, "year"));
                this.addTableCell(result, row, this.getField(e, "address"));
                this.addTableCell(result, row, this.getField(e, "note"));
                this.addTableCell(result, row, this.getField(e, "url"));
                this.addTableCell(result, row, this.getField(e, "booktitle"));
                this.addTableCell(result, row, this.getField(e, "chapter"));
                this.addTableCell(result, row, this.getField(e, "edition"));
                this.addTableCell(result, row, this.getField(e, "series"));
                this.addTableCell(result, row, this.getField(e, "editor"));
                this.addTableCell(result, row, this.getField(e, "publisher"));
                this.addTableCell(result, row, this.getField(e, "reporttype"));
                this.addTableCell(result, row, this.getField(e, "howpublished"));
                this.addTableCell(result, row, this.getField(e, "institution"));
                this.addTableCell(result, row, this.getField(e, "organization"));
                this.addTableCell(result, row, this.getField(e, "school"));
                this.addTableCell(result, row, this.getField(e, "annote"));
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                this.addTableCell(result, row, "");
                table.appendChild(row);
            }
            body.appendChild(table);
            collection.appendChild(body);
            result.appendChild(collection);
        }
        catch (Exception e) {
            System.out.println("Exception caught..." + e);
            e.printStackTrace();
        }
        return result;
    }

    protected String getField(BibtexEntry e, String field) {
        String o = e.getField(field);
        return o == null ? "" : o.toString();
    }

    protected void addTableCell(Document doc, Element parent, String content) {
        Element cell = doc.createElement("table:table-cell");
        Element text = doc.createElement("text:p");
        Text textNode = doc.createTextNode(content);
        text.appendChild(textNode);
        cell.appendChild(text);
        parent.appendChild(cell);
    }
}

