/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class RTFChars
implements LayoutFormatter {
    public String format(String field) {
        StringBuffer sb = new StringBuffer("");
        StringBuffer currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                incommand = true;
                currentCommand = new StringBuffer();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || Globals.SPECIAL_COMMAND_CHARS.indexOf("" + c) >= 0) {
                String combody;
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() != 1 || Globals.SPECIAL_COMMAND_CHARS.indexOf(currentCommand.toString()) < 0 || i >= field.length() - 1) continue;
                command = currentCommand.toString();
                if ((c = field.charAt(++i)) == '{') {
                    IntAndString part = this.getPart(field, i);
                    i += part.i;
                    combody = part.s;
                } else {
                    combody = field.substring(i, i + 1);
                }
                String result = Globals.RTFCHARS.get(command + combody);
                if (result != null) {
                    sb.append(result);
                }
                incommand = false;
                escaped = false;
                continue;
            }
            if (!incommand || !Character.isWhitespace(c) && c != '{' && c != '}') {
                sb.append(c);
            } else {
                if (c == '{' && currentCommand.length() == 0) continue;
                if (c == '}' && currentCommand.length() > 0) {
                    command = currentCommand.toString();
                    String result = Globals.RTFCHARS.get(command);
                    if (result != null) {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i < field.length() - 1) {
                    if (c == '{' && currentCommand.length() > 0) {
                        IntAndString part;
                        command = currentCommand.toString();
                        if (command.equals("em") || command.equals("emph") || command.equals("textit")) {
                            part = this.getPart(field, i);
                            i += part.i;
                            sb.append("}{\\i ").append(part.s).append("}{");
                        } else if (command.equals("textbf")) {
                            part = this.getPart(field, i);
                            i += part.i;
                            sb.append("}{\\b ").append(part.s).append("}{");
                        }
                    } else {
                        sb.append(c);
                    }
                }
            }
            incommand = false;
            escaped = false;
        }
        char[] chars = sb.toString().toCharArray();
        sb = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < '\u0080') {
                sb.append(c);
                continue;
            }
            sb.append("\\u").append((long)c).append('?');
        }
        return sb.toString().replaceAll("---", "{\\\\emdash}").replaceAll("--", "{\\\\endash}").replaceAll("``", "{\\\\ldblquote}").replaceAll("''", "{\\\\rdblquote}");
    }

    private IntAndString getPart(String text, int i) {
        int count = 0;
        StringBuffer part = new StringBuffer();
        while (count >= 0 && i < text.length()) {
            char c;
            if ((c = text.charAt(++i)) == '}') {
                --count;
            } else if (c == '{') {
                ++count;
            }
            part.append(c);
        }
        return new IntAndString(part.length(), this.format(part.toString()));
    }

    private class IntAndString {
        public int i;
        String s;

        public IntAndString(int i, String s) {
            this.i = i;
            this.s = s;
        }
    }
}

