/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.util.XMPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroppedFileHandler {
    private JabRefFrame frame;
    private BasePanel panel;
    private JRadioButton linkInPlace = new JRadioButton();
    private JRadioButton copyRadioButton = new JRadioButton();
    private JRadioButton moveRadioButton = new JRadioButton();
    private JLabel destDirLabel = new JLabel();
    private JCheckBox renameCheckBox = new JCheckBox();
    private JTextField renameToTextBox = new JTextField(50);
    private JPanel optionsPanel = new JPanel();

    public DroppedFileHandler(JabRefFrame frame, BasePanel panel) {
        this.frame = frame;
        this.panel = panel;
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.linkInPlace);
        grp.add(this.copyRadioButton);
        grp.add(this.moveRadioButton);
        this.copyRadioButton.setSelected(true);
        FormLayout layout = new FormLayout("left:15dlu,pref,pref,pref", "bottom:14pt,pref,pref,pref,pref");
        layout.setRowGroups(new int[][]{{1, 2, 3, 4, 5}});
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, this.optionsPanel);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.linkInPlace, cc.xyw(1, 1, 4));
        builder.add((Component)this.destDirLabel, cc.xyw(1, 2, 4));
        builder.add((Component)this.copyRadioButton, cc.xyw(2, 3, 3));
        builder.add((Component)this.moveRadioButton, cc.xyw(2, 4, 3));
        builder.add((Component)this.renameCheckBox, cc.xyw(2, 5, 1));
        builder.add((Component)this.renameToTextBox, cc.xyw(4, 5, 1));
    }

    public void handleDroppedfile(String fileName, ExternalFileType fileType, boolean localFile, MainTable mainTable, int dropRow) {
        BibtexEntry entry = mainTable.getEntryAt(dropRow);
        this.handleDroppedfile(fileName, fileType, localFile, entry);
    }

    public void handleDroppedfile(String fileName, ExternalFileType fileType, boolean localFile, BibtexEntry entry) {
        String destFilename;
        NamedCompound edits = new NamedCompound(Globals.lang("Drop %0", fileType.extension));
        if (this.tryXmpImport(fileName, fileType, localFile, edits)) {
            edits.end();
            this.panel.undoManager.addEdit(edits);
            return;
        }
        boolean newEntry = false;
        String citeKey = entry.getCiteKey();
        int reply = this.showLinkMoveCopyRenameDialog(fileName, fileType, entry, newEntry, false, this.panel.database());
        if (reply != 0) {
            return;
        }
        boolean success = true;
        if (this.linkInPlace.isSelected()) {
            destFilename = fileName;
        } else {
            String string = destFilename = this.renameCheckBox.isSelected() ? this.renameToTextBox.getText() : new File(fileName).getName();
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, fileType, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, fileType, destFilename, edits);
            }
        }
        if (success) {
            this.doLink(entry, fileType, destFilename, false, edits);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        edits.end();
        this.panel.undoManager.addEdit(edits);
    }

    public void linkPdfToEntry(String fileName, MainTable entryTable, int dropRow) {
        BibtexEntry entry = entryTable.getEntryAt(dropRow);
        this.linkPdfToEntry(fileName, entryTable, entry);
    }

    public void linkPdfToEntry(String fileName, MainTable entryTable, BibtexEntry entry) {
        String destFilename;
        ExternalFileType fileType = Globals.prefs.getExternalFileTypeByExt("pdf");
        NamedCompound edits = new NamedCompound(Globals.lang("Drop %0", fileType.extension));
        boolean newEntry = false;
        String citeKey = entry.getCiteKey();
        int reply = this.showLinkMoveCopyRenameDialog(fileName, fileType, entry, newEntry, false, this.panel.database());
        if (reply != 0) {
            return;
        }
        boolean success = true;
        if (this.linkInPlace.isSelected()) {
            destFilename = fileName;
        } else {
            String string = destFilename = this.renameCheckBox.isSelected() ? this.renameToTextBox.getText() : new File(fileName).getName();
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, fileType, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, fileType, destFilename, edits);
            }
        }
        if (success) {
            this.doLink(entry, fileType, destFilename, false, edits);
            this.panel.markBaseChanged();
        }
        edits.end();
        this.panel.undoManager.addEdit(edits);
    }

    public void importXmp(List<BibtexEntry> xmpEntriesInFile, String fileName) {
        String destFilename;
        ExternalFileType fileType = Globals.prefs.getExternalFileTypeByExt("pdf");
        NamedCompound edits = new NamedCompound(Globals.lang("Drop %0", fileType.extension));
        boolean isSingle = xmpEntriesInFile.size() == 1;
        BibtexEntry single = isSingle ? xmpEntriesInFile.get(0) : null;
        boolean success = true;
        if (this.linkInPlace.isSelected()) {
            destFilename = fileName;
        } else {
            destFilename = this.renameCheckBox.isSelected() ? fileName : single.getCiteKey() + "." + fileType.extension;
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, fileType, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, fileType, destFilename, edits);
            }
        }
        if (success) {
            Iterator<BibtexEntry> it = xmpEntriesInFile.iterator();
            while (it.hasNext()) {
                try {
                    BibtexEntry entry = it.next();
                    entry.setId(Util.createNeutralId());
                    edits.addEdit(new UndoableInsertEntry(this.panel.getDatabase(), entry, this.panel));
                    this.panel.getDatabase().insertEntry(entry);
                    this.doLink(entry, fileType, destFilename, true, edits);
                }
                catch (KeyCollisionException ex) {}
            }
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        edits.end();
        this.panel.undoManager.addEdit(edits);
    }

    private boolean tryXmpImport(String fileName, ExternalFileType fileType, boolean localFile, NamedCompound edits) {
        String destFilename;
        if (!fileType.extension.equals("pdf")) {
            return false;
        }
        List<BibtexEntry> xmpEntriesInFile = null;
        try {
            xmpEntriesInFile = XMPUtil.readXMP(fileName);
        }
        catch (Exception e) {
            return false;
        }
        if (xmpEntriesInFile == null || xmpEntriesInFile.size() == 0) {
            return false;
        }
        JLabel confirmationMessage = new JLabel(Globals.lang("The PDF contains one or several bibtex-records.\nDo you want to import these as new entries into the current database?"));
        int reply = JOptionPane.showConfirmDialog(this.frame, confirmationMessage, Globals.lang("XMP metadata found in PDF: %0", fileName), 1, 3);
        if (reply == 2) {
            return true;
        }
        if (reply == 1) {
            return false;
        }
        boolean isSingle = xmpEntriesInFile.size() == 1;
        BibtexEntry single = isSingle ? xmpEntriesInFile.get(0) : null;
        boolean success = true;
        if (this.linkInPlace.isSelected()) {
            destFilename = fileName;
        } else {
            destFilename = this.renameCheckBox.isSelected() ? fileName : single.getCiteKey() + "." + fileType.extension;
            if (this.copyRadioButton.isSelected()) {
                success = this.doCopy(fileName, fileType, destFilename, edits);
            } else if (this.moveRadioButton.isSelected()) {
                success = this.doMove(fileName, fileType, destFilename, edits);
            }
        }
        if (success) {
            Iterator<BibtexEntry> it = xmpEntriesInFile.iterator();
            while (it.hasNext()) {
                try {
                    BibtexEntry entry = it.next();
                    entry.setId(Util.createNeutralId());
                    edits.addEdit(new UndoableInsertEntry(this.panel.getDatabase(), entry, this.panel));
                    this.panel.getDatabase().insertEntry(entry);
                    this.doLink(entry, fileType, destFilename, true, edits);
                }
                catch (KeyCollisionException ex) {}
            }
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showLinkMoveCopyRenameDialog(String linkFileName, ExternalFileType fileType, BibtexEntry entry, boolean newEntry, final boolean multipleEntries, BibtexDatabase database) {
        String citeKey = entry.getCiteKey();
        String dialogTitle = Globals.lang("Link to file %0", linkFileName);
        String[] dirs = this.panel.metaData().getFileDirectory("file");
        int found = -1;
        for (int i = 0; i < dirs.length; ++i) {
            if (!new File(dirs[i]).exists()) continue;
            found = i;
            break;
        }
        if (found < 0) {
            this.destDirLabel.setText(Globals.lang("File directory is not set or does not exist."));
            this.copyRadioButton.setEnabled(false);
            this.moveRadioButton.setEnabled(false);
            this.renameToTextBox.setEnabled(false);
            this.renameCheckBox.setEnabled(false);
            this.linkInPlace.setSelected(true);
        } else {
            this.destDirLabel.setText(Globals.lang("File directory is '%0':", dirs[found]));
            this.copyRadioButton.setEnabled(true);
            this.moveRadioButton.setEnabled(true);
            this.renameToTextBox.setEnabled(true);
            this.renameCheckBox.setEnabled(true);
        }
        ChangeListener cl = new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                DroppedFileHandler.this.renameCheckBox.setEnabled(!DroppedFileHandler.this.linkInPlace.isSelected() && !multipleEntries);
                DroppedFileHandler.this.renameToTextBox.setEnabled(!DroppedFileHandler.this.linkInPlace.isSelected() && !multipleEntries);
                if (multipleEntries) {
                    DroppedFileHandler.this.renameToTextBox.setText("Multiple entries");
                }
            }
        };
        if (multipleEntries) {
            this.linkInPlace.setText(Globals.lang("Leave files in their current directory."));
            this.copyRadioButton.setText(Globals.lang("Copy files to file directory."));
            this.moveRadioButton.setText(Globals.lang("Move files to file directory."));
        } else {
            this.linkInPlace.setText(Globals.lang("Leave file in its current directory."));
            this.copyRadioButton.setText(Globals.lang("Copy file to file directory."));
            this.moveRadioButton.setText(Globals.lang("Move file to file directory."));
        }
        this.renameCheckBox.setText(Globals.lang("Rename file to").concat(": "));
        String targetName = Util.getLinkedFileName(database, entry);
        this.renameToTextBox.setText(targetName.concat(".").concat(fileType.extension));
        this.linkInPlace.addChangeListener(cl);
        cl.stateChanged(new ChangeEvent(this.linkInPlace));
        try {
            Object[] messages = new Object[]{"How would you like to link to " + linkFileName + "?", this.optionsPanel};
            int n = JOptionPane.showConfirmDialog(this.frame, messages, dialogTitle, 2, 3);
            return n;
        }
        finally {
            this.linkInPlace.removeChangeListener(cl);
        }
    }

    private void doLink(BibtexEntry entry, ExternalFileType fileType, String filename, boolean avoidDuplicate, NamedCompound edits) {
        String oldValue = entry.getField("file");
        FileListTableModel tm = new FileListTableModel();
        if (oldValue != null) {
            tm.setContent(oldValue);
        }
        if (avoidDuplicate) {
            String[] dirs = this.panel.metaData().getFileDirectory("file");
            String absFilename = !new File(filename).isAbsolute() && dirs.length > 0 ? Util.expandFilename(filename, dirs).getAbsolutePath() : filename;
            for (int i = 0; i < tm.getRowCount(); ++i) {
                FileListEntry flEntry = tm.getEntry(i);
                String absName = !new File(flEntry.getLink()).isAbsolute() && dirs.length > 0 ? Util.expandFilename(flEntry.getLink(), dirs).getAbsolutePath() : flEntry.getLink();
                System.out.println("absName: " + absName);
                if (!absFilename.equals(absName)) continue;
                return;
            }
        }
        tm.addEntry(tm.getRowCount(), new FileListEntry("", filename, fileType));
        String newValue = tm.getStringRepresentation();
        UndoableFieldChange edit = new UndoableFieldChange(entry, "file", oldValue, newValue);
        entry.setField("file", newValue);
        if (edits == null) {
            this.panel.undoManager.addEdit(edit);
        } else {
            edits.addEdit(edit);
        }
    }

    private boolean doMove(String fileName, ExternalFileType fileType, String destFilename, NamedCompound edits) {
        int answer;
        String[] dirs = this.panel.metaData().getFileDirectory("file");
        int found = -1;
        for (int i = 0; i < dirs.length; ++i) {
            if (!new File(dirs[i]).exists()) continue;
            found = i;
            break;
        }
        if (found < 0) {
            return false;
        }
        File fromFile = new File(fileName);
        File toFile = new File(dirs[found] + System.getProperty("file.separator") + destFilename);
        if (toFile.exists() && (answer = JOptionPane.showConfirmDialog(this.frame, toFile.getAbsolutePath() + " exists. Overwrite?", "Overwrite file?", 0)) == 1) {
            return false;
        }
        if (!fromFile.renameTo(toFile)) {
            JOptionPane.showMessageDialog(this.frame, "There was an error moving the file. Please move the file manually and link in place.", "Error moving file", 0);
            return false;
        }
        return true;
    }

    private boolean doCopy(String fileName, ExternalFileType fileType, String toFile, NamedCompound edits) {
        int answer;
        String[] dirs = this.panel.metaData().getFileDirectory("file");
        int found = -1;
        for (int i = 0; i < dirs.length; ++i) {
            if (!new File(dirs[i]).exists()) continue;
            found = i;
            break;
        }
        if (found < 0) {
            System.out.println("dir: " + dirs[found] + "\t ext: " + fileType.getExtension());
            return false;
        }
        toFile = new File(toFile).getName();
        File destFile = new File(new StringBuffer(dirs[found]).append(System.getProperty("file.separator")).append(toFile).toString());
        if (destFile.equals(new File(fileName))) {
            return true;
        }
        if (destFile.exists() && (answer = JOptionPane.showConfirmDialog(this.frame, "'" + destFile.getPath() + "' " + Globals.lang("exists. Overwrite?"), Globals.lang("File exists"), 0, 3)) == 1) {
            return false;
        }
        try {
            Util.copyFile(new File(fileName), destFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

