/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.transform.TransformerException;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.UrlDragDrop;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.util.XMPUtil;

public class ExternalFilePanel
extends JPanel {
    private static final long serialVersionUID = 3653290879640642718L;
    private JButton browseBut;
    private JButton download;
    private JButton auto;
    private JButton xmp;
    private EntryEditor entryEditor;
    private JabRefFrame frame;
    private OpenFileFilter off;
    private BibtexEntry entry;
    private BibtexDatabase database;
    private MetaData metaData;

    public ExternalFilePanel(String fieldName, MetaData metaData, BibtexEntry entry, FieldEditor editor, OpenFileFilter off) {
        this(null, metaData, null, fieldName, off, editor);
        this.entry = entry;
        this.entryEditor = null;
    }

    public ExternalFilePanel(final JabRefFrame frame, MetaData metaData, final EntryEditor entryEditor, final String fieldName, OpenFileFilter off, final FieldEditor editor) {
        this.frame = frame;
        this.metaData = metaData;
        this.off = off;
        this.entryEditor = entryEditor;
        this.setLayout(new GridLayout(2, 2));
        this.browseBut = new JButton(Globals.lang("Browse"));
        this.download = new JButton(Globals.lang("Download"));
        this.auto = new JButton(Globals.lang("Auto"));
        this.xmp = new JButton(Globals.lang("Write XMP"));
        this.xmp.setToolTipText(Globals.lang("Write BibtexEntry as XMP-metadata to PDF."));
        this.browseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalFilePanel.this.browseFile(fieldName, editor);
                entryEditor.storeFieldAction.actionPerformed(new ActionEvent(editor, 0, ""));
            }
        });
        this.download.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalFilePanel.this.downLoadFile(fieldName, editor, frame);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalFilePanel.this.autoSetFile(fieldName, editor);
            }
        });
        this.xmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalFilePanel.this.pushXMP(fieldName, editor);
            }
        });
        this.add(this.browseBut);
        this.add(this.download);
        this.add(this.auto);
        this.add(this.xmp);
        if (editor != null) {
            ((JComponent)((Object)editor)).setDropTarget(new DropTarget((Component)((Object)editor), 0, new UrlDragDrop(entryEditor, frame, editor)));
        }
    }

    public void setEntry(BibtexEntry entry, BibtexDatabase database) {
        this.entry = entry;
        this.database = database;
    }

    public BibtexDatabase getDatabase() {
        return this.database != null ? this.database : this.entryEditor.getDatabase();
    }

    public BibtexEntry getEntry() {
        return this.entry != null ? this.entry : this.entryEditor.getEntry();
    }

    protected Object getKey() {
        return this.getEntry().getField("bibtexkey");
    }

    protected void output(String s) {
        if (this.frame != null) {
            this.frame.output(s);
        }
    }

    public void pushXMP(final String fieldName, final FieldEditor editor) {
        new Thread(){

            public void run() {
                File tmp;
                ExternalFilePanel.this.output(Globals.lang("Looking for pdf..."));
                String[] dirs = ExternalFilePanel.this.metaData.getFileDirectory(fieldName);
                File file = null;
                if (dirs.length > 0 && (tmp = Util.expandFilename(editor.getText(), dirs)) != null) {
                    file = tmp;
                }
                if (file == null) {
                    file = new File(editor.getText());
                }
                File finalFile = file;
                ExternalFilePanel.this.output(Globals.lang("Writing XMP to '%0'...", finalFile.getName()));
                try {
                    XMPUtil.writeXMP(finalFile, ExternalFilePanel.this.getEntry(), ExternalFilePanel.this.getDatabase());
                    ExternalFilePanel.this.output(Globals.lang("Wrote XMP to '%0'.", finalFile.getName()));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(editor.getParent(), Globals.lang("Error writing XMP to file: %0", e.getLocalizedMessage()), Globals.lang("Writing XMP"), 0);
                    Globals.logger(Globals.lang("Error writing XMP to file: %0", finalFile.getAbsolutePath()));
                    ExternalFilePanel.this.output(Globals.lang("Error writing XMP to file: %0", finalFile.getName()));
                }
                catch (TransformerException e) {
                    JOptionPane.showMessageDialog(editor.getParent(), Globals.lang("Error converting Bibtex to XMP: %0", e.getLocalizedMessage()), Globals.lang("Writing XMP"), 0);
                    Globals.logger(Globals.lang("Error while converting BibtexEntry to XMP %0", finalFile.getAbsolutePath()));
                    ExternalFilePanel.this.output(Globals.lang("Error converting XMP to '%0'...", finalFile.getName()));
                }
            }
        }.start();
    }

    public void browseFile(String fieldName, FieldEditor editor) {
        String chosenFile;
        String[] dirs = this.metaData.getFileDirectory(fieldName);
        String directory = null;
        if (dirs.length > 0) {
            directory = dirs[0];
        }
        String dir = editor.getText();
        String retVal = null;
        if (directory == null || !new File(dir).isAbsolute()) {
            dir = directory != null ? directory : Globals.prefs.get(fieldName + "_dir", "");
        }
        if ((chosenFile = FileDialogs.getNewFile(this.frame, new File(dir), "." + fieldName, 0, false)) != null) {
            File newFile = new File(chosenFile);
            String position = newFile.getParent();
            if (directory != null && position.startsWith(directory)) {
                String relPath = position.substring(directory.length(), position.length()) + File.separator + newFile.getName();
                if (relPath.startsWith(File.separator)) {
                    relPath = relPath.substring(File.separator.length(), relPath.length());
                }
                retVal = relPath;
            } else {
                retVal = newFile.getPath();
            }
            editor.setText(retVal);
            Globals.prefs.put(fieldName + "_dir", newFile.getPath());
        }
    }

    public void downLoadFile(final String fieldName, final FieldEditor fieldEditor, final Component parent) {
        final String res = JOptionPane.showInputDialog(parent, (Object)Globals.lang("Enter URL to download"));
        if (res == null || res.trim().length() == 0) {
            return;
        }
        final BibtexEntry targetEntry = this.entryEditor != null ? this.entryEditor.getEntry() : this.entry;
        new Thread(){

            public String getPlannedFileName(String res2) {
                String suffix = ExternalFilePanel.this.off.getSuffix(res2);
                if (suffix == null) {
                    suffix = "." + fieldName.toLowerCase();
                }
                String plannedName = null;
                if (ExternalFilePanel.this.getKey() != null) {
                    plannedName = ExternalFilePanel.this.getKey() + suffix;
                } else {
                    plannedName = JOptionPane.showInputDialog(parent, (Object)Globals.lang("BibTeX key not set. Enter a name for the downloaded file"));
                    if (plannedName != null && !ExternalFilePanel.this.off.accept(plannedName)) {
                        plannedName = plannedName + suffix;
                    }
                }
                if (Globals.ON_WIN) {
                    plannedName = plannedName.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
                } else if (Globals.ON_MAC) {
                    plannedName = plannedName.replaceAll(":", "");
                }
                return plannedName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String originalText = fieldEditor.getText();
                fieldEditor.setEnabled(false);
                boolean updateEditor = true;
                try {
                    fieldEditor.setText(Globals.lang("Downloading..."));
                    ExternalFilePanel.this.output(Globals.lang("Downloading..."));
                    String plannedName = this.getPlannedFileName(res);
                    String[] dirs = ExternalFilePanel.this.metaData.getFileDirectory(fieldName);
                    String directory = null;
                    for (int i = 0; i < dirs.length; ++i) {
                        if (!new File(dirs[i]).exists()) continue;
                        directory = dirs[i];
                        break;
                    }
                    if (directory == null) {
                        if (dirs.length > 0) {
                            JOptionPane.showMessageDialog(parent, Globals.lang("Could not find directory for %0-files: %1", fieldName, dirs[0]), Globals.lang("Download file"), 0);
                        } else {
                            JOptionPane.showMessageDialog(parent, Globals.lang("No directory defined for %0-files", fieldName), Globals.lang("Download file"), 0);
                        }
                        return;
                    }
                    File file = new File(new File(directory), plannedName);
                    URL url = new URL(res);
                    URLDownload udl = new URLDownload(parent, url, file);
                    try {
                        udl.download();
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(parent, Globals.lang("Invalid URL") + ": " + e2.getMessage(), Globals.lang("Download file"), 0);
                        Globals.logger("Error while downloading " + url.toString());
                        if (updateEditor) {
                            fieldEditor.setText(originalText);
                            fieldEditor.setEnabled(true);
                        }
                        return;
                    }
                    ExternalFilePanel.this.output(Globals.lang("Download completed"));
                    String textToSet = file.getPath();
                    if (textToSet.startsWith(directory) && (textToSet = textToSet.substring(directory.length(), textToSet.length())).startsWith(File.separator)) {
                        textToSet = textToSet.substring(File.separator.length());
                    }
                    if (ExternalFilePanel.this.entryEditor == null || ExternalFilePanel.this.entryEditor.getEntry() != targetEntry) {
                        targetEntry.setField(fieldName, textToSet);
                        fieldEditor.setText(textToSet);
                        fieldEditor.setEnabled(true);
                        updateEditor = false;
                    } else {
                        fieldEditor.setText(textToSet);
                        fieldEditor.setEnabled(true);
                        updateEditor = false;
                        SwingUtilities.invokeLater(new Thread(){

                            public void run() {
                                ExternalFilePanel.this.entryEditor.updateField(fieldEditor);
                            }
                        });
                    }
                }
                catch (MalformedURLException e1) {
                    JOptionPane.showMessageDialog(parent, Globals.lang("Invalid URL"), Globals.lang("Download file"), 0);
                }
                finally {
                    if (updateEditor) {
                        fieldEditor.setText(originalText);
                        fieldEditor.setEnabled(true);
                    }
                }
            }
        }.start();
    }

    public Thread autoSetFile(final String fieldName, final FieldEditor editor) {
        Object o = this.getKey();
        if (o == null || Globals.prefs.get(fieldName + "Directory") == null) {
            this.output(Globals.lang("You must set both BibTeX key and %0 directory", fieldName.toUpperCase()) + ".");
            return null;
        }
        this.output(Globals.lang("Searching for %0 file", fieldName.toUpperCase()) + " '" + o + "." + fieldName + "'...");
        Thread t = new Thread(){

            public void run() {
                LinkedList<String> list = new LinkedList<String>();
                String[] dirs = ExternalFilePanel.this.metaData.getFileDirectory(fieldName);
                for (int i = 0; i < dirs.length; ++i) {
                    list.add(dirs[i]);
                }
                String found = Util.findPdf(ExternalFilePanel.this.getEntry(), fieldName, list.toArray(new String[list.size()]));
                if (found != null) {
                    editor.setText(found);
                    if (ExternalFilePanel.this.entryEditor != null) {
                        ExternalFilePanel.this.entryEditor.updateField(editor);
                    }
                    ExternalFilePanel.this.output(Globals.lang("%0 field set", fieldName.toUpperCase()) + ".");
                } else {
                    ExternalFilePanel.this.output(Globals.lang("No %0 found", fieldName.toUpperCase()) + ".");
                }
            }
        };
        t.start();
        return t;
    }
}

