/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.ExternalFileTypeEntryEditor;

public class ExternalFileTypeEditor
extends JDialog {
    private JFrame frame = null;
    private JDialog dialog = null;
    private ArrayList<ExternalFileType> fileTypes;
    private JTable table;
    private ExternalFileTypeEntryEditor entryEditor = null;
    private FileTypeTableModel tableModel;
    private JButton ok = new JButton(Globals.lang("Ok"));
    private JButton cancel = new JButton(Globals.lang("Cancel"));
    private JButton add = new JButton(GUIGlobals.getImage("add"));
    private JButton remove = new JButton(GUIGlobals.getImage("remove"));
    private JButton edit = new JButton(GUIGlobals.getImage("edit"));
    private JButton toDefaults = new JButton(Globals.lang("Default"));
    private EditListener editListener = new EditListener();

    public ExternalFileTypeEditor(JFrame frame) {
        super(frame, Globals.lang("Manage external file types"), true);
        this.frame = frame;
        this.init();
    }

    public ExternalFileTypeEditor(JDialog dialog) {
        super(dialog, Globals.lang("Manage external file types"), true);
        this.dialog = dialog;
        this.init();
    }

    public void setValues() {
        this.fileTypes.clear();
        ExternalFileType[] types = Globals.prefs.getExternalFileTypeSelection();
        for (int i = 0; i < types.length; ++i) {
            this.fileTypes.add(types[i].copy());
        }
        Collections.sort(this.fileTypes);
    }

    public void storeSettings() {
        Globals.prefs.setExternalFileTypes(this.fileTypes);
    }

    private void init() {
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalFileTypeEditor.this.storeSettings();
                ExternalFileTypeEditor.this.dispose();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExternalFileTypeEditor.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.toDefaults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List<ExternalFileType> list = Globals.prefs.getDefaultExternalFileTypes();
                ExternalFileTypeEditor.this.fileTypes.clear();
                ExternalFileTypeEditor.this.fileTypes.addAll(list);
                Collections.sort(ExternalFileTypeEditor.this.fileTypes);
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        });
        this.add.addActionListener(new AddListener());
        this.remove.addActionListener(new RemoveListener());
        this.edit.addActionListener(this.editListener);
        this.fileTypes = new ArrayList();
        this.setValues();
        this.tableModel = new FileTypeTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.table.addMouseListener(new TableClickListener());
        this.table.getColumnModel().getColumn(0).setMaxWidth(24);
        this.table.getColumnModel().getColumn(0).setMinWidth(24);
        this.table.getColumnModel().getColumn(1).setMinWidth(170);
        this.table.getColumnModel().getColumn(2).setMinWidth(60);
        this.table.getColumnModel().getColumn(3).setMinWidth(100);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        JScrollPane sp = new JScrollPane(this.table);
        JPanel upper = new JPanel();
        upper.setLayout(new BorderLayout());
        upper.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        upper.add((Component)sp, "Center");
        this.getContentPane().add((Component)upper, "Center");
        ButtonStackBuilder bs = new ButtonStackBuilder();
        bs.addGridded(this.add);
        bs.addGridded(this.remove);
        bs.addGridded(this.edit);
        bs.addRelatedGap();
        bs.addGridded(this.toDefaults);
        upper.add((Component)bs.getPanel(), "East");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
        ActionMap am = upper.getActionMap();
        InputMap im = upper.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        am = bb.getPanel().getActionMap();
        im = bb.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        if (this.frame != null) {
            this.setLocationRelativeTo(this.frame);
        } else {
            this.setLocationRelativeTo(this.dialog);
        }
    }

    private ExternalFileTypeEntryEditor getEditor(ExternalFileType type) {
        if (this.entryEditor == null) {
            this.entryEditor = new ExternalFileTypeEntryEditor(this, type);
        } else {
            this.entryEditor.setEntry(type);
        }
        return this.entryEditor;
    }

    public static AbstractAction getAction(JabRefFrame frame) {
        return new EditExternalFileTypesAction(frame);
    }

    public static AbstractAction getAction(JDialog dialog) {
        return new EditExternalFileTypesAction(dialog);
    }

    public static class EditExternalFileTypesAction
    extends MnemonicAwareAction {
        private JabRefFrame frame = null;
        private JDialog dialog = null;
        ExternalFileTypeEditor editor = null;

        public EditExternalFileTypesAction(JabRefFrame frame) {
            this.putValue("Name", "Manage external file types");
            this.frame = frame;
        }

        public EditExternalFileTypesAction(JDialog dialog) {
            this.putValue("Name", "Manage external file types");
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.editor == null) {
                this.editor = this.frame != null ? new ExternalFileTypeEditor(this.frame) : new ExternalFileTypeEditor(this.dialog);
            }
            this.editor.setValues();
            this.editor.setVisible(true);
            if (this.frame != null && this.frame.basePanel() != null) {
                this.frame.basePanel().mainTable.repaint();
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        private void handleClick(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ExternalFileTypeEditor.this.editListener.actionPerformed(null);
            }
        }

        public void mouseClicked(MouseEvent e) {
            this.handleClick(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handleClick(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleClick(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileTypeTableModel
    extends AbstractTableModel {
        FileTypeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return ExternalFileTypeEditor.this.fileTypes.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return Globals.lang("Name");
                }
                case 2: {
                    return Globals.lang("Extension");
                }
                case 3: {
                    return Globals.lang("MIME type");
                }
                case 4: {
                    return Globals.lang("Application");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ExternalFileType type = (ExternalFileType)ExternalFileTypeEditor.this.fileTypes.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return type.getIcon();
                }
                case 1: {
                    return type.getName();
                }
                case 2: {
                    return type.getExtension();
                }
                case 3: {
                    return type.getMimeType();
                }
                case 4: {
                    return type.getOpenWith();
                }
            }
            return null;
        }
    }

    class IconRenderer
    implements TableCellRenderer {
        JLabel lab = new JLabel();

        IconRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.lab.setText(null);
            this.lab.setIcon((ImageIcon)value);
            return this.lab;
        }
    }

    class EditListener
    implements ActionListener {
        EditListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = ExternalFileTypeEditor.this.table.getSelectedRows();
            if (rows.length != 1) {
                return;
            }
            ExternalFileTypeEditor.this.getEditor((ExternalFileType)ExternalFileTypeEditor.this.fileTypes.get(rows[0])).setVisible(true);
            if (ExternalFileTypeEditor.this.entryEditor.okPressed()) {
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        }
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = ExternalFileTypeEditor.this.table.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            for (int i = rows.length - 1; i >= 0; --i) {
                ExternalFileTypeEditor.this.fileTypes.remove(rows[i]);
            }
            ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            if (ExternalFileTypeEditor.this.fileTypes.size() > 0) {
                int row = Math.min(rows[0], ExternalFileTypeEditor.this.fileTypes.size() - 1);
                ExternalFileTypeEditor.this.table.setRowSelectionInterval(row, row);
            }
        }
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ExternalFileType type = new ExternalFileType("", "", "", "", "new");
            ExternalFileTypeEditor.this.getEditor(type).setVisible(true);
            if (ExternalFileTypeEditor.this.entryEditor.okPressed()) {
                ExternalFileTypeEditor.this.fileTypes.add(type);
                ExternalFileTypeEditor.this.tableModel.fireTableDataChanged();
            }
        }
    }
}

