/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListTableModel;

public class TransferableFileLinkSelection
implements Transferable {
    List<File> fileList = new ArrayList<File>();

    public TransferableFileLinkSelection(BasePanel panel, BibtexEntry[] selection) {
        String s = selection[0].getField("file");
        FileListTableModel tm = new FileListTableModel();
        if (s != null) {
            tm.setContent(s);
        }
        if (tm.getRowCount() > 0) {
            String[] dirs = panel.metaData().getFileDirectory("file");
            File expLink = Util.expandFilename(tm.getEntry(0).getLink(), dirs);
            this.fileList.add(expLink);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        System.out.println("Query: " + dataFlavor.getHumanPresentableName() + " , " + dataFlavor.getDefaultRepresentationClass() + " , " + dataFlavor.getMimeType());
        return dataFlavor.equals(DataFlavor.javaFileListFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.fileList;
    }
}

