/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.XMPUtil;

public class WriteXMPEntryEditorAction
extends AbstractAction {
    private BasePanel panel;
    private EntryEditor editor;
    private String message = null;

    public WriteXMPEntryEditorAction(BasePanel panel, EntryEditor editor) {
        this.panel = panel;
        this.editor = editor;
        this.putValue("Name", Globals.lang("Write XMP"));
        this.putValue("SmallIcon", GUIGlobals.getImage("pdfSmall"));
        this.putValue("ShortDescription", Globals.lang("Write BibtexEntry as XMP-metadata to PDF."));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setEnabled(false);
        this.panel.output(Globals.lang("Writing XMP metadata..."));
        this.panel.frame().setProgressBarIndeterminate(true);
        this.panel.frame().setProgressBarVisible(true);
        BibtexEntry entry = this.editor.getEntry();
        ArrayList<File> files = new ArrayList<File>();
        String pdf = entry.getField("pdf");
        String[] dirs = this.panel.metaData().getFileDirectory("pdf");
        File f = Util.expandFilename(pdf, dirs);
        if (f != null) {
            files.add(f);
        }
        dirs = this.panel.metaData().getFileDirectory("file");
        String field = entry.getField("file");
        if (field != null) {
            FileListTableModel tm = new FileListTableModel();
            tm.setContent(field);
            for (int j = 0; j < tm.getRowCount(); ++j) {
                FileListEntry flEntry = tm.getEntry(j);
                if (flEntry.getType() == null || !flEntry.getType().getName().toLowerCase().equals("pdf") || (f = Util.expandFilename(flEntry.getLink(), dirs)) == null) continue;
                files.add(f);
            }
        }
        WriteXMPWorker worker = new WriteXMPWorker(files, entry);
        worker.getWorker().run();
        this.panel.output(this.message);
        this.panel.frame().setProgressBarVisible(false);
        this.setEnabled(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriteXMPWorker
    extends AbstractWorker {
        private List<File> files;
        private BibtexEntry entry;

        public WriteXMPWorker(List<File> files, BibtexEntry entry) {
            this.files = files;
            this.entry = entry;
        }

        @Override
        public void run() {
            if (this.files.size() == 0) {
                WriteXMPEntryEditorAction.this.message = Globals.lang("No PDF linked") + ".\n";
            } else {
                int written = 0;
                int error = 0;
                for (File file : this.files) {
                    if (!file.exists()) {
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Globals.lang("PDF does not exist");
                        }
                        ++error;
                        continue;
                    }
                    try {
                        XMPUtil.writeXMP(file, this.entry, WriteXMPEntryEditorAction.this.panel.database());
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Globals.lang("Wrote XMP-metadata");
                        }
                        ++written;
                    }
                    catch (Exception e) {
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Globals.lang("Error while writing") + " '" + file.getPath() + "'";
                        }
                        ++error;
                    }
                }
                if (this.files.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(Globals.lang("Finished writing XMP-metadata. Wrote to %0 file(s).", String.valueOf(written)));
                    if (error > 0) {
                        sb.append(" " + Globals.lang("Error writing to %0 file(s).", String.valueOf(error)));
                    }
                    WriteXMPEntryEditorAction.this.message = sb.toString();
                }
            }
        }
    }
}

