/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FieldSetComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryTypeList
extends FieldSetComponent
implements ListSelectionListener,
ActionListener {
    protected JButton def = new JButton(Globals.lang("Default"));

    public EntryTypeList(List<String> fields) {
        super(Globals.lang("Entry types"), fields, false, true);
        this.con.gridx = 0;
        this.con.gridy = 2;
        this.con.fill = 3;
        this.con.anchor = 13;
        this.gbl.setConstraints(this.def, this.con);
        this.add(this.def);
        this.list.addListSelectionListener(this);
        this.def.addActionListener(this);
        this.def.setEnabled(false);
        this.remove.setEnabled(false);
    }

    @Override
    protected void addField(String s) {
        s = s.trim();
        if (this.forceLowerCase) {
            s = s.toLowerCase();
        }
        if (s.equals("") || this.listModel.contains(s)) {
            return;
        }
        String testString = Util.checkLegalKey(s);
        if (!testString.equals(s) || s.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Globals.lang("Entry type names are not allowed to contain white space or the following characters") + ": # { } ~ , ^ &", Globals.lang("Error"), 0);
            return;
        }
        if (s.equalsIgnoreCase("comment")) {
            JOptionPane.showMessageDialog(this, Globals.lang("The name 'comment' can not be used as an entry type name."), Globals.lang("Error"), 0);
            return;
        }
        this.addFieldUncritically(s);
    }

    @Override
    protected void removeSelected() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < selected.length; ++i) {
            String typeName = (String)this.listModel.get(selected[selected.length - 1 - i]);
            BibtexEntryType type = BibtexEntryType.getType(typeName);
            if (type != null && type instanceof CustomEntryType) {
                this.listModel.removeElementAt(selected[selected.length - 1 - i]);
                continue;
            }
            JOptionPane.showMessageDialog(null, Globals.lang("This entry type cannot be removed."), Globals.lang("Remove entry type"), 0);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
    }

    public void enable(String typeName, boolean isChanged) {
        if (BibtexEntryType.getStandardType(typeName) != null) {
            if (isChanged || BibtexEntryType.getType(typeName) instanceof CustomEntryType) {
                this.def.setEnabled(true);
            } else {
                this.def.setEnabled(false);
            }
            this.remove.setEnabled(false);
        } else {
            this.def.setEnabled(false);
            this.remove.setEnabled(true);
        }
    }

    public void addDefaultActionListener(ActionListener l) {
        this.def.addActionListener(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.def) {
            this.def.setEnabled(false);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setEnabled(boolean en) {
        super.setEnabled(en);
        this.def.setEnabled(en);
    }
}

