/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.FileListEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListTableModel
extends AbstractTableModel {
    private final ArrayList<FileListEntry> list = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.size();
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public Class<String> getColumnClass(int columnIndex) {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            FileListEntry entry = this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.getDescription();
                }
                case 1: {
                    return entry.getLink();
                }
            }
            return entry.getType() != null ? entry.getType().getName() : "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListEntry getEntry(int index) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(int index) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            this.list.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(final int index, FileListEntry entry) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(index, entry);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileListTableModel.this.fireTableRowsInserted(index, index);
                    }
                });
            } else {
                this.fireTableRowsInserted(index, index);
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void setContent(String value) {
        this.setContent(value, false, true);
    }

    public void setContentDontGuessTypes(String value) {
        this.setContent(value, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileListEntry setContent(String value, boolean firstOnly, boolean deduceUnknownTypes) {
        if (value == null) {
            value = "";
        }
        ArrayList<FileListEntry> newList = new ArrayList<FileListEntry>();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> thisEntry = new ArrayList<String>();
        boolean inXmlChar = false;
        boolean escaped = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && c == '&' && !inXmlChar) {
                sb.append(c);
                if (value.length() > i + 1 && value.charAt(i + 1) == '#') {
                    inXmlChar = true;
                }
            } else if (!escaped && inXmlChar && c == ';') {
                sb.append(c);
                inXmlChar = false;
            } else if (!escaped && c == ':') {
                thisEntry.add(sb.toString());
                sb = new StringBuilder();
            } else if (!escaped && c == ';' && !inXmlChar) {
                thisEntry.add(sb.toString());
                sb = new StringBuilder();
                if (firstOnly) {
                    return this.decodeEntry(thisEntry, deduceUnknownTypes);
                }
                newList.add(this.decodeEntry(thisEntry, deduceUnknownTypes));
                thisEntry.clear();
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        if (sb.length() > 0) {
            thisEntry.add(sb.toString());
        }
        if (thisEntry.size() > 0) {
            if (firstOnly) {
                return this.decodeEntry(thisEntry, deduceUnknownTypes);
            }
            newList.add(this.decodeEntry(thisEntry, deduceUnknownTypes));
        }
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
            this.list.addAll(newList);
        }
        this.fireTableChanged(new TableModelEvent(this));
        return null;
    }

    public static JLabel getFirstLabel(String content) {
        FileListTableModel tm = new FileListTableModel();
        FileListEntry entry = tm.setContent(content, true, true);
        if (entry == null || entry.getType() == null) {
            return null;
        }
        return entry.getType().getIconLabel();
    }

    private FileListEntry decodeEntry(ArrayList<String> contents, boolean deduceUnknownType) {
        ExternalFileType type = Globals.prefs.getExternalFileTypeByName(this.getElementIfAvailable(contents, 2));
        if (deduceUnknownType && type instanceof UnknownExternalFileType && (type = Globals.prefs.getExternalFileTypeByMimeType(this.getElementIfAvailable(contents, 2))) == null) {
            ExternalFileType typeGuess = null;
            String link = this.getElementIfAvailable(contents, 1);
            int index = link.lastIndexOf(46);
            if (index >= 0 && index < link.length() - 1) {
                String extension = link.substring(index + 1);
                typeGuess = Globals.prefs.getExternalFileTypeByExt(extension);
            }
            if (typeGuess != null) {
                type = typeGuess;
            }
        }
        return new FileListEntry(this.getElementIfAvailable(contents, 0), this.getElementIfAvailable(contents, 1), type);
    }

    private String getElementIfAvailable(ArrayList<String> contents, int index) {
        if (index < contents.size()) {
            return contents.get(index);
        }
        return "";
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        Iterator<FileListEntry> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            FileListEntry entry = iterator.next();
            sb.append(this.encodeEntry(entry));
            if (!iterator.hasNext()) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public String getToolTipHTMLRepresentation() {
        StringBuilder sb = new StringBuilder("<html>");
        Iterator<FileListEntry> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            FileListEntry entry = iterator.next();
            sb.append(entry.getDescription()).append(" (").append(entry.getLink()).append(')');
            if (!iterator.hasNext()) continue;
            sb.append("<br>");
        }
        return sb.append("</html>").toString();
    }

    private String encodeEntry(FileListEntry entry) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.encodeString(entry.getDescription()));
        sb.append(':');
        sb.append(this.encodeString(entry.getLink()));
        sb.append(':');
        sb.append(this.encodeString(entry.getType() != null ? entry.getType().getName() : ""));
        return sb.toString();
    }

    private String encodeString(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ';' || c == ':' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void print() {
        System.out.println("----");
        for (FileListEntry fileListEntry : this.list) {
            System.out.println(fileListEntry);
        }
        System.out.println("----");
    }
}

