/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.external.DownloadExternalFile;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.gui.AttachFileDialog;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInspectionDialog
extends JDialog
implements ImportInspector {
    protected ImportInspectionDialog ths = this;
    protected BasePanel panel;
    protected JabRefFrame frame;
    protected MetaData metaData;
    protected UIFSplitPane contentPane = new UIFSplitPane(0);
    protected JTable glTable;
    protected TableComparatorChooser<BibtexEntry> comparatorChooser;
    protected EventSelectionModel<BibtexEntry> selectionModel;
    protected String[] fields;
    protected JProgressBar progressBar = new JProgressBar(0);
    protected JButton ok = new JButton(Globals.lang("Ok"));
    protected JButton cancel = new JButton(Globals.lang("Cancel"));
    protected JButton generate = new JButton(Globals.lang("Generate now"));
    protected EventList<BibtexEntry> entries = new BasicEventList<BibtexEntry>();
    protected SortedList<BibtexEntry> sortedList;
    protected List<BibtexEntry> entriesToDelete = new ArrayList<BibtexEntry>();
    protected String undoName;
    protected ArrayList<CallBack> callBacks = new ArrayList();
    protected boolean newDatabase;
    protected JMenu groupsAdd = new JMenu(Globals.lang("Add to group"));
    protected JPopupMenu popup = new JPopupMenu();
    protected JButton selectAll = new JButton(Globals.lang("Select all"));
    protected JButton deselectAll = new JButton(Globals.lang("Deselect all"));
    protected JButton deselectAllDuplicates = new JButton(Globals.lang("Deselect all duplicates"));
    protected JButton stop = new JButton(Globals.lang("Stop"));
    protected JButton delete = new JButton(Globals.lang("Delete"));
    protected JButton help = new JButton(Globals.lang("Help"));
    protected PreviewPanel preview;
    protected boolean generatedKeys = false;
    protected boolean defaultSelected = true;
    protected Rectangle toRect = new Rectangle(0, 0, 1, 1);
    protected Map<BibtexEntry, Set<GroupTreeNode>> groupAdditions = new HashMap<BibtexEntry, Set<GroupTreeNode>>();
    protected JCheckBox autoGenerate = new JCheckBox(Globals.lang("Generate keys"), Globals.prefs.getBoolean("generateKeysAfterInspection"));
    protected JLabel duplLabel = new JLabel(GUIGlobals.getImage("duplicate"));
    protected JLabel fileLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    protected JLabel pdfLabel = new JLabel(GUIGlobals.getImage("pdfSmall"));
    protected JLabel psLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    protected JLabel urlLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
    protected final int DUPL_COL = 1;
    protected final int FILE_COL = 2;
    protected final int PDF_COL = -1;
    protected final int PS_COL = -2;
    protected final int URL_COL = 3;
    protected final int PAD = 4;

    public void setDefaultSelected(boolean defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    public ImportInspectionDialog(JabRefFrame frame, BasePanel panel, String[] fields, String undoName, boolean newDatabase) {
        this.frame = frame;
        this.panel = panel;
        this.metaData = panel != null ? panel.metaData() : new MetaData();
        this.fields = fields;
        this.undoName = undoName;
        this.newDatabase = newDatabase;
        this.preview = new PreviewPanel(null, this.metaData, Globals.prefs.get("preview0"));
        this.duplLabel.setToolTipText(Globals.lang("Possible duplicate of existing entry. Click to resolve."));
        this.sortedList = new SortedList<BibtexEntry>(this.entries);
        EventTableModel<BibtexEntry> tableModelGl = new EventTableModel<BibtexEntry>(this.sortedList, new EntryTableFormat());
        this.glTable = new EntryTable(tableModelGl);
        GeneralRenderer renderer = new GeneralRenderer(Color.white);
        this.glTable.setDefaultRenderer(JLabel.class, renderer);
        this.glTable.setDefaultRenderer(String.class, renderer);
        this.glTable.getInputMap().put(Globals.prefs.getKey("Delete"), "delete");
        DeleteListener deleteListener = new DeleteListener();
        this.glTable.getActionMap().put("delete", deleteListener);
        this.selectionModel = new EventSelectionModel<BibtexEntry>(this.sortedList);
        this.glTable.setSelectionModel(this.selectionModel);
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.comparatorChooser = TableComparatorChooser.install(this.glTable, this.sortedList, TableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser();
        this.glTable.addMouseListener(new TableClickListener());
        this.setWidths();
        this.getContentPane().setLayout(new BorderLayout());
        this.progressBar.setIndeterminate(true);
        JPanel centerPan = new JPanel();
        centerPan.setLayout(new BorderLayout());
        this.contentPane.setTopComponent(new JScrollPane(this.glTable));
        this.contentPane.setBottomComponent(this.preview);
        centerPan.add((Component)this.contentPane, "Center");
        centerPan.add((Component)this.progressBar, "South");
        this.popup.add(deleteListener);
        this.popup.addSeparator();
        if (!newDatabase) {
            GroupTreeNode node = this.metaData.getGroups();
            this.groupsAdd.setEnabled(false);
            this.insertNodes(this.groupsAdd, node);
            this.popup.add(this.groupsAdd);
        }
        this.popup.add(new LinkLocalFile());
        this.popup.add(new DownloadFile());
        this.popup.add(new AutoSetLinks());
        this.popup.add(new AttachUrl());
        this.getContentPane().add((Component)centerPan, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.stop);
        bb.addGridded(this.cancel);
        bb.addRelatedGap();
        bb.addGridded(this.help);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonStackBuilder builder = new ButtonStackBuilder();
        builder.addGridded(this.selectAll);
        builder.addGridded(this.deselectAll);
        builder.addGridded(this.deselectAllDuplicates);
        builder.addRelatedGap();
        builder.addGridded(this.delete);
        builder.addRelatedGap();
        builder.addGridded(this.autoGenerate);
        builder.addGridded(this.generate);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        centerPan.add((Component)builder.getPanel(), "West");
        this.ok.setEnabled(false);
        this.generate.setEnabled(false);
        this.ok.addActionListener(new OkListener());
        this.cancel.addActionListener(new CancelListener());
        this.generate.addActionListener(new GenerateListener());
        this.stop.addActionListener(new StopListener());
        this.selectAll.addActionListener(new SelectionButton(true));
        this.deselectAll.addActionListener(new SelectionButton(false));
        this.deselectAllDuplicates.addActionListener(new DeselectDuplicatesButtonListener());
        this.deselectAllDuplicates.setEnabled(false);
        this.delete.addActionListener(deleteListener);
        this.help.addActionListener(new HelpAction(frame.helpDiag, GUIGlobals.importInspectionHelp));
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.setSize(new Dimension(Globals.prefs.getInt("importInspectionDialogWidth"), Globals.prefs.getInt("importInspectionDialogHeight")));
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
            }

            public void windowClosed(WindowEvent e) {
                Globals.prefs.putInt("importInspectionDialogWidth", ImportInspectionDialog.this.getSize().width);
                Globals.prefs.putInt("importInspectionDialogHeight", ImportInspectionDialog.this.getSize().height);
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ImportInspectionDialog.this.dispose();
            }
        };
        ActionMap am = this.contentPane.getActionMap();
        InputMap im = this.contentPane.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeAction);
    }

    @Override
    public void setProgress(int current, int max) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(max);
        this.progressBar.setValue(current);
    }

    @Override
    public void addEntry(BibtexEntry entry) {
        ArrayList<BibtexEntry> list = new ArrayList<BibtexEntry>();
        list.add(entry);
        this.addEntries(list);
    }

    public void addEntries(Collection<BibtexEntry> entries) {
        for (BibtexEntry entry : entries) {
            entry.setSearchHit(this.defaultSelected);
            if (this.panel != null && DuplicateCheck.containsDuplicate(this.panel.database(), entry) != null || this.internalDuplicate(this.entries, entry) != null) {
                entry.setGroupHit(true);
                this.deselectAllDuplicates.setEnabled(true);
            }
            this.entries.getReadWriteLock().writeLock().lock();
            this.entries.add(entry);
            this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    protected BibtexEntry internalDuplicate(Collection<BibtexEntry> entries, BibtexEntry entry) {
        for (BibtexEntry othEntry : entries) {
            if (othEntry == entry || !DuplicateCheck.isDuplicate(entry, othEntry)) continue;
            return othEntry;
        }
        return null;
    }

    public void removeSelectedEntries() {
        int row = this.glTable.getSelectedRow();
        ArrayList<BibtexEntry> toRemove = new ArrayList<BibtexEntry>();
        toRemove.addAll(this.selectionModel.getSelected());
        this.entries.getReadWriteLock().writeLock().lock();
        for (Object e : toRemove) {
            this.entries.remove(e);
        }
        this.entries.getReadWriteLock().writeLock().unlock();
        this.glTable.clearSelection();
        if (row >= 0 && this.entries.size() > 0) {
            row = Math.min(this.entries.size() - 1, row);
            this.glTable.addRowSelectionInterval(row, row);
        }
    }

    public void entryListComplete() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(false);
        this.ok.setEnabled(true);
        if (!this.generatedKeys) {
            this.generate.setEnabled(true);
        }
        this.stop.setEnabled(false);
        this.glTable.repaint();
        if (this.glTable.getSelectedRowCount() == 0 && this.glTable.getRowCount() > 0) {
            this.glTable.setRowSelectionInterval(0, 0);
        }
    }

    public List<BibtexEntry> getSelectedEntries() {
        ArrayList<BibtexEntry> selected = new ArrayList<BibtexEntry>();
        for (BibtexEntry entry : this.entries) {
            if (!entry.isSearchHit()) continue;
            selected.add(entry);
        }
        return selected;
    }

    public void generateKeySelectedEntry() {
        if (this.selectionModel.getSelected().size() != 1) {
            return;
        }
        BibtexEntry entry = (BibtexEntry)this.selectionModel.getSelected().get(0);
        this.entries.getReadWriteLock().writeLock().lock();
        BibtexDatabase database = null;
        database = this.panel != null ? this.panel.database() : new BibtexDatabase();
        try {
            entry.setId(Util.createNeutralId());
            database.insertEntry(entry);
        }
        catch (KeyCollisionException ex) {
            ex.printStackTrace();
        }
        LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), database, entry);
        database.removeEntry(entry.getId());
        this.entries.getReadWriteLock().writeLock().lock();
        this.glTable.repaint();
    }

    public void generateKeys(boolean addColumn) {
        this.entries.getReadWriteLock().writeLock().lock();
        BibtexDatabase database = null;
        database = this.panel != null ? this.panel.database() : new BibtexDatabase();
        ArrayList<String> keys = new ArrayList<String>(this.entries.size());
        for (BibtexEntry entry : this.entries) {
            try {
                entry.setId(Util.createNeutralId());
                database.insertEntry(entry);
            }
            catch (KeyCollisionException ex) {
                ex.printStackTrace();
            }
            LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), database, entry);
            keys.add(entry.getCiteKey());
        }
        for (BibtexEntry entry : this.entries) {
            database.removeEntry(entry.getId());
        }
        this.entries.getReadWriteLock().writeLock().lock();
        this.glTable.repaint();
    }

    public void insertNodes(JMenu menu, GroupTreeNode node) {
        AbstractAction action = this.getAction(node);
        if (node.getChildCount() == 0) {
            menu.add(action);
            if (action.isEnabled()) {
                menu.setEnabled(true);
            }
            return;
        }
        JMenu submenu = null;
        if (node.getGroup() instanceof AllEntriesGroup) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.insertNodes(menu, (GroupTreeNode)node.getChildAt(i));
            }
        } else {
            submenu = new JMenu("[" + node.getGroup().getName() + "]");
            submenu.setEnabled(action.isEnabled());
            submenu.add(action);
            submenu.add(new JPopupMenu.Separator());
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.insertNodes(submenu, (GroupTreeNode)node.getChildAt(i));
            }
            menu.add(submenu);
            if (submenu.isEnabled()) {
                menu.setEnabled(true);
            }
        }
    }

    protected AbstractAction getAction(GroupTreeNode node) {
        AddToGroupAction action = new AddToGroupAction(node);
        AbstractGroup group = node.getGroup();
        action.setEnabled(group.supportsAdd());
        return action;
    }

    public void addCallBack(CallBack cb) {
        this.callBacks.add(cb);
    }

    protected void signalStopFetching() {
        for (CallBack c : this.callBacks) {
            c.stopFetching();
        }
    }

    protected void setWidths() {
        int i;
        TableColumnModel cm = this.glTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(55);
        cm.getColumn(0).setMinWidth(55);
        cm.getColumn(0).setMaxWidth(55);
        for (i = 1; i < 4; ++i) {
            cm.getColumn(i).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
            cm.getColumn(i).setMinWidth(GUIGlobals.WIDTH_ICON_COL);
            cm.getColumn(i).setMaxWidth(GUIGlobals.WIDTH_ICON_COL);
        }
        for (i = 0; i < this.fields.length; ++i) {
            int width = BibtexFields.getFieldLength(this.fields[i]);
            this.glTable.getColumnModel().getColumn(i + 4).setPreferredWidth(width);
        }
    }

    protected void setupComparatorChooser() {
        int i;
        List<Comparator> comparators = this.comparatorChooser.getComparatorsForColumn(0);
        comparators.clear();
        comparators = this.comparatorChooser.getComparatorsForColumn(1);
        comparators.clear();
        for (i = 2; i < 4; ++i) {
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            if (i == 2) {
                comparators.add(new IconComparator(new String[]{"file"}));
                continue;
            }
            if (i == -1) {
                comparators.add(new IconComparator(new String[]{"pdf"}));
                continue;
            }
            if (i == -2) {
                comparators.add(new IconComparator(new String[]{"ps"}));
                continue;
            }
            if (i != 3) continue;
            comparators.add(new IconComparator(new String[]{"url"}));
        }
        for (i = 4; i < 4 + this.fields.length; ++i) {
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            comparators.add(new FieldComparator(this.fields[i - 4]));
        }
        this.sortedList.getReadWriteLock().writeLock().lock();
        this.comparatorChooser.appendComparator(4, 0, false);
        this.sortedList.getReadWriteLock().writeLock().unlock();
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryTableFormat
    implements TableFormat<BibtexEntry> {
        EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 4 + ImportInspectionDialog.this.fields.length;
        }

        @Override
        public String getColumnName(int i) {
            if (i == 0) {
                return Globals.lang("Keep");
            }
            if (i >= 4) {
                return Util.nCase(ImportInspectionDialog.this.fields[i - 4]);
            }
            return "";
        }

        @Override
        public Object getColumnValue(BibtexEntry entry, int i) {
            if (i == 0) {
                return entry.isSearchHit() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (i < 4) {
                switch (i) {
                    case 1: {
                        return entry.isGroupHit() ? ImportInspectionDialog.this.duplLabel : null;
                    }
                    case 2: {
                        String o = entry.getField("file");
                        if (o != null) {
                            FileListTableModel model = new FileListTableModel();
                            model.setContent(o);
                            ImportInspectionDialog.this.fileLabel.setToolTipText(model.getToolTipHTMLRepresentation());
                            if (model.getRowCount() > 0) {
                                ImportInspectionDialog.this.fileLabel.setIcon(model.getEntry(0).getType().getIcon());
                            }
                            return ImportInspectionDialog.this.fileLabel;
                        }
                        return null;
                    }
                    case -1: {
                        String o = entry.getField("pdf");
                        if (o != null) {
                            ImportInspectionDialog.this.pdfLabel.setToolTipText(o);
                            return ImportInspectionDialog.this.pdfLabel;
                        }
                        return null;
                    }
                    case -2: {
                        String o = entry.getField("ps");
                        if (o != null) {
                            ImportInspectionDialog.this.psLabel.setToolTipText(o);
                            return ImportInspectionDialog.this.psLabel;
                        }
                        return null;
                    }
                    case 3: {
                        String o = entry.getField("url");
                        if (o != null) {
                            ImportInspectionDialog.this.urlLabel.setToolTipText(o);
                            return ImportInspectionDialog.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String field = ImportInspectionDialog.this.fields[i - 4];
            if (field.equals("author") || field.equals("editor")) {
                String contents = entry.getField(field);
                return contents != null ? AuthorList.fixAuthor_Natbib(contents) : "";
            }
            return entry.getField(field);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryTable
    extends JTable {
        GeneralRenderer renderer;

        public EntryTable(TableModel model) {
            super(model);
            this.renderer = new GeneralRenderer(Color.white);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return column == 0 ? this.getDefaultRenderer(Boolean.class) : this.renderer;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            if (col < 4) {
                return JLabel.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(row);
            entry.setSearchHit((Boolean)value);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    class AttachFile
    extends JMenuItem
    implements ActionListener {
        String fileType;

        public AttachFile(String fileType) {
            super(Globals.lang("Attach %0 file", new String[]{fileType.toUpperCase()}));
            this.fileType = fileType;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent event) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            AttachFileDialog diag = new AttachFileDialog((Dialog)ImportInspectionDialog.this, ImportInspectionDialog.this.metaData, entry, this.fileType);
            Util.placeDialog(diag, ImportInspectionDialog.this);
            diag.setVisible(true);
            if (!diag.cancelled()) {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                entry.setField(this.fileType, diag.getValue());
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                ImportInspectionDialog.this.glTable.repaint();
            }
        }
    }

    class LinkLocalFile
    extends JMenuItem
    implements ActionListener,
    DownloadExternalFile.DownloadCallback {
        BibtexEntry entry;

        public LinkLocalFile() {
            super(Globals.lang("Link local file"));
            this.entry = null;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            this.entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            FileListEntry flEntry = new FileListEntry("", "", null);
            FileListEntryEditor editor = new FileListEntryEditor(ImportInspectionDialog.this.frame, flEntry, false, true, ImportInspectionDialog.this.metaData);
            editor.setVisible(true, true);
            if (editor.okPressed()) {
                FileListTableModel model = new FileListTableModel();
                String oldVal = this.entry.getField("file");
                if (oldVal != null) {
                    model.setContent(oldVal);
                }
                model.addEntry(model.getRowCount(), flEntry);
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                this.entry.setField("file", model.getStringRepresentation());
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                ImportInspectionDialog.this.glTable.repaint();
            }
        }

        public void downloadComplete(FileListEntry file) {
            ImportInspectionDialog.this.toFront();
            FileListTableModel model = new FileListTableModel();
            String oldVal = this.entry.getField("file");
            if (oldVal != null) {
                model.setContent(oldVal);
            }
            model.addEntry(model.getRowCount(), file);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            this.entry.setField("file", model.getStringRepresentation());
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class AutoSetLinks
    extends JMenuItem
    implements ActionListener {
        public AutoSetLinks() {
            super(Globals.lang("Autoset external links"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            final BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String bibtexKey = entry.getCiteKey();
            if (bibtexKey == null) {
                int answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this.frame, Globals.lang("This entry has no BibTeX key. Generate key now?"), Globals.lang("Download file"), 2, 3);
                if (answer == 0) {
                    ImportInspectionDialog.this.generateKeySelectedEntry();
                    bibtexKey = entry.getCiteKey();
                } else {
                    return;
                }
            }
            final FileListTableModel model = new FileListTableModel();
            String oldVal = entry.getField("file");
            if (oldVal != null) {
                model.setContent(oldVal);
            }
            JDialog diag = new JDialog((Dialog)ImportInspectionDialog.this, true);
            FileListEditor.autoSetLinks(entry, model, ImportInspectionDialog.this.metaData, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getID() > 0) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        entry.setField("file", model.getStringRepresentation());
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                        ImportInspectionDialog.this.glTable.repaint();
                    }
                }
            }, diag);
        }
    }

    class DownloadFile
    extends JMenuItem
    implements ActionListener,
    DownloadExternalFile.DownloadCallback {
        BibtexEntry entry;

        public DownloadFile() {
            super(Globals.lang("Download file"));
            this.entry = null;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int answer;
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            this.entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String bibtexKey = this.entry.getCiteKey();
            if (bibtexKey == null && (answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this.frame, Globals.lang("This entry has no BibTeX key. Generate key now?"), Globals.lang("Download file"), 2, 3)) == 0) {
                ImportInspectionDialog.this.generateKeySelectedEntry();
                bibtexKey = this.entry.getCiteKey();
            }
            DownloadExternalFile def = new DownloadExternalFile(ImportInspectionDialog.this.frame, ImportInspectionDialog.this.metaData, bibtexKey);
            try {
                def.download(this);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void downloadComplete(FileListEntry file) {
            ImportInspectionDialog.this.toFront();
            FileListTableModel model = new FileListTableModel();
            String oldVal = this.entry.getField("file");
            if (oldVal != null) {
                model.setContent(oldVal);
            }
            model.addEntry(model.getRowCount(), file);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            this.entry.setField("file", model.getStringRepresentation());
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class AttachUrl
    extends JMenuItem
    implements ActionListener {
        public AttachUrl() {
            super(Globals.lang("Attach URL"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent event) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String result = JOptionPane.showInputDialog(ImportInspectionDialog.this, Globals.lang("Enter URL"), entry.getField("url"));
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            if (result != null) {
                if (result.equals("")) {
                    entry.clearField("url");
                } else {
                    entry.setField("url", result);
                }
            }
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class TableClickListener
    implements MouseListener {
        TableClickListener() {
        }

        public boolean isIconColumn(int col) {
            return col == 2 || col == -1 || col == -2 || col == 3;
        }

        public void mouseClicked(MouseEvent e) {
            int col = ImportInspectionDialog.this.glTable.columnAtPoint(e.getPoint());
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            if (this.isIconColumn(col)) {
                BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(row);
                switch (col) {
                    case 2: {
                        String o = entry.getField("file");
                        if (o == null) break;
                        FileListTableModel tableModel = new FileListTableModel();
                        tableModel.setContent(o);
                        if (tableModel.getRowCount() == 0) {
                            return;
                        }
                        FileListEntry fl = tableModel.getEntry(0);
                        new ExternalFileMenuItem(ImportInspectionDialog.this.frame, entry, "", fl.getLink(), null, ImportInspectionDialog.this.panel.metaData(), fl.getType()).actionPerformed(null);
                        break;
                    }
                    case 3: {
                        this.openExternalLink("url", e);
                        break;
                    }
                    case -1: {
                        this.openExternalLink("pdf", e);
                        break;
                    }
                    case -2: {
                        this.openExternalLink("ps", e);
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void showPopup(MouseEvent e) {
            int col = ImportInspectionDialog.this.glTable.columnAtPoint(e.getPoint());
            switch (col) {
                case 2: {
                    this.showFileFieldMenu(e);
                    break;
                }
                default: {
                    this.showOrdinaryRightClickMenu(e);
                }
            }
        }

        public void showOrdinaryRightClickMenu(MouseEvent e) {
            ImportInspectionDialog.this.popup.show(ImportInspectionDialog.this.glTable, e.getX(), e.getY());
        }

        public void showFileFieldMenu(MouseEvent e) {
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(row);
            JPopupMenu menu = new JPopupMenu();
            int count = 0;
            String o = entry.getField("file");
            FileListTableModel fileList = new FileListTableModel();
            fileList.setContent(o);
            for (int i = 0; i < fileList.getRowCount(); ++i) {
                FileListEntry flEntry = fileList.getEntry(i);
                String description = flEntry.getDescription();
                if (description == null || description.trim().length() == 0) {
                    description = flEntry.getLink();
                }
                menu.add(new ExternalFileMenuItem(ImportInspectionDialog.this.panel.frame(), entry, description, flEntry.getLink(), (Icon)flEntry.getType().getIcon(), ImportInspectionDialog.this.panel.metaData(), flEntry.getType()));
                ++count;
            }
            if (count == 0) {
                this.showOrdinaryRightClickMenu(e);
            } else {
                menu.show(ImportInspectionDialog.this.glTable, e.getX(), e.getY());
            }
        }

        public void openExternalLink(String fieldName, MouseEvent e) {
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            BibtexEntry entry = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(row);
            String link = entry.getField(fieldName);
            try {
                if (link != null) {
                    Util.openExternalViewer(ImportInspectionDialog.this.panel.metaData(), link, fieldName);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            int col = ImportInspectionDialog.this.glTable.columnAtPoint(e.getPoint());
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            if (col == 1 && ImportInspectionDialog.this.glTable.getValueAt(row, col) != null) {
                BibtexEntry first = (BibtexEntry)ImportInspectionDialog.this.sortedList.get(row);
                BibtexEntry other = DuplicateCheck.containsDuplicate(ImportInspectionDialog.this.panel.database(), first);
                if (other != null) {
                    DuplicateResolverDialog diag = new DuplicateResolverDialog(ImportInspectionDialog.this, other, first, 3);
                    Util.placeDialog(diag, ImportInspectionDialog.this);
                    diag.setVisible(true);
                    ImportInspectionDialog.this.toFront();
                    if (diag.getSelected() == 1) {
                        ImportInspectionDialog.this.entriesToDelete.add(other);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        first.setGroupHit(false);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    } else if (diag.getSelected() == 2) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        ImportInspectionDialog.this.entries.remove(first);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    } else if (diag.getSelected() == 0) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        first.setGroupHit(false);
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    }
                }
                if ((other = ImportInspectionDialog.this.internalDuplicate(ImportInspectionDialog.this.entries, first)) != null) {
                    int answer = DuplicateResolverDialog.resolveDuplicate(ImportInspectionDialog.this, first, other);
                    if (answer == 1) {
                        ImportInspectionDialog.this.entries.remove(other);
                        first.setGroupHit(false);
                    } else if (answer == 2) {
                        ImportInspectionDialog.this.entries.remove(first);
                    } else if (answer == 0) {
                        first.setGroupHit(false);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySelectionListener
    implements ListEventListener<BibtexEntry> {
        EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<BibtexEntry> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                ImportInspectionDialog.this.preview.setEntry((BibtexEntry)listEvent.getSourceList().get(0));
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportInspectionDialog.this.preview.scrollRectToVisible(ImportInspectionDialog.this.toRect);
                    }
                });
            }
        }
    }

    class DeselectDuplicatesButtonListener
    implements ActionListener {
        DeselectDuplicatesButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                if (ImportInspectionDialog.this.glTable.getValueAt(i, 1) == null) continue;
                ImportInspectionDialog.this.glTable.setValueAt(false, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class SelectionButton
    implements ActionListener {
        protected Boolean enable;

        public SelectionButton(boolean enable) {
            this.enable = enable;
        }

        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                ImportInspectionDialog.this.glTable.setValueAt(this.enable, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int i) {
            if (i == 0) {
                return Boolean.class;
            }
            return String.class;
        }
    }

    class MyTable
    extends JTable {
        public MyTable(TableModel model) {
            super(model);
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    class DeleteListener
    extends AbstractAction
    implements ActionListener {
        public DeleteListener() {
            super(Globals.lang("Delete"), GUIGlobals.getImage("delete"));
        }

        public void actionPerformed(ActionEvent event) {
            ImportInspectionDialog.this.removeSelectedEntries();
        }
    }

    class GenerateListener
    implements ActionListener {
        GenerateListener() {
        }

        public void actionPerformed(ActionEvent event) {
            ImportInspectionDialog.this.generate.setEnabled(false);
            ImportInspectionDialog.this.generatedKeys = true;
            ImportInspectionDialog.this.generateKeys(true);
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        public void actionPerformed(ActionEvent event) {
            ImportInspectionDialog.this.signalStopFetching();
            ImportInspectionDialog.this.dispose();
            ImportInspectionDialog.this.frame.output(Globals.lang("Import canceled by user"));
        }
    }

    class StopListener
    implements ActionListener {
        StopListener() {
        }

        public void actionPerformed(ActionEvent event) {
            ImportInspectionDialog.this.signalStopFetching();
            ImportInspectionDialog.this.entryListComplete();
        }
    }

    class OkListener
    implements ActionListener {
        OkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (Globals.prefs.getBoolean("warnAboutDuplicatesInInspection")) {
                for (BibtexEntry entry : ImportInspectionDialog.this.entries) {
                    if (!entry.isSearchHit() || !entry.isGroupHit()) continue;
                    CheckBoxMessage cbm = new CheckBoxMessage(Globals.lang("There are possible duplicates (marked with a 'D' icon) that haven't been resolved. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
                    int answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, cbm, Globals.lang("Duplicates found"), 0);
                    if (cbm.isSelected()) {
                        Globals.prefs.putBoolean("warnAboutDuplicatesInInspection", false);
                    }
                    if (answer != 1) break;
                    return;
                }
            }
            NamedCompound ce = new NamedCompound(ImportInspectionDialog.this.undoName);
            if (ImportInspectionDialog.this.entriesToDelete.size() > 0) {
                for (BibtexEntry entry : ImportInspectionDialog.this.entriesToDelete) {
                    ce.addEdit(new UndoableRemoveEntry(ImportInspectionDialog.this.panel.database(), entry, ImportInspectionDialog.this.panel));
                    ImportInspectionDialog.this.panel.database().removeEntry(entry.getId());
                }
            }
            if (ImportInspectionDialog.this.autoGenerate.isSelected() && !ImportInspectionDialog.this.generatedKeys) {
                ImportInspectionDialog.this.generateKeys(false);
            }
            Globals.prefs.putBoolean("generateKeysAfterInspection", ImportInspectionDialog.this.autoGenerate.isSelected());
            final List<BibtexEntry> selected = ImportInspectionDialog.this.getSelectedEntries();
            if (selected.size() > 0) {
                if (ImportInspectionDialog.this.newDatabase) {
                    BibtexDatabase base = new BibtexDatabase();
                    ImportInspectionDialog.this.panel = new BasePanel(ImportInspectionDialog.this.frame, base, null, new HashMap<String, String>(), Globals.prefs.get("defaultEncoding"));
                }
                boolean groupingCanceled = false;
                Util.setAutomaticFields(selected, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"), Globals.prefs.getBoolean("markImportedEntries"));
                if (Globals.prefs.getBoolean("unmarkAllEntriesBeforeImporting")) {
                    for (BibtexEntry entry : ImportInspectionDialog.this.panel.database().getEntries()) {
                        Util.unmarkEntry(entry, true, ImportInspectionDialog.this.panel.database(), ce);
                    }
                }
                for (BibtexEntry entry : selected) {
                    entry.setSearchHit(false);
                    entry.setGroupHit(false);
                    Set<GroupTreeNode> groups = ImportInspectionDialog.this.groupAdditions.get(entry);
                    if (!groupingCanceled && groups != null) {
                        if (entry.getField("bibtexkey") == null) {
                            int answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, Globals.lang("Cannot add entries to group without generating keys. Generate keys now?"), Globals.lang("Add to group"), 0);
                            if (answer == 0) {
                                ImportInspectionDialog.this.generateKeys(false);
                            } else {
                                groupingCanceled = true;
                            }
                        }
                        if (entry.getField("bibtexkey") != null) {
                            for (GroupTreeNode node : groups) {
                                if (!node.getGroup().supportsAdd()) continue;
                                AbstractUndoableEdit undo = node.getGroup().add(new BibtexEntry[]{entry});
                                if (undo instanceof UndoableChangeAssignment) {
                                    ((UndoableChangeAssignment)undo).setEditedNode(node);
                                }
                                ce.addEdit(undo);
                            }
                        }
                    }
                    try {
                        entry.setId(Util.createNeutralId());
                        ImportInspectionDialog.this.panel.database().insertEntry(entry);
                        Util.updateCompletersForEntry(ImportInspectionDialog.this.panel.getAutoCompleters(), entry);
                        ce.addEdit(new UndoableInsertEntry(ImportInspectionDialog.this.panel.database(), entry, ImportInspectionDialog.this.panel));
                    }
                    catch (KeyCollisionException e) {
                        e.printStackTrace();
                    }
                }
                ce.end();
                ImportInspectionDialog.this.panel.undoManager.addEdit(ce);
            }
            ImportInspectionDialog.this.dispose();
            SwingUtilities.invokeLater(new Thread(){

                public void run() {
                    if (ImportInspectionDialog.this.newDatabase) {
                        ImportInspectionDialog.this.frame.addTab(ImportInspectionDialog.this.panel, null, true);
                    }
                    ImportInspectionDialog.this.panel.markBaseChanged();
                    if (selected.size() > 0) {
                        ImportInspectionDialog.this.frame.output(Globals.lang("Number of entries successfully imported") + ": " + selected.size());
                    } else {
                        ImportInspectionDialog.this.frame.output(Globals.lang("No entries imported."));
                    }
                }
            });
        }
    }

    class AddToGroupAction
    extends AbstractAction {
        protected GroupTreeNode node;

        public AddToGroupAction(GroupTreeNode node) {
            super(node.getGroup().getName());
            this.node = node;
        }

        public void actionPerformed(ActionEvent event) {
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().lock();
            for (BibtexEntry entry : ImportInspectionDialog.this.selectionModel.getSelected()) {
                Set<GroupTreeNode> groups = ImportInspectionDialog.this.groupAdditions.get(entry);
                if (groups == null) {
                    groups = new HashSet<GroupTreeNode>();
                    ImportInspectionDialog.this.groupAdditions.put(entry, groups);
                }
                groups.add(this.node);
            }
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().unlock();
        }
    }

    public static interface CallBack {
        public void stopFetching();
    }
}

