/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class WaitForSaveOperation
implements ActionListener {
    JabRefFrame frame;
    JDialog diag;
    JProgressBar prog;
    JButton cancel;
    Timer t = new Timer(500, this);
    boolean cancelled = false;

    public WaitForSaveOperation(JabRefFrame frame) {
        this.frame = frame;
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.prog = new JProgressBar(0);
        this.prog.setIndeterminate(true);
        this.prog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag = new JDialog(frame, Globals.lang("Please wait"), true);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.cancel);
        bb.addGlue();
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaitForSaveOperation.this.cancelled = true;
                WaitForSaveOperation.this.t.stop();
                WaitForSaveOperation.this.diag.dispose();
            }
        });
        JLabel message = new JLabel(Globals.lang("Waiting for save operation to finish") + "...");
        message.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)message, "North");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.getContentPane().add((Component)this.prog, "Center");
        this.diag.pack();
    }

    public void show() {
        this.diag.setLocationRelativeTo(this.frame);
        this.t.start();
        this.diag.setVisible(true);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean anySaving = false;
        for (int i = 0; i < this.frame.baseCount(); ++i) {
            if (!this.frame.baseAt(i).isSaving()) continue;
            anySaving = true;
            break;
        }
        if (!anySaving) {
            this.t.stop();
            this.diag.dispose();
        }
    }
}

