/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.OutputPrinterToNull;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BiblioscapeImporter;
import net.sf.jabref.imports.BibteXMLImporter;
import net.sf.jabref.imports.BiomailImporter;
import net.sf.jabref.imports.CopacImporter;
import net.sf.jabref.imports.CsaImporter;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.EndnoteImporter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.InspecImporter;
import net.sf.jabref.imports.IsiImporter;
import net.sf.jabref.imports.JstorImporter;
import net.sf.jabref.imports.MsBibImporter;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.OvidImporter;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PdfXmpImporter;
import net.sf.jabref.imports.RepecNepImporter;
import net.sf.jabref.imports.RisImporter;
import net.sf.jabref.imports.ScifinderImporter;
import net.sf.jabref.imports.SilverPlatterImporter;
import net.sf.jabref.imports.SixpackImporter;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import net.sf.jabref.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFormatReader {
    public static String BIBTEX_FORMAT = "BibTeX";
    private SortedSet<ImportFormat> formats = new TreeSet<ImportFormat>();

    public void resetImportFormats() {
        this.formats.clear();
        this.formats.add(new CsaImporter());
        this.formats.add(new IsiImporter());
        this.formats.add(new EndnoteImporter());
        this.formats.add(new BibteXMLImporter());
        this.formats.add(new BiblioscapeImporter());
        this.formats.add(new SixpackImporter());
        this.formats.add(new InspecImporter());
        this.formats.add(new ScifinderImporter());
        this.formats.add(new OvidImporter());
        this.formats.add(new RisImporter());
        this.formats.add(new JstorImporter());
        this.formats.add(new SilverPlatterImporter());
        this.formats.add(new BiomailImporter());
        this.formats.add(new RepecNepImporter());
        this.formats.add(new PdfXmpImporter());
        this.formats.add(new CopacImporter());
        this.formats.add(new MsBibImporter());
        JabRefPlugin jabrefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (jabrefPlugin != null) {
            for (_JabRefPlugin.ImportFormatExtension ext : jabrefPlugin.getImportFormatExtensions()) {
                ImportFormat importFormat = ext.getImportFormat();
                if (importFormat == null) continue;
                this.formats.add(importFormat);
            }
        }
        for (CustomImportList.Importer importer : Globals.prefs.customImports) {
            try {
                ImportFormat imFo = importer.getInstance();
                this.formats.add(imFo);
            }
            catch (Exception e) {
                System.err.println("Could not instantiate " + importer.getName() + " importer, will ignore it. Please check if the class is still available.");
                e.printStackTrace();
            }
        }
    }

    public ImportFormat getByCliId(String cliId) {
        for (ImportFormat format : this.formats) {
            if (!format.getCLIId().equals(cliId)) continue;
            return format;
        }
        return null;
    }

    public List<BibtexEntry> importFromStream(String format, InputStream in, OutputPrinter status) throws IOException {
        ImportFormat importer = this.getByCliId(format);
        if (importer == null) {
            throw new IllegalArgumentException("Unknown import format: " + format);
        }
        List<BibtexEntry> res = importer.importEntries(in, status);
        if (res != null) {
            ImportFormatReader.purgeEmptyEntries(res);
        }
        return res;
    }

    public List<BibtexEntry> importFromFile(String format, String filename, OutputPrinter status) throws IOException {
        ImportFormat importer = this.getByCliId(format);
        if (importer == null) {
            throw new IllegalArgumentException("Unknown import format: " + format);
        }
        return this.importFromFile(importer, filename, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BibtexEntry> importFromFile(ImportFormat importer, String filename, OutputPrinter status) throws IOException {
        List<BibtexEntry> result = null;
        InputStream stream = null;
        try {
            File file = new File(filename);
            stream = new FileInputStream(file);
            if (!importer.isRecognizedFormat(stream)) {
                throw new IOException(Globals.lang("Wrong file format"));
            }
            stream = new FileInputStream(file);
            result = importer.importEntries(stream, status);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return result;
    }

    public static BibtexDatabase createDatabase(Collection<BibtexEntry> bibentries) {
        ImportFormatReader.purgeEmptyEntries(bibentries);
        BibtexDatabase database = new BibtexDatabase();
        for (BibtexEntry entry : bibentries) {
            try {
                entry.setId(Util.createNeutralId());
                database.insertEntry(entry);
            }
            catch (KeyCollisionException ex) {
                System.err.println("KeyCollisionException [ addBibEntries(...) ]");
            }
        }
        return database;
    }

    public SortedSet<ImportFormat> getCustomImportFormats() {
        TreeSet<ImportFormat> result = new TreeSet<ImportFormat>();
        for (ImportFormat format : this.formats) {
            if (!format.getIsCustomImporter()) continue;
            result.add(format);
        }
        return result;
    }

    public SortedSet<ImportFormat> getBuiltInInputFormats() {
        TreeSet<ImportFormat> result = new TreeSet<ImportFormat>();
        for (ImportFormat format : this.formats) {
            if (format.getIsCustomImporter()) continue;
            result.add(format);
        }
        return result;
    }

    public SortedSet<ImportFormat> getImportFormats() {
        return this.formats;
    }

    public String getImportFormatList() {
        StringBuffer sb = new StringBuffer();
        for (ImportFormat imFo : this.formats) {
            int pad = Math.max(0, 14 - imFo.getFormatName().length());
            sb.append("  ");
            sb.append(imFo.getFormatName());
            for (int j = 0; j < pad; ++j) {
                sb.append(" ");
            }
            sb.append(" : ");
            sb.append(imFo.getCLIId());
            sb.append("\n");
        }
        String res = sb.toString();
        return res;
    }

    public static String expandAuthorInitials(String name) {
        String[] authors = name.split(" and ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < authors.length; ++i) {
            int j;
            String[] names;
            if (authors[i].indexOf(", ") >= 0) {
                names = authors[i].split(", ");
                if (names.length > 0) {
                    sb.append(names[0]);
                    if (names.length > 1) {
                        sb.append(", ");
                    }
                }
                for (j = 1; j < names.length; ++j) {
                    if (j == 1) {
                        sb.append(ImportFormatReader.expandAll(names[j]));
                    } else {
                        sb.append(names[j]);
                    }
                    if (j >= names.length - 1) continue;
                    sb.append(", ");
                }
            } else {
                names = authors[i].split(" ");
                if (names.length > 0) {
                    sb.append(ImportFormatReader.expandAll(names[0]));
                }
                for (j = 1; j < names.length; ++j) {
                    sb.append(" ");
                    sb.append(names[j]);
                }
            }
            if (i >= authors.length - 1) continue;
            sb.append(" and ");
        }
        return sb.toString().trim();
    }

    public static String expandAll(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1 && Character.isLetter(s.charAt(0)) && Character.isUpperCase(s.charAt(0))) {
            return s + ".";
        }
        StringBuffer sb = new StringBuffer();
        char c = s.charAt(0);
        char d = '\u0000';
        for (int i = 1; i < s.length(); ++i) {
            d = s.charAt(i);
            if (Character.isLetter(c) && Character.isUpperCase(c) && Character.isLetter(d) && Character.isUpperCase(d)) {
                sb.append(c);
                sb.append(". ");
            } else {
                sb.append(c);
            }
            c = d;
        }
        if (Character.isLetter(c) && Character.isUpperCase(c) && Character.isLetter(d) && Character.isUpperCase(d)) {
            sb.append(c);
            sb.append(". ");
        } else {
            sb.append(c);
        }
        return sb.toString().trim();
    }

    static File checkAndCreateFile(String filename) {
        File f = new File(filename);
        if (!(f.exists() || f.canRead() || f.isFile())) {
            System.err.println("Error " + filename + " is not a valid file and|or is not readable.");
            Globals.logger("Error " + filename + " is not a valid file and|or is not readable.");
            return null;
        }
        return f;
    }

    public static void setIfNecessary(BibtexEntry be, String field, String content) {
        if (!content.equals("")) {
            be.setField(field, content);
        }
    }

    public static Reader getReader(File f, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), encoding);
        return reader;
    }

    public static Reader getReaderDefaultEncoding(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, Globals.prefs.get("defaultEncoding"));
        return reader;
    }

    public static void purgeEmptyEntries(Collection<BibtexEntry> entries) {
        Iterator<BibtexEntry> i = entries.iterator();
        while (i.hasNext()) {
            BibtexEntry entry = i.next();
            if (entry.getAllFields().size() != 0) continue;
            i.remove();
        }
    }

    public Pair<String, ParserResult> importUnknownFormat(String filename) {
        Pair<String, ParserResult> result = null;
        OutputPrinterToNull nullOutput = new OutputPrinterToNull();
        int bestResult = 0;
        for (ImportFormat imFo : this.getImportFormats()) {
            try {
                int entryCount;
                List<BibtexEntry> entries = this.importFromFile(imFo, filename, (OutputPrinter)nullOutput);
                if (entries != null) {
                    ImportFormatReader.purgeEmptyEntries(entries);
                }
                if ((entryCount = entries != null ? entries.size() : 0) <= bestResult) continue;
                bestResult = entryCount;
                result = new Pair<String, ParserResult>(imFo.getFormatName(), new ParserResult(entries));
            }
            catch (IOException ex) {}
        }
        if (result != null) {
            return result;
        }
        try {
            ParserResult pr = OpenDatabaseAction.loadDatabase(new File(filename), Globals.prefs.get("defaultEncoding"));
            if (pr.getDatabase().getEntryCount() > 0 || pr.getDatabase().getStringCount() > 0) {
                pr.setFile(new File(filename));
                return new Pair<String, ParserResult>(BIBTEX_FORMAT, pr);
            }
        }
        finally {
            return null;
        }
        {
        }
    }
}

