/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMenuItem
extends JMenuItem
implements ActionListener {
    JabRefFrame frame;
    boolean openInNew;
    MyWorker worker = null;
    ImportFormat importer;
    IOException importError = null;

    public ImportMenuItem(JabRefFrame frame, boolean openInNew) {
        this(frame, openInNew, null);
    }

    public ImportMenuItem(JabRefFrame frame, boolean openInNew, ImportFormat importer) {
        super(importer != null ? importer.getFormatName() : Globals.lang("Autodetect format"));
        this.importer = importer;
        this.frame = frame;
        this.openInNew = openInNew;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.worker = new MyWorker();
        this.worker.init();
        this.worker.getWorker().run();
        this.worker.getCallBack().update();
    }

    public void automatedImport(String[] filenames) {
        MyWorker worker = new MyWorker();
        worker.fileOk = true;
        worker.filenames = filenames;
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    public ParserResult mergeImportResults(List<Pair<String, ParserResult>> imports) {
        BibtexDatabase database = new BibtexDatabase();
        ParserResult directParserResult = null;
        boolean anythingUseful = false;
        for (Pair<String, ParserResult> importResult : imports) {
            ParserResult pr;
            if (importResult == null) continue;
            if (((String)importResult.p).equals(ImportFormatReader.BIBTEX_FORMAT)) {
                pr = (ParserResult)importResult.v;
                boolean bl = anythingUseful = anythingUseful || pr.getDatabase().getEntryCount() > 0 || pr.getDatabase().getStringCount() > 0;
                if (directParserResult == null) {
                    directParserResult = pr;
                }
                for (BibtexEntry entry : pr.getDatabase().getEntries()) {
                    database.insertEntry(entry);
                }
                for (BibtexString bs : pr.getDatabase().getStringValues()) {
                    try {
                        database.addString((BibtexString)bs.clone());
                    }
                    catch (KeyCollisionException e) {}
                }
                continue;
            }
            pr = (ParserResult)importResult.v;
            Collection<BibtexEntry> entries = pr.getDatabase().getEntries();
            anythingUseful |= entries.size() > 0;
            Util.setAutomaticFields(entries, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"), !this.openInNew && Globals.prefs.getBoolean("markImportedEntries"));
            for (BibtexEntry entry : entries) {
                database.insertEntry(entry);
            }
        }
        if (!anythingUseful) {
            return null;
        }
        if (imports.size() == 1 && directParserResult != null) {
            return directParserResult;
        }
        ParserResult pr = new ParserResult(database, new HashMap<String, String>(), new HashMap<String, BibtexEntryType>());
        return pr;
    }

    class MyWorker
    extends AbstractWorker {
        String[] filenames = null;
        String[] formatName = null;
        ParserResult bibtexResult = null;
        boolean fileOk = false;

        MyWorker() {
        }

        public void init() {
            ImportMenuItem.this.importError = null;
            this.filenames = FileDialogs.getMultipleFiles(ImportMenuItem.this.frame, new File(Globals.prefs.get("workingDirectory")), ImportMenuItem.this.importer != null ? ImportMenuItem.this.importer.getExtensions() : null, true);
            if (this.filenames != null && this.filenames.length > 0) {
                ImportMenuItem.this.frame.block();
                ImportMenuItem.this.frame.output(Globals.lang("Starting import"));
                this.fileOk = true;
                Globals.prefs.put("workingDirectory", this.filenames[0]);
            }
        }

        public void run() {
            if (!this.fileOk) {
                return;
            }
            ArrayList<Pair<String, ParserResult>> imports = new ArrayList<Pair<String, ParserResult>>();
            for (String filename : this.filenames) {
                try {
                    if (ImportMenuItem.this.importer != null) {
                        ParserResult pr = new ParserResult(Globals.importFormatReader.importFromFile(ImportMenuItem.this.importer, filename, (OutputPrinter)ImportMenuItem.this.frame));
                        imports.add(new Pair<String, ParserResult>(ImportMenuItem.this.importer.getFormatName(), pr));
                        continue;
                    }
                    ImportMenuItem.this.frame.output(Globals.lang("Importing in unknown format") + "...");
                    imports.add(Globals.importFormatReader.importUnknownFormat(filename));
                }
                catch (IOException e) {
                    ImportMenuItem.this.importError = e;
                }
            }
            this.bibtexResult = ImportMenuItem.this.mergeImportResults(imports);
            for (Pair pair : imports) {
                ParserResult pr;
                if (pair == null || !(pr = (ParserResult)pair.v).hasWarnings() || !Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") || !pr.hasWarnings()) continue;
                String[] wrns = pr.warnings();
                StringBuffer wrn = new StringBuffer();
                for (int j = 0; j < wrns.length; ++j) {
                    wrn.append(j + 1).append(". ").append(wrns[j]).append("\n");
                }
                if (wrn.length() > 0) {
                    wrn.deleteCharAt(wrn.length() - 1);
                }
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, wrn.toString(), Globals.lang("Warnings"), 2);
            }
        }

        public void update() {
            if (!this.fileOk) {
                return;
            }
            if (this.bibtexResult != null) {
                if (!ImportMenuItem.this.openInNew) {
                    BasePanel panel = (BasePanel)ImportMenuItem.this.frame.getTabbedPane().getSelectedComponent();
                    BibtexDatabase toAddTo = panel.database();
                    if (Globals.prefs.getBoolean("useImportInspectionDialog") && (Globals.prefs.getBoolean("useImportInspectionDialogForSingle") || this.bibtexResult.getDatabase().getEntryCount() > 1)) {
                        ImportInspectionDialog diag = new ImportInspectionDialog(ImportMenuItem.this.frame, panel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Import"), ImportMenuItem.this.openInNew);
                        diag.addEntries(this.bibtexResult.getDatabase().getEntries());
                        diag.entryListComplete();
                        Util.placeDialog(diag, ImportMenuItem.this.frame);
                        diag.setVisible(true);
                        diag.toFront();
                    } else {
                        boolean generateKeys = Globals.prefs.getBoolean("generateKeysAfterInspection");
                        NamedCompound ce = new NamedCompound(Globals.lang("Import entries"));
                        if (Globals.prefs.getBoolean("unmarkAllEntriesBeforeImporting")) {
                            for (BibtexEntry entry : toAddTo.getEntries()) {
                                Util.unmarkEntry(entry, true, toAddTo, ce);
                            }
                        }
                        for (BibtexEntry entry : this.bibtexResult.getDatabase().getEntries()) {
                            try {
                                boolean keepEntry = true;
                                BibtexEntry duplicate = DuplicateCheck.containsDuplicate(toAddTo, entry);
                                if (duplicate != null) {
                                    int answer = DuplicateResolverDialog.resolveDuplicateInImport(ImportMenuItem.this.frame, duplicate, entry);
                                    if (answer == 2) {
                                        keepEntry = false;
                                    }
                                    if (answer == 1) {
                                        toAddTo.removeEntry(duplicate.getId());
                                        ce.addEdit(new UndoableRemoveEntry(toAddTo, duplicate, panel));
                                    }
                                }
                                if (!keepEntry) continue;
                                toAddTo.insertEntry(entry);
                                if (generateKeys) {
                                    LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), toAddTo, entry);
                                }
                                Util.updateCompletersForEntry(panel.getAutoCompleters(), entry);
                                ce.addEdit(new UndoableInsertEntry(toAddTo, entry, panel));
                            }
                            catch (KeyCollisionException e) {
                                e.printStackTrace();
                            }
                        }
                        ce.end();
                        if (ce.hasEdits()) {
                            panel.undoManager.addEdit(ce);
                            panel.markBaseChanged();
                        }
                    }
                } else {
                    ImportMenuItem.this.frame.addTab(this.bibtexResult.getDatabase(), this.bibtexResult.getFile(), this.bibtexResult.getMetaData(), Globals.prefs.get("defaultEncoding"), true);
                    ImportMenuItem.this.frame.output(Globals.lang("Imported entries") + ": " + this.bibtexResult.getDatabase().getEntryCount());
                }
            } else if (ImportMenuItem.this.importer == null) {
                ImportMenuItem.this.frame.output(Globals.lang("Could not find a suitable import format."));
            } else if (ImportMenuItem.this.importError != null) {
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, ImportMenuItem.this.importError.getMessage(), Globals.lang("Import failed"), 0);
            } else {
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, Globals.lang("No entries found. Please make sure you are using the correct import filter."), Globals.lang("Import failed"), 0);
            }
            ImportMenuItem.this.frame.unblock();
        }
    }
}

