/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Point;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XReferenceMarksSupplier;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.oo.AlphanumericComparator;
import net.sf.jabref.oo.BibtexEntryNotFoundException;
import net.sf.jabref.oo.ComparableMark;
import net.sf.jabref.oo.ConnectionLostException;
import net.sf.jabref.oo.OOBibStyle;
import net.sf.jabref.oo.OOUtil;
import net.sf.jabref.oo.UndefinedBibtexEntry;
import net.sf.jabref.oo.UndefinedCharacterFormatException;
import net.sf.jabref.oo.UndefinedParagraphFormatException;
import net.sf.jabref.oo.YearComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOBibBase {
    static final String BIB_SECTION_NAME = "JR_bib";
    static final String BIB_SECTION_END_NAME = "JR_bib_end";
    static final String BIB_CITATION = "JR_cite";
    public final Pattern citePattern = Pattern.compile("JR_cite\\d*_(\\d*)_(.*)");
    static final int AUTHORYEAR_PAR = 1;
    static final int AUTHORYEAR_INTEXT = 2;
    static final int INVISIBLE_CIT = 3;
    static final String DEFAULT_CONNECTION_STRING = "uno:socket,host=localhost,port=2002;urp;StarOffice.ServiceManager";
    final String[] BIB_TYPES = new String[]{"ARTICLE", "BOOK", "BOOKLET", "CONFERENCE", "INBOOK", "INCOLLECTION", "INPROCEEDINGS", "JOURNAL", "MANUAL", "MASTERTHESIS", "MISC", "PHDTHESIS", "PROCEEDINGS", "TECHREPORT", "UNPUBLISHED", "EMAIL", "WWW", "CUSTOM1", "CUSTOM2", "CUSTOM3", "CUSTOM4", "CUSTOM5"};
    private XMultiServiceFactory mxDocFactory = null;
    private XTextDocument mxDoc = null;
    private XText text = null;
    private XDesktop xDesktop = null;
    XTextViewCursorSupplier xViewCursorSupplier = null;
    XComponent xCurrentComponent = null;
    XComponentLoader xComponentLoader = null;
    XPropertyContainer userProperties = null;
    XPropertySet propertySet = null;
    private boolean atEnd;
    private AlphanumericComparator entryComparator = new AlphanumericComparator();
    private YearComparator yearComparator = new YearComparator();
    private HashMap<String, String> uniquefiers = new HashMap();
    private String[] sortedReferenceMarks = null;

    public OOBibBase(String pathToOO, boolean atEnd) throws Exception {
        this.atEnd = atEnd;
        this.xDesktop = this.simpleBootstrap(pathToOO);
        this.selectDocument();
    }

    public boolean isConnectedToDocument() {
        return this.xCurrentComponent != null;
    }

    public String getCurrentDocumentTitle() {
        if (this.mxDoc != null) {
            try {
                return String.valueOf(OOUtil.getProperty(this.mxDoc.getCurrentController().getFrame(), "Title"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void selectDocument() throws Exception {
        List<XTextDocument> ls = this.getTextDocuments();
        XTextDocument selected = null;
        if (ls.size() == 0) {
            throw new Exception("No Writer documents found");
        }
        selected = ls.size() > 1 ? OOUtil.selectComponent(null, this.xDesktop, ls) : ls.get(0);
        if (selected == null) {
            return;
        }
        this.xCurrentComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)selected);
        this.mxDoc = selected;
        XDocumentIndexesSupplier indexesSupp = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.xCurrentComponent);
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xCurrentComponent);
        XController xController = xModel.getCurrentController();
        this.xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
        this.text = this.mxDoc.getText();
        this.mxDocFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.mxDoc);
        XDocumentPropertiesSupplier supp = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.mxDoc);
        this.userProperties = supp.getDocumentProperties().getUserDefinedProperties();
        this.propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.userProperties);
    }

    public XDesktop simpleBootstrap(String pathToExecutable) throws Exception {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)loader;
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            try {
                Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)cl, new File(pathToExecutable).toURI().toURL());
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException("Error, could not add URL to system classloader");
            }
        } else {
            System.out.println("Error occured, URLClassLoader expected but " + loader.getClass() + " received. Could not continue.");
        }
        XComponentContext xContext = Bootstrap.bootstrap();
        XMultiComponentFactory xServiceManager = xContext.getServiceManager();
        Object desktop = xServiceManager.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
        XDesktop xD = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
        this.xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)desktop);
        return xD;
    }

    public List<XTextDocument> getTextDocuments() throws Exception {
        ArrayList<XTextDocument> res = new ArrayList<XTextDocument>();
        XEnumerationAccess enumA = this.xDesktop.getComponents();
        XEnumeration e = enumA.createEnumeration();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            XComponent comp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)o);
            XTextDocument doc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)comp);
            if (doc == null) continue;
            res.add(doc);
        }
        return res;
    }

    public void testCustomProperties() throws Exception {
        XDocumentPropertiesSupplier supp = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.mxDoc);
        XPropertyContainer cont = supp.getDocumentProperties().getUserDefinedProperties();
        XPropertySet set = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cont);
        try {
            cont.addProperty("JR_cite_1_Danielsen1987", (short)0, (Object)new Any(Type.STRING, (Object)"Brum"));
        }
        catch (Exception ex) {
            System.out.println("property already exists");
        }
        System.out.println(set.getPropertyValue("Test").toString());
    }

    public void setCustomProperty(String property, String value) throws Exception {
        if (this.propertySet.getPropertySetInfo().hasPropertyByName(property)) {
            this.userProperties.removeProperty(property);
        }
        if (value != null) {
            this.userProperties.addProperty(property, (short)128, (Object)new Any(Type.STRING, (Object)value));
        }
    }

    public String getCustomProperty(String property) throws Exception {
        if (this.propertySet.getPropertySetInfo().hasPropertyByName(property)) {
            return this.propertySet.getPropertyValue(property).toString();
        }
        return null;
    }

    public void updateSortedReferenceMarks() throws Exception {
        XReferenceMarksSupplier supplier = (XReferenceMarksSupplier)UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess nameAccess = supplier.getReferenceMarks();
        this.sortedReferenceMarks = this.getSortedReferenceMarks(nameAccess);
    }

    public void insertEntry(BibtexEntry[] entries, BibtexDatabase database, List<BibtexDatabase> allBases, OOBibStyle style, boolean inParenthesis, boolean withText, String pageInfo, boolean sync) throws Exception {
        try {
            XTextViewCursor xViewCursor = this.xViewCursorSupplier.getViewCursor();
            if (entries.length > 1) {
                if (style.getBooleanCitProperty("MultiCiteChronological")) {
                    Arrays.sort(entries, this.yearComparator);
                } else {
                    Arrays.sort(entries, this.entryComparator);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < entries.length; ++i) {
                BibtexEntry entry = entries[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(entry.getCiteKey());
            }
            String keyString = sb.toString();
            String bName = this.getUniqueReferenceMarkName(keyString, withText ? (inParenthesis ? 1 : 2) : 3);
            if (pageInfo != null) {
                System.out.println("Storing page info: " + pageInfo);
                this.setCustomProperty(bName, pageInfo);
            }
            String citeText = style.isNumberEntries() ? "-" : style.getCitationMarker(entries, database, inParenthesis, null, null);
            xViewCursor.getText().insertString((XTextRange)xViewCursor, " ", false);
            if (style.isFormatCitations()) {
                XPropertySet xCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xViewCursor);
                String charStyle = style.getCitationCharacterFormat();
                try {
                    xCursorProps.setPropertyValue("CharStyleName", (Object)charStyle);
                }
                catch (Throwable ex) {
                    xViewCursor.goLeft((short)1, true);
                    xViewCursor.setString("");
                    throw new UndefinedCharacterFormatException(charStyle);
                }
            }
            xViewCursor.goLeft((short)1, false);
            this.insertReferenceMark(bName, citeText, (XTextCursor)xViewCursor, withText, style);
            xViewCursor.collapseToEnd();
            xViewCursor.goRight((short)1, false);
            XTextRange position = xViewCursor.getEnd();
            if (sync) {
                this.updateSortedReferenceMarks();
                this.refreshCiteMarkers(allBases, style);
                this.rebuildBibTextSection(allBases, style);
            }
            try {
                xViewCursor.gotoRange(position, false);
            }
            catch (Exception ex) {
                System.out.println("Catch");
                ex.printStackTrace();
            }
        }
        catch (DisposedException ex) {
            throw new ConnectionLostException(ex.getMessage());
        }
    }

    public List<String> refreshCiteMarkers(List<BibtexDatabase> databases, OOBibStyle style) throws Exception {
        try {
            return this.refreshCiteMarkersInternal(databases, style);
        }
        catch (DisposedException ex) {
            throw new ConnectionLostException(ex.getMessage());
        }
    }

    public XNameAccess getReferenceMarks() {
        XReferenceMarksSupplier supplier = (XReferenceMarksSupplier)UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        return supplier.getReferenceMarks();
    }

    public String[] getJabRefReferenceMarks(XNameAccess nameAccess) {
        String[] names = nameAccess.getElementNames();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!this.citePattern.matcher(names[i]).find()) continue;
            tmp.add(names[i]);
        }
        names = tmp.toArray(new String[tmp.size()]);
        return names;
    }

    private List<String> refreshCiteMarkersInternal(List<BibtexDatabase> databases, OOBibStyle style) throws Exception {
        String[] names;
        List<String> cited = this.findCitedKeys();
        HashMap<String, BibtexDatabase> linkSourceBase = new HashMap<String, BibtexDatabase>();
        AbstractMap entries = this.findCitedEntries(databases, cited, linkSourceBase);
        XNameAccess nameAccess = this.getReferenceMarks();
        if (style.isSortByPosition()) {
            names = this.sortedReferenceMarks;
        } else if (style.isNumberEntries()) {
            TreeMap newMap = new TreeMap(this.entryComparator);
            for (BibtexEntry entry : entries.keySet()) {
                newMap.put(entry, entries.get(entry));
            }
            entries = newMap;
            cited.clear();
            for (BibtexEntry entry : entries.keySet()) {
                cited.add(entry.getCiteKey());
            }
            names = nameAccess.getElementNames();
        } else {
            names = this.sortedReferenceMarks;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!this.citePattern.matcher(names[i]).find()) continue;
            tmp.add(names[i]);
        }
        names = tmp.toArray(new String[tmp.size()]);
        HashMap<String, Integer> numbers = new HashMap<String, Integer>();
        int lastNum = 0;
        String[] citMarkers = new String[names.length];
        String[][] normCitMarkers = new String[names.length][];
        String[][] bibtexKeys = new String[names.length][];
        int minGroupingCount = style.getIntCitProperty("MinimumGroupingCount");
        int[] types = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            String citationMarker;
            int j;
            int type;
            Matcher m = this.citePattern.matcher(names[i]);
            if (!m.find()) continue;
            String typeStr = m.group(1);
            types[i] = type = Integer.parseInt(typeStr);
            String[] keys = m.group(2).split(",");
            bibtexKeys[i] = keys;
            BibtexEntry[] cEntries = new BibtexEntry[keys.length];
            for (int j2 = 0; j2 < cEntries.length; ++j2) {
                BibtexDatabase database = linkSourceBase.get(keys[j2]);
                cEntries[j2] = null;
                if (database != null) {
                    cEntries[j2] = OOUtil.createAdaptedEntry(database.getEntryByKey(keys[j2]));
                }
                if (cEntries[j2] != null) continue;
                System.out.println("Bibtex key not found : '" + keys[j2] + "'");
                System.out.println("Problem with reference mark: '" + names[i] + "'");
                cEntries[j2] = new UndefinedBibtexEntry(keys[j2]);
            }
            String[] normCitMarker = new String[keys.length];
            if (style.isBibtexKeyCiteMarkers()) {
                StringBuilder sb = new StringBuilder();
                normCitMarkers[i] = new String[keys.length];
                for (j = 0; j < keys.length; ++j) {
                    normCitMarkers[i][j] = cEntries[j].getCiteKey();
                    sb.append(cEntries[j].getCiteKey());
                    if (j >= keys.length - 1) continue;
                    sb.append(",");
                }
                citationMarker = sb.toString();
            } else if (style.isNumberEntries()) {
                if (style.isSortByPosition()) {
                    int[] num = new int[keys.length];
                    for (j = 0; j < keys.length; ++j) {
                        if (cEntries[j] instanceof UndefinedBibtexEntry) {
                            num[j] = -1;
                            continue;
                        }
                        num[j] = lastNum + 1;
                        if (numbers.containsKey(keys[j])) {
                            num[j] = (Integer)numbers.get(keys[j]);
                            continue;
                        }
                        numbers.put(keys[j], num[j]);
                        lastNum = num[j];
                    }
                    citationMarker = style.getNumCitationMarker(num, minGroupingCount, false);
                    for (j = 0; j < keys.length; ++j) {
                        normCitMarker[j] = style.getNumCitationMarker(new int[]{num[j]}, minGroupingCount, false);
                    }
                } else {
                    int[] num = this.findCitedEntryIndex(names[i], cited);
                    if (num == null) {
                        throw new BibtexEntryNotFoundException(names[i], Globals.lang("Could not resolve BibTeX entry for citation marker '%0'.", names[i]));
                    }
                    citationMarker = style.getNumCitationMarker(num, minGroupingCount, false);
                    for (j = 0; j < keys.length; ++j) {
                        normCitMarker[j] = style.getNumCitationMarker(new int[]{num[j]}, minGroupingCount, false);
                    }
                }
            } else {
                if (cEntries.length > 1) {
                    if (style.getBooleanCitProperty("MultiCiteChronological")) {
                        Arrays.sort(cEntries, this.yearComparator);
                    } else {
                        Arrays.sort(cEntries, this.entryComparator);
                    }
                    for (int j3 = 0; j3 < cEntries.length; ++j3) {
                        bibtexKeys[i][j3] = cEntries[j3].getCiteKey();
                    }
                }
                citationMarker = style.getCitationMarker(cEntries, (BibtexDatabase)entries.get(cEntries), type == 1, null, null);
                for (int j4 = 0; j4 < cEntries.length; ++j4) {
                    normCitMarker[j4] = style.getCitationMarker(cEntries[j4], (BibtexDatabase)entries.get(cEntries), true, null, -1);
                }
            }
            citMarkers[i] = citationMarker;
            normCitMarkers[i] = normCitMarker;
        }
        this.uniquefiers.clear();
        if (!style.isBibtexKeyCiteMarkers() && !style.isNumberEntries()) {
            HashMap refKeys = new HashMap();
            HashMap refNums = new HashMap();
            for (int i = 0; i < citMarkers.length; ++i) {
                String[] markers = normCitMarkers[i];
                for (int j = 0; j < markers.length; ++j) {
                    String marker = markers[j];
                    if (!refKeys.containsKey(marker)) {
                        ArrayList<String> l = new ArrayList<String>(1);
                        l.add(bibtexKeys[i][j]);
                        refKeys.put(marker, l);
                        ArrayList<Integer> l2 = new ArrayList<Integer>(1);
                        l2.add(i);
                        refNums.put(marker, l2);
                        continue;
                    }
                    if (((List)refKeys.get(marker)).contains(bibtexKeys[i][j])) continue;
                    ((List)refKeys.get(marker)).add(bibtexKeys[i][j]);
                    ((List)refNums.get(marker)).add(i);
                }
            }
            for (String marker : refKeys.keySet()) {
                List keys = (List)refKeys.get(marker);
                if (keys.size() <= 1) continue;
                int uniq = 97;
                for (String key : keys) {
                    this.uniquefiers.put(key, String.valueOf((char)uniq));
                    ++uniq;
                }
            }
            int maxAuthorsFirst = style.getIntCitProperty("MaxAuthorsFirst");
            HashSet<String> seenBefore = new HashSet<String>();
            for (int j = 0; j < bibtexKeys.length; ++j) {
                boolean needsChange = false;
                int[] firstLimAuthors = new int[bibtexKeys[j].length];
                String[] uniquif = new String[bibtexKeys[j].length];
                BibtexEntry[] cEntries = new BibtexEntry[bibtexKeys[j].length];
                for (int k = 0; k < bibtexKeys[j].length; ++k) {
                    BibtexDatabase database;
                    String uniq;
                    firstLimAuthors[k] = -1;
                    if (maxAuthorsFirst > 0) {
                        if (!seenBefore.contains(bibtexKeys[j][k])) {
                            firstLimAuthors[k] = maxAuthorsFirst;
                        }
                        seenBefore.add(bibtexKeys[j][k]);
                    }
                    if ((uniq = this.uniquefiers.get(bibtexKeys[j][k])) != null && uniq.length() >= 0) {
                        needsChange = true;
                        database = linkSourceBase.get(bibtexKeys[j][k]);
                        if (database != null) {
                            cEntries[k] = OOUtil.createAdaptedEntry(database.getEntryByKey(bibtexKeys[j][k]));
                        }
                        uniquif[k] = uniq;
                        continue;
                    }
                    if (firstLimAuthors[k] > 0) {
                        needsChange = true;
                        database = linkSourceBase.get(bibtexKeys[j][k]);
                        if (database != null) {
                            cEntries[k] = OOUtil.createAdaptedEntry(database.getEntryByKey(bibtexKeys[j][k]));
                        }
                        uniquif[k] = "";
                        continue;
                    }
                    database = linkSourceBase.get(bibtexKeys[j][k]);
                    if (database != null) {
                        cEntries[k] = OOUtil.createAdaptedEntry(database.getEntryByKey(bibtexKeys[j][k]));
                    }
                    uniquif[k] = "";
                }
                if (!needsChange) continue;
                citMarkers[j] = style.getCitationMarker(cEntries, (BibtexDatabase)entries.get(cEntries), types[j] == 1, uniquif, firstLimAuthors);
            }
        }
        boolean hadBibSection = this.getBookmarkRange(BIB_SECTION_NAME) != null;
        boolean mustTestCharFormat = style.isFormatCitations();
        for (int i = 0; i < names.length; ++i) {
            Object o = nameAccess.getByName(names[i]);
            XTextContent bm = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)o);
            XTextCursor cursor = bm.getAnchor().getText().createTextCursorByRange(bm.getAnchor());
            if (mustTestCharFormat) {
                mustTestCharFormat = false;
                XPropertySet xCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cursor);
                String charStyle = style.getCitationCharacterFormat();
                try {
                    xCursorProps.setPropertyValue("CharStyleName", (Object)charStyle);
                }
                catch (Throwable ex) {
                    throw new UndefinedCharacterFormatException(charStyle);
                }
            }
            this.text.removeTextContent(bm);
            this.insertReferenceMark(names[i], citMarkers[i], cursor, types[i] != 3, style);
            if (!hadBibSection || this.getBookmarkRange(BIB_SECTION_NAME) != null) continue;
            cursor.collapseToEnd();
            OOUtil.insertParagraphBreak(this.text, cursor);
            this.insertBookMark(BIB_SECTION_NAME, cursor);
        }
        ArrayList<String> unresolvedKeys = new ArrayList<String>();
        for (BibtexEntry entry : entries.keySet()) {
            String key;
            if (!(entry instanceof UndefinedBibtexEntry) || unresolvedKeys.contains(key = ((UndefinedBibtexEntry)entry).getKey())) continue;
            unresolvedKeys.add(key);
        }
        return unresolvedKeys;
    }

    public String[] getSortedReferenceMarks(XNameAccess nameAccess) throws Exception {
        int i;
        XTextViewCursorSupplier css = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)this.mxDoc.getCurrentController());
        XTextViewCursor tvc = css.getViewCursor();
        XTextRange initialPos = tvc.getStart();
        String[] names = nameAccess.getElementNames();
        Point[] positions = new Point[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            XTextContent tc = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)nameAccess.getByName(name));
            XTextRange r = tc.getAnchor();
            if (UnoRuntime.queryInterface(XFootnote.class, (Object)r.getText()) != null) {
                XFootnote footer = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)r.getText());
                r = footer.getAnchor();
            }
            positions[i2] = this.findPosition(tvc, r);
        }
        TreeSet<ComparableMark> set = new TreeSet<ComparableMark>();
        for (i = 0; i < positions.length; ++i) {
            set.add(new ComparableMark(names[i], positions[i]));
        }
        i = 0;
        for (ComparableMark mark : set) {
            names[i++] = mark.getName();
        }
        tvc.gotoRange(initialPos, false);
        return names;
    }

    public void rebuildBibTextSection(List<BibtexDatabase> databases, OOBibStyle style) throws Exception {
        List<String> cited = this.findCitedKeys();
        HashMap<String, BibtexDatabase> linkSourceBase = new HashMap<String, BibtexDatabase>();
        AbstractMap entries = this.findCitedEntries(databases, cited, linkSourceBase);
        String[] names = this.sortedReferenceMarks;
        if (style.isSortByPosition()) {
            entries = this.getSortedEntriesFromSortedRefMarks(names, entries, linkSourceBase);
        } else {
            TreeMap newMap = new TreeMap(this.entryComparator);
            for (BibtexEntry entry : entries.keySet()) {
                newMap.put(entry, entries.get(entry));
            }
            entries = newMap;
        }
        this.clearBibTextSectionContent2();
        this.populateBibTextSection(entries, style);
    }

    public String getUniqueReferenceMarkName(String bibtexKey, int type) {
        XReferenceMarksSupplier supplier = (XReferenceMarksSupplier)UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNamedRefMarks = supplier.getReferenceMarks();
        int i = 0;
        String name = "JR_cite_" + type + "_" + bibtexKey;
        while (xNamedRefMarks.hasByName(name)) {
            name = BIB_CITATION + i + "_" + type + "_" + bibtexKey;
            ++i;
        }
        return name;
    }

    public LinkedHashMap<BibtexEntry, BibtexDatabase> findCitedEntries(List<BibtexDatabase> databases, List<String> keys, HashMap<String, BibtexDatabase> linkSourceBase) {
        LinkedHashMap<BibtexEntry, BibtexDatabase> entries = new LinkedHashMap<BibtexEntry, BibtexDatabase>();
        for (String key : keys) {
            boolean found = false;
            for (BibtexDatabase database : databases) {
                BibtexEntry entry = database.getEntryByKey(key);
                if (entry == null) continue;
                entries.put(OOUtil.createAdaptedEntry(entry), database);
                linkSourceBase.put(key, database);
                found = true;
                break;
            }
            if (found) continue;
            entries.put(new UndefinedBibtexEntry(key), null);
        }
        return entries;
    }

    public List<String> findCitedKeys() throws NoSuchElementException, WrappedTargetException {
        XReferenceMarksSupplier supplier = (XReferenceMarksSupplier)UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNamedMarks = supplier.getReferenceMarks();
        String[] names = xNamedMarks.getElementNames();
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            Object bookmark = xNamedMarks.getByName(names[i]);
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)bookmark);
            String name = names[i];
            List<String> newKeys = this.parseRefMarkName(name);
            for (String key : newKeys) {
                if (keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public LinkedHashMap<BibtexEntry, BibtexDatabase> getSortedEntriesFromSortedRefMarks(String[] names, Map<BibtexEntry, BibtexDatabase> entries, HashMap<String, BibtexDatabase> linkSourceBase) throws BibtexEntryNotFoundException {
        LinkedHashMap<BibtexEntry, BibtexDatabase> newList = new LinkedHashMap<BibtexEntry, BibtexDatabase>();
        HashMap<BibtexEntry, BibtexEntry> adaptedEntries = new HashMap<BibtexEntry, BibtexEntry>();
        for (int i = 0; i < names.length; ++i) {
            Matcher m = this.citePattern.matcher(names[i]);
            if (!m.find()) continue;
            String[] keys = m.group(2).split(",");
            for (int j = 0; j < keys.length; ++j) {
                BibtexDatabase database = linkSourceBase.get(keys[j]);
                BibtexEntry origEntry = null;
                if (database != null) {
                    origEntry = database.getEntryByKey(keys[j]);
                }
                if (origEntry == null) {
                    System.out.println("Bibtex key not found : '" + keys[j] + "'");
                    System.out.println("Problem with reference mark: '" + names[i] + "'");
                    newList.put(new UndefinedBibtexEntry(keys[j]), null);
                    continue;
                }
                BibtexEntry entry = (BibtexEntry)adaptedEntries.get(origEntry);
                if (entry == null) {
                    entry = OOUtil.createAdaptedEntry(origEntry);
                    adaptedEntries.put(origEntry, entry);
                }
                if (newList.containsKey(entry)) continue;
                newList.put(entry, database);
            }
        }
        return newList;
    }

    public Point findPosition(XTextViewCursor cursor, XTextRange range) {
        cursor.gotoRange(range, false);
        return cursor.getPosition();
    }

    public List<String> parseRefMarkName(String name) {
        ArrayList<String> keys = new ArrayList<String>();
        Matcher m = this.citePattern.matcher(name);
        if (m.find()) {
            String[] keystring = m.group(2).split(",");
            for (int j = 0; j < keystring.length; ++j) {
                if (keys.contains(keystring[j])) continue;
                keys.add(keystring[j]);
            }
        }
        return keys;
    }

    public int[] findCitedEntryIndex(String citRefName, List<String> keys) {
        Matcher m = this.citePattern.matcher(citRefName);
        if (m.find()) {
            String[] keyStrings = m.group(2).split(",");
            int[] res = new int[keyStrings.length];
            for (int i = 0; i < keyStrings.length; ++i) {
                int ind = keys.indexOf(keyStrings[i]);
                res[i] = ind != -1 ? 1 + ind : -1;
            }
            return res;
        }
        return null;
    }

    public String getCitationContext(XNameAccess nameAccess, String refMarkName, int charBefore, int charAfter, boolean htmlMarkup) throws Exception {
        Object o = nameAccess.getByName(refMarkName);
        XTextContent bm = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)o);
        XTextCursor cursor = bm.getAnchor().getText().createTextCursorByRange(bm.getAnchor());
        String citPart = cursor.getString();
        int flex = 8;
        for (int i = 0; i < charBefore; ++i) {
            try {
                cursor.goLeft((short)1, true);
                if (i < charBefore - flex || !Character.isWhitespace(cursor.getString().charAt(0))) continue;
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int length = cursor.getString().length();
        int added = length - citPart.length();
        cursor.collapseToStart();
        for (int i = 0; i < charAfter + length; ++i) {
            try {
                String strNow;
                cursor.goRight((short)1, true);
                if (i < charAfter + length - flex || !Character.isWhitespace((strNow = cursor.getString()).charAt(strNow.length() - 1))) continue;
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String result = cursor.getString();
        if (htmlMarkup) {
            result = result.substring(0, added) + "<b>" + citPart + "</b>" + result.substring(length);
        }
        return result.trim();
    }

    public void insertFullReferenceAtCursor(XTextCursor cursor, Map<BibtexEntry, BibtexDatabase> entries, OOBibStyle style, String parFormat) throws UndefinedParagraphFormatException, Exception {
        if (!style.isSortByPosition()) {
            TreeMap<BibtexEntry, BibtexDatabase> newMap = new TreeMap<BibtexEntry, BibtexDatabase>(this.entryComparator);
            for (BibtexEntry entry : entries.keySet()) {
                newMap.put(entry, entries.get(entry));
            }
            entries = newMap;
        }
        int number = 1;
        for (BibtexEntry entry : entries.keySet()) {
            if (entry instanceof UndefinedBibtexEntry) continue;
            OOUtil.insertParagraphBreak(this.text, cursor);
            if (style.isNumberEntries()) {
                int minGroupingCount = style.getIntCitProperty("MinimumGroupingCount");
                OOUtil.insertTextAtCurrentLocation(this.text, cursor, style.getNumCitationMarker(new int[]{number++}, minGroupingCount, true), false, false, false, false, false, false);
            }
            Layout layout = style.getReferenceFormat(entry.getType().getName());
            try {
                layout.setPostFormatter(OOUtil.postformatter);
            }
            catch (NoSuchMethodError ex) {
                // empty catch block
            }
            OOUtil.insertFullReferenceAtCurrentLocation(this.text, cursor, layout, parFormat, entry, entries.get(entry), this.uniquefiers.get(entry.getCiteKey()));
        }
    }

    public void insertFullReferenceAtViewCursor(Map<BibtexEntry, BibtexDatabase> entries, OOBibStyle style, String parFormat) throws Exception {
        XTextViewCursor xViewCursor = this.xViewCursorSupplier.getViewCursor();
        this.insertFullReferenceAtCursor((XTextCursor)xViewCursor, entries, style, parFormat);
    }

    public void insertMarkedUpTextAtViewCursor(String lText, String parFormat) throws Exception {
        XTextViewCursor xViewCursor = this.xViewCursorSupplier.getViewCursor();
        XTextCursor cursor = this.text.createTextCursorByRange(xViewCursor.getEnd());
        OOUtil.insertOOFormattedTextAtCurrentLocation(this.text, cursor, lText, parFormat);
    }

    public boolean createBibTextSection(boolean end) throws Exception {
        XBookmarksSupplier bSupp = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.mxDoc);
        if (bSupp.getBookmarks().hasByName(BIB_SECTION_NAME)) {
            System.out.println("Found existing JabRef bookmark");
            return true;
        }
        XTextCursor mxDocCursor = this.text.createTextCursor();
        if (end) {
            mxDocCursor.gotoEnd(false);
        }
        OOUtil.insertParagraphBreak(this.text, mxDocCursor);
        this.insertBookMark(BIB_SECTION_NAME, mxDocCursor);
        return false;
    }

    public void createBibTextSection2(boolean end) throws Exception {
        XTextCursor mxDocCursor = this.text.createTextCursor();
        if (end) {
            mxDocCursor.gotoEnd(false);
        }
        OOUtil.insertParagraphBreak(this.text, mxDocCursor);
        XNamed xChildNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)this.mxDocFactory.createInstance("com.sun.star.text.TextSection"));
        xChildNamed.setName(BIB_SECTION_NAME);
        XTextContent xChildSection = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xChildNamed);
        this.text.insertTextContent((XTextRange)mxDocCursor, xChildSection, false);
    }

    public void clearBibTextSectionContent2() throws Exception {
        boolean exists = false;
        XTextSectionsSupplier supp = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.mxDoc);
        try {
            XTextSection section = (XTextSection)((Any)supp.getTextSections().getByName(BIB_SECTION_NAME)).getObject();
            XTextCursor cursor = this.text.createTextCursorByRange(section.getAnchor());
            cursor.gotoRange(section.getAnchor(), false);
            cursor.setString("");
        }
        catch (NoSuchElementException ex) {
            this.createBibTextSection2(this.atEnd);
        }
    }

    public void clearBibTextSectionContent() throws Exception {
        XTextRange rangeEnd;
        XTextRangeCompare compare = (XTextRangeCompare)UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)this.text);
        XTextRange range = this.getBookmarkRange(BIB_SECTION_NAME);
        if (range == null) {
            this.createBibTextSection(this.atEnd);
        }
        if ((rangeEnd = this.getBookmarkRange(BIB_SECTION_END_NAME)) == null) {
            return;
        }
        XTextCursor mxDocCursor = this.text.createTextCursorByRange(range.getEnd());
        mxDocCursor.goRight((short)1, true);
        boolean couldExpand = true;
        while (couldExpand && compare.compareRegionEnds((XTextRange)mxDocCursor, rangeEnd) > 0) {
            couldExpand = mxDocCursor.goRight((short)1, true);
        }
        mxDocCursor.setString("");
        mxDocCursor.collapseToStart();
        this.removeBookMark(BIB_SECTION_END_NAME);
        if (this.getBookmarkRange(BIB_SECTION_NAME) == null) {
            this.insertBookMark(BIB_SECTION_NAME, mxDocCursor);
        }
    }

    public void populateBibTextSection(Map<BibtexEntry, BibtexDatabase> entries, OOBibStyle style) throws UndefinedParagraphFormatException, Exception {
        XTextSectionsSupplier supp = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.mxDoc);
        XTextSection section = (XTextSection)((Any)supp.getTextSections().getByName(BIB_SECTION_NAME)).getObject();
        XTextCursor cursor = this.text.createTextCursorByRange(section.getAnchor());
        OOUtil.insertTextAtCurrentLocation(this.text, cursor, (String)style.getProperty("Title"), (String)style.getProperty("ReferenceHeaderParagraphFormat"));
        this.insertFullReferenceAtCursor(cursor, entries, style, (String)style.getProperty("ReferenceParagraphFormat"));
        this.insertBookMark(BIB_SECTION_END_NAME, cursor);
    }

    public XTextContent insertBookMark(String name, XTextCursor position) throws Exception {
        Object bookmark = this.mxDocFactory.createInstance("com.sun.star.text.Bookmark");
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)bookmark);
        xNamed.setName(name);
        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)bookmark);
        this.text.insertTextContent((XTextRange)position, xTextContent, true);
        position.collapseToEnd();
        return xTextContent;
    }

    public void insertReferenceMark(String name, String citText, XTextCursor position, boolean withText, OOBibStyle style) throws Exception {
        String etAlString;
        int index;
        String pageInfo = this.getCustomProperty(name);
        if (pageInfo != null) {
            citText = style.insertPageInfo(citText, pageInfo);
        }
        Object bookmark = this.mxDocFactory.createInstance("com.sun.star.text.ReferenceMark");
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)bookmark);
        xNamed.setName(name);
        XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)bookmark);
        if (withText) {
            position.setString(citText);
            XPropertySet xCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)position);
            xCursorProps.setPropertyValue("CharLocale", (Object)new Locale("zxx", "", ""));
            if (style.isFormatCitations()) {
                String charStyle = style.getCitationCharacterFormat();
                try {
                    xCursorProps.setPropertyValue("CharStyleName", (Object)charStyle);
                }
                catch (Throwable ex) {
                    throw new UndefinedCharacterFormatException(charStyle);
                }
            }
        } else {
            position.setString("");
        }
        position.getText().insertTextContent((XTextRange)position, xTextContent, true);
        boolean italicize = style.getBooleanCitProperty("ItalicEtAl");
        if (italicize && (index = citText.indexOf(etAlString = style.getStringCitProperty("EtAlString"))) >= 0) {
            this.italicizeOrBold(position, true, index, index + etAlString.length());
        }
        position.collapseToEnd();
    }

    private void italicizeOrBold(XTextCursor position, boolean italicize, int start, int end) throws Exception {
        XTextRange rng = position.getStart();
        XTextCursor cursor = position.getText().createTextCursorByRange(rng);
        cursor.goRight((short)start, false);
        cursor.goRight((short)(end - start), true);
        XPropertySet xcp = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cursor);
        if (italicize) {
            xcp.setPropertyValue("CharPosture", (Object)FontSlant.ITALIC);
        } else {
            xcp.setPropertyValue("CharWeight", (Object)Float.valueOf(150.0f));
        }
    }

    public void testFootnote() throws Exception {
        XTextViewCursor xViewCursor = this.xViewCursorSupplier.getViewCursor();
        this.insertFootnote("jabbes", "Cite text", (XTextCursor)xViewCursor);
    }

    public void insertFootnote(String name, String citText, XTextCursor position) throws Exception {
        XFootnote xFootnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)this.mxDocFactory.createInstance("com.sun.star.text.Footnote"));
        xFootnote.setLabel("");
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFootnote);
        props.setPropertyValue("ReferenceId", (Object)name);
        System.out.println(props.getPropertyValue("ReferenceId"));
        XTextContent xContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xFootnote);
        this.text.insertTextContent((XTextRange)position, xContent, false);
        XSimpleText xSimple = (XSimpleText)UnoRuntime.queryInterface(XSimpleText.class, (Object)xFootnote);
        XTextRange xRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xSimple.createTextCursor());
        xSimple.insertString(xRange, citText, false);
    }

    public void removeBookMark(String name) throws Exception {
        XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        if (xBookmarksSupplier.getBookmarks().hasByName(name)) {
            Object o = xBookmarksSupplier.getBookmarks().getByName(name);
            XTextContent bm = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)o);
            this.text.removeTextContent(bm);
        }
    }

    public void removeReferenceMark(String name) throws Exception {
        XReferenceMarksSupplier xSupplier = (XReferenceMarksSupplier)UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        if (xSupplier.getReferenceMarks().hasByName(name)) {
            Object o = xSupplier.getReferenceMarks().getByName(name);
            XTextContent bm = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)o);
            this.text.removeTextContent(bm);
        }
    }

    public XTextRange getBookmarkRange(String name) throws Exception {
        XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNamedBookmarks = xBookmarksSupplier.getBookmarks();
        if (!xNamedBookmarks.hasByName(name)) {
            return null;
        }
        Object foundBookmark = xNamedBookmarks.getByName(name);
        XTextContent xFoundBookmark = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)foundBookmark);
        return xFoundBookmark.getAnchor();
    }

    public void printBookmarkNames() throws Exception {
        XBookmarksSupplier xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNamedBookmarks = xBookmarksSupplier.getBookmarks();
        String[] names = xNamedBookmarks.getElementNames();
        for (int i = 0; i < names.length; ++i) {
            System.out.println(i + ". " + names[i]);
        }
    }

    public void setFocus() {
        this.xDesktop.getCurrentFrame().getContainerWindow().setFocus();
    }

    public void combineCiteMarkers(List<BibtexDatabase> databases, OOBibStyle style) throws Exception {
        XReferenceMarksSupplier supplier = (XReferenceMarksSupplier)UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess nameAccess = supplier.getReferenceMarks();
        String[] names = this.getSortedReferenceMarks(nameAccess);
        XTextRangeCompare compare = (XTextRangeCompare)UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)this.text);
        int piv = 0;
        boolean madeModifications = false;
        while (piv < names.length - 1) {
            XTextRange r1 = ((XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)nameAccess.getByName(names[piv]))).getAnchor().getEnd();
            XTextRange r2 = ((XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)nameAccess.getByName(names[piv + 1]))).getAnchor().getStart();
            if (r1.getText() != r2.getText()) {
                ++piv;
                continue;
            }
            XTextCursor mxDocCursor = r1.getText().createTextCursorByRange(r1);
            mxDocCursor.goRight((short)1, true);
            boolean couldExpand = true;
            while (couldExpand && compare.compareRegionEnds((XTextRange)mxDocCursor, r2) > 0) {
                couldExpand = mxDocCursor.goRight((short)1, true);
            }
            String text = mxDocCursor.getString();
            if (text.indexOf(10) == -1 && text.trim().length() == 0) {
                if (style.isFormatCitations()) {
                    XPropertySet xCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)mxDocCursor);
                    String charStyle = style.getCitationCharacterFormat();
                    try {
                        xCursorProps.setPropertyValue("CharStyleName", (Object)charStyle);
                    }
                    catch (Throwable ex) {
                        throw new UndefinedCharacterFormatException(charStyle);
                    }
                }
                List<String> keys = this.parseRefMarkName(names[piv]);
                keys.addAll(this.parseRefMarkName(names[piv + 1]));
                this.removeReferenceMark(names[piv]);
                this.removeReferenceMark(names[piv + 1]);
                ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
                block4: for (String key : keys) {
                    for (BibtexDatabase database : databases) {
                        BibtexEntry entry = database.getEntryByKey(key);
                        if (entry == null) continue;
                        entries.add(OOUtil.createAdaptedEntry(entry));
                        continue block4;
                    }
                }
                Collections.sort(entries, new FieldComparator("year"));
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (BibtexEntry entry : entries) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(entry.getCiteKey());
                    ++i;
                }
                String keyString = sb.toString();
                boolean inParenthesis = true;
                String bName = this.getUniqueReferenceMarkName(keyString, inParenthesis ? 1 : 2);
                this.insertReferenceMark(bName, "tmp", mxDocCursor, true, style);
                names[piv + 1] = bName;
                madeModifications = true;
            }
            ++piv;
        }
        if (madeModifications) {
            this.updateSortedReferenceMarks();
            this.refreshCiteMarkers(databases, style);
        }
    }

    public void testFrameHandling() throws Exception {
        XController oldController = this.mxDoc.getCurrentController();
        PropertyValue[] props = new PropertyValue[2];
        props[0] = new PropertyValue();
        props[0].Name = "Model";
        props[0].Value = this.mxDoc.getCurrentController().getModel();
        props[1] = new PropertyValue();
        props[1].Name = "Hidden";
        props[1].Value = true;
        System.out.println("her");
        XComponent comp = this.xComponentLoader.loadComponentFromURL("private:factory/swriter", "_blank", 0, props);
        System.out.println("her2");
        XTextDocument newDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)comp);
        System.out.println("newDoc = " + newDoc);
        XController xController = newDoc.getCurrentController();
        XFrame xFrame = xController.getFrame();
        XWindow xContainerWindow = xFrame.getContainerWindow();
        XWindow xComponentWindow = xFrame.getComponentWindow();
        xFrame.dispose();
    }
}

