/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import java.util.HashMap;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class OOPreFormatter
implements LayoutFormatter {
    public static HashMap<String, String> CHARS = new HashMap();

    public String format(String field) {
        field = field.replaceAll("&|\\\\&", "&");
        StringBuffer sb = new StringBuffer();
        StringBuffer currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String result;
            IntAndString part;
            String result2;
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result2 = CHARS.get(command);
                    if (result2 != null) {
                        sb.append(result2);
                    } else {
                        sb.append(command);
                    }
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuffer();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || c == '%' || Globals.SPECIAL_COMMAND_CHARS.indexOf(String.valueOf(c)) >= 0) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && Globals.SPECIAL_COMMAND_CHARS.indexOf(currentCommand.toString()) >= 0) {
                    String combody;
                    if (i >= field.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = field.charAt(++i)) == '{') {
                        part = this.getPart(field, i, false);
                        i += part.i;
                        combody = part.s;
                    } else {
                        combody = field.substring(i, i + 1);
                    }
                    result = CHARS.get(command + combody);
                    if (result != null) {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i + 1 != field.length()) continue;
                command = currentCommand.toString();
                result2 = CHARS.get(command);
                if (result2 != null) {
                    sb.append(result2);
                    continue;
                }
                sb.append(command);
                continue;
            }
            String argument = null;
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                String command2 = currentCommand.toString();
                if (command2.equals("em") || command2.equals("emph") || command2.equals("textit")) {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    sb.append("<em>").append(part.s).append("</em>");
                } else if (command2.equals("textbf")) {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    sb.append("<b>").append(part.s).append("</b>");
                } else if (c == '{') {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    argument = part.s;
                    if (argument != null) {
                        String result3 = CHARS.get(command2 + argument);
                        if (result3 != null) {
                            sb.append(result3);
                        } else {
                            sb.append(argument);
                        }
                    }
                } else if (c == '}') {
                    result = CHARS.get(command2);
                    if (result != null) {
                        sb.append(result);
                    } else {
                        sb.append(command2);
                    }
                } else {
                    result = CHARS.get(command2);
                    if (result != null) {
                        sb.append(result);
                    } else {
                        sb.append(command2);
                    }
                    sb.append(' ');
                }
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString();
    }

    private IntAndString getPart(String text, int i, boolean terminateOnEndBraceOnly) {
        int count = 0;
        StringBuffer part = new StringBuffer();
        ++i;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!terminateOnEndBraceOnly && count == 0 && Character.isWhitespace(c)) {
                --i;
                break;
            }
            if (c == '}' && --count < 0) break;
            if (c == '{') {
                ++count;
            }
            part.append(c);
            ++i;
        }
        return new IntAndString(part.length(), this.format(part.toString()));
    }

    static {
        CHARS.put("`A", "\u00c0");
        CHARS.put("'A", "\u00c1");
        CHARS.put("^A", "\u00c2");
        CHARS.put("~A", "\u00c3");
        CHARS.put("\"A", "\u00c4");
        CHARS.put("AA", "\u00c5");
        CHARS.put("AE", "\u00c6");
        CHARS.put("cC", "\u00c7");
        CHARS.put("`E", "\u00c8");
        CHARS.put("'E", "\u00c9");
        CHARS.put("^E", "\u00ca");
        CHARS.put("\"E", "\u00cb");
        CHARS.put("`I", "\u00cc");
        CHARS.put("'I", "\u00cd");
        CHARS.put("^I", "\u00ce");
        CHARS.put("\"I", "\u00cf");
        CHARS.put("DH", "\u00d0");
        CHARS.put("~N", "\u00d1");
        CHARS.put("`O", "\u00d2");
        CHARS.put("'O", "\u00d3");
        CHARS.put("^O", "\u00d4");
        CHARS.put("~O", "\u00d5");
        CHARS.put("\"O", "\u00d6");
        CHARS.put("O", "\u00d8");
        CHARS.put("`U", "\u00d9");
        CHARS.put("'U", "\u00da");
        CHARS.put("^U", "\u00db");
        CHARS.put("\"U", "\u00dc");
        CHARS.put("'Y", "\u00dd");
        CHARS.put("TH", "\u00de");
        CHARS.put("ss", "\u00df");
        CHARS.put("`a", "\u00e0");
        CHARS.put("'a", "\u00e1");
        CHARS.put("^a", "\u00e2");
        CHARS.put("~a", "\u00e3");
        CHARS.put("\"a", "\u00e4");
        CHARS.put("aa", "\u00e5");
        CHARS.put("ae", "\u00e6");
        CHARS.put("cc", "\u00e7");
        CHARS.put("`e", "\u00e8");
        CHARS.put("'e", "\u00e9");
        CHARS.put("^e", "\u00ea");
        CHARS.put("\"e", "\u00eb");
        CHARS.put("`i", "\u00ec");
        CHARS.put("'i", "\u00ed");
        CHARS.put("^i", "\u00ee");
        CHARS.put("\"i", "\u00ef");
        CHARS.put("dh", "\u00f0");
        CHARS.put("~n", "\u00f1");
        CHARS.put("`o", "\u00f2");
        CHARS.put("'o", "\u00f3");
        CHARS.put("^o", "\u00f4");
        CHARS.put("~o", "\u00f5");
        CHARS.put("\"o", "\u00f6");
        CHARS.put("o", "\u00f8");
        CHARS.put("`u", "\u00f9");
        CHARS.put("'u", "\u00fa");
        CHARS.put("^u", "\u00fb");
        CHARS.put("\"u", "\u00fc");
        CHARS.put("'y", "\u00fd");
        CHARS.put("th", "\u00fe");
        CHARS.put("\"y", "\u00ff");
        CHARS.put("=A", "\u0100");
        CHARS.put("=a", "\u0101");
        CHARS.put("uA", "\u0102");
        CHARS.put("ua", "\u0103");
        CHARS.put("kA", "\u0104");
        CHARS.put("ka", "\u0105");
        CHARS.put("'C", "\u0106");
        CHARS.put("'c", "\u0107");
        CHARS.put("^C", "\u0108");
        CHARS.put("^c", "\u0109");
        CHARS.put(".C", "\u010a");
        CHARS.put(".c", "\u010b");
        CHARS.put("vC", "\u010c");
        CHARS.put("vc", "\u010d");
        CHARS.put("vD", "\u010e");
        CHARS.put("DJ", "\u0110");
        CHARS.put("dj", "\u0111");
        CHARS.put("=E", "\u0112");
        CHARS.put("=e", "\u0113");
        CHARS.put("uE", "\u0114");
        CHARS.put("ue", "\u0115");
        CHARS.put(".E", "\u0116");
        CHARS.put(".e", "\u0117");
        CHARS.put("kE", "\u0118");
        CHARS.put("ke", "\u0119");
        CHARS.put("vE", "\u011a");
        CHARS.put("ve", "\u011b");
        CHARS.put("^G", "\u011c");
        CHARS.put("^g", "\u011d");
        CHARS.put("uG", "\u011e");
        CHARS.put("ug", "\u011f");
        CHARS.put(".G", "\u0120");
        CHARS.put(".g", "\u0121");
        CHARS.put("cG", "\u0122");
        CHARS.put("'g", "\u0123");
        CHARS.put("^H", "\u0124");
        CHARS.put("^h", "\u0125");
        CHARS.put("Hstrok", "\u0126");
        CHARS.put("hstrok", "\u0127");
        CHARS.put("~I", "\u0128");
        CHARS.put("~i", "\u0129");
        CHARS.put("=I", "\u012a");
        CHARS.put("=i", "\u012b");
        CHARS.put("uI", "\u012c");
        CHARS.put("ui", "\u012d");
        CHARS.put("kI", "\u012e");
        CHARS.put("ki", "\u012f");
        CHARS.put(".I", "\u0130");
        CHARS.put("i", "\u0131");
        CHARS.put("^J", "\u0134");
        CHARS.put("^j", "\u0135");
        CHARS.put("cK", "\u0136");
        CHARS.put("ck", "\u0137");
        CHARS.put("'L", "\u0139");
        CHARS.put("'l", "\u013a");
        CHARS.put("cL", "\u013b");
        CHARS.put("cl", "\u013c");
        CHARS.put("Lmidot", "\u013f");
        CHARS.put("lmidot", "\u0140");
        CHARS.put("L", "\u0141");
        CHARS.put("l", "\u0142");
        CHARS.put("'N", "\u0143");
        CHARS.put("'n", "\u0144");
        CHARS.put("cN", "\u0145");
        CHARS.put("cn", "\u0146");
        CHARS.put("vN", "\u0147");
        CHARS.put("vn", "\u0148");
        CHARS.put("NG", "\u014a");
        CHARS.put("ng", "\u014b");
        CHARS.put("=O", "\u014c");
        CHARS.put("=o", "\u014d");
        CHARS.put("uO", "\u014e");
        CHARS.put("uo", "\u014f");
        CHARS.put("HO", "\u0150");
        CHARS.put("Ho", "\u0151");
        CHARS.put("OE", "\u0152");
        CHARS.put("oe", "\u0153");
        CHARS.put("'R", "\u0154");
        CHARS.put("'r", "\u0155");
        CHARS.put("cR", "\u0156");
        CHARS.put("cr", "\u0157");
        CHARS.put("vR", "\u0158");
        CHARS.put("vr", "\u0159");
        CHARS.put("'S", "\u015a");
        CHARS.put("'s", "\u015b");
        CHARS.put("^S", "\u015c");
        CHARS.put("^s", "\u015d");
        CHARS.put("cS", "\u015e");
        CHARS.put("cs", "\u015f");
        CHARS.put("vS", "\u0160");
        CHARS.put("vs", "\u0161");
        CHARS.put("cT", "\u0162");
        CHARS.put("ct", "\u0163");
        CHARS.put("vT", "\u0164");
        CHARS.put("Tstrok", "\u0166");
        CHARS.put("tstrok", "\u0167");
        CHARS.put("~U", "\u0168");
        CHARS.put("~u", "\u0169");
        CHARS.put("=U", "\u016a");
        CHARS.put("=u", "\u016b");
        CHARS.put("uU", "\u016c");
        CHARS.put("uu", "\u016d");
        CHARS.put("rU", "\u016e");
        CHARS.put("ru", "\u016f");
        CHARS.put("HU", "\u016f");
        CHARS.put("Hu", "\u0171");
        CHARS.put("kU", "\u0172");
        CHARS.put("ku", "\u0173");
        CHARS.put("^W", "\u0174");
        CHARS.put("^w", "\u0175");
        CHARS.put("^Y", "\u0176");
        CHARS.put("^y", "\u0177");
        CHARS.put("\"Y", "\u0178");
        CHARS.put("'Z", "\u0179");
        CHARS.put("'z", "\u017a");
        CHARS.put(".Z", "\u017b");
        CHARS.put(".z", "\u017c");
        CHARS.put("vZ", "\u017d");
        CHARS.put("vz", "\u017e");
        CHARS.put("%", "%");
    }

    private class IntAndString {
        public int i;
        String s;

        public IntAndString(int i, String s) {
            this.i = i;
            this.s = s;
        }
    }
}

