/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.undo.NamedCompound;

public class MassSetFieldAction
extends MnemonicAwareAction {
    private JabRefFrame frame;
    private JDialog diag;
    private JRadioButton all;
    private JRadioButton selected;
    private JRadioButton clear;
    private JRadioButton set;
    private JRadioButton rename;
    private JTextField field;
    private JTextField text;
    private JTextField renameTo;
    private JButton ok;
    private JButton cancel;
    boolean cancelled = true;
    private JCheckBox overwrite;

    public MassSetFieldAction(JabRefFrame frame) {
        this.putValue("Name", "Set/clear/rename fields");
        this.frame = frame;
    }

    private void createDialog() {
        this.diag = new JDialog(this.frame, Globals.lang("Set/clear/rename fields"), true);
        this.field = new JTextField();
        this.text = new JTextField();
        this.text.setEnabled(false);
        this.renameTo = new JTextField();
        this.renameTo.setEnabled(false);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.all = new JRadioButton(Globals.lang("All entries"));
        this.selected = new JRadioButton(Globals.lang("Selected entries"));
        this.clear = new JRadioButton(Globals.lang("Clear fields"));
        this.set = new JRadioButton(Globals.lang("Set fields"));
        this.rename = new JRadioButton(Globals.lang("Rename field to:"));
        this.rename.setToolTipText(Globals.lang("Move contents of a field into a field with a different name"));
        this.set.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MassSetFieldAction.this.text.setEnabled(MassSetFieldAction.this.set.isSelected());
            }
        });
        this.clear.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                MassSetFieldAction.this.overwrite.setEnabled(!MassSetFieldAction.this.clear.isSelected());
            }
        });
        this.rename.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MassSetFieldAction.this.renameTo.setEnabled(MassSetFieldAction.this.rename.isSelected());
            }
        });
        this.overwrite = new JCheckBox(Globals.lang("Overwrite existing field values"), true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.all);
        bg.add(this.selected);
        bg = new ButtonGroup();
        bg.add(this.clear);
        bg.add(this.set);
        bg.add(this.rename);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:100dlu", ""));
        builder.appendSeparator(Globals.lang("Field name"));
        builder.append(Globals.lang("Field name"));
        builder.append(this.field);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Include entries"));
        builder.append((Component)this.all, 3);
        builder.nextLine();
        builder.append((Component)this.selected, 3);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("New field value"));
        builder.append(this.set);
        builder.append(this.text);
        builder.nextLine();
        builder.append(this.clear);
        builder.nextLine();
        builder.append(this.rename);
        builder.append(this.renameTo);
        builder.nextLine();
        builder.append((Component)this.overwrite, 3);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] fields;
                if (MassSetFieldAction.this.rename.isSelected() && (fields = MassSetFieldAction.this.getFieldNames(MassSetFieldAction.this.field.getText())).length > 1) {
                    JOptionPane.showMessageDialog(MassSetFieldAction.this.diag, Globals.lang("You can only rename one field at a time"), "", 0);
                    return;
                }
                MassSetFieldAction.this.cancelled = false;
                MassSetFieldAction.this.diag.dispose();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MassSetFieldAction.this.cancelled = true;
                MassSetFieldAction.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelAction);
    }

    private void prepareDialog(boolean selection) {
        this.selected.setEnabled(selection);
        if (selection) {
            this.selected.setSelected(true);
        } else {
            this.all.setSelected(true);
        }
        if (!(this.set.isSelected() || this.clear.isSelected() || this.rename.isSelected())) {
            this.set.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        BasePanel bp = this.frame.basePanel();
        if (bp == null) {
            return;
        }
        BibtexEntry[] entries = bp.getSelectedEntries();
        if (this.diag == null) {
            this.createDialog();
        }
        this.cancelled = true;
        this.prepareDialog(entries.length > 0);
        Util.placeDialog(this.diag, this.frame);
        this.diag.setVisible(true);
        if (this.cancelled) {
            return;
        }
        Collection<BibtexEntry> entryList = this.all.isSelected() ? bp.database().getEntries() : Arrays.asList(entries);
        String toSet = this.text.getText();
        if (toSet.length() == 0) {
            toSet = null;
        }
        String[] fields = this.getFieldNames(this.field.getText().trim().toLowerCase());
        NamedCompound ce = new NamedCompound(Globals.lang("Set field"));
        if (this.rename.isSelected()) {
            if (fields.length <= 1) {
                ce.addEdit(Util.massRenameField(entryList, fields[0], this.renameTo.getText(), this.overwrite.isSelected()));
            }
        } else {
            for (int i = 0; i < fields.length; ++i) {
                ce.addEdit(Util.massSetField(entryList, fields[i], this.set.isSelected() ? toSet : null, this.overwrite.isSelected()));
            }
        }
        ce.end();
        bp.undoManager.addEdit(ce);
        bp.markBaseChanged();
    }

    private String[] getFieldNames(String s) {
        return s.split("[\\s;,]");
    }
}

