/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.wizard.auximport.AuxSubGenerator;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_Cancel_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_generate_actionAdapter;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog_ok_actionAdapter;

public class FromAuxDialog
extends JDialog {
    private JPanel statusPanel = new JPanel();
    private JPanel buttons = new JPanel();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton generateButton = new JButton();
    private JComboBox dbChooser = new JComboBox();
    private JTextField auxFileField;
    private JButton browseAuxFileButton;
    private JList notFoundList;
    private JTextArea statusInfos;
    private JTabbedPane parentTabbedPane;
    private boolean okPressed = false;
    private AuxSubGenerator auxParser;

    public FromAuxDialog(JabRefFrame frame, String title, boolean modal, JTabbedPane viewedDBs) {
        super(frame, title, modal);
        this.parentTabbedPane = viewedDBs;
        this.auxParser = new AuxSubGenerator(null);
        try {
            this.jbInit(frame);
            this.pack();
            this.setSize(600, 500);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit(JabRefFrame parent) {
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        this.okButton.setText(Globals.lang("Ok"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new FromAuxDialog_ok_actionAdapter(this));
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(new FromAuxDialog_Cancel_actionAdapter(this));
        this.generateButton.setText(Globals.lang("Generate"));
        this.generateButton.addActionListener(new FromAuxDialog_generate_actionAdapter(this));
        this.initPanels(parent);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        JPanel buttonPanel = bb.getPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.addGlue();
        bb.addGridded(this.generateButton);
        bb.addRelatedGap();
        bb.addGridded(this.okButton);
        bb.addGridded(this.cancelButton);
        bb.addGlue();
        this.setModal(true);
        this.setResizable(true);
        this.setTitle(Globals.lang("AUX file import"));
        JLabel desc = new JLabel("<html><h3>" + Globals.lang("AUX file import") + "</h3><p>" + Globals.lang("This feature generates a new database based on which entries are needed in an existing LaTeX document.") + "</p>" + "<p>" + Globals.lang("You need to select one of your open databases from which to choose entries, as well as the AUX file produced by LaTeX when compiling your document.") + "</p></html>");
        desc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel1.add((Component)desc, "North");
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.add((Component)this.buttons, "North");
        centerPane.add((Component)this.statusPanel, "Center");
        this.getContentPane().add((Component)panel1, "North");
        this.getContentPane().add((Component)centerPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        ActionMap am = this.statusPanel.getActionMap();
        InputMap im = this.statusPanel.getInputMap(2);
        im.put(parent.prefs().getKey("Close dialog"), "close");
        am.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FromAuxDialog.this.dispose();
            }
        });
    }

    private void initPanels(JabRefFrame parent) {
        int len = this.parentTabbedPane.getTabCount();
        int toSelect = -1;
        for (int i = 0; i < len; ++i) {
            this.dbChooser.addItem(this.parentTabbedPane.getTitleAt(i));
            if (parent.baseAt(i) != parent.basePanel()) continue;
            toSelect = i;
        }
        if (toSelect >= 0) {
            this.dbChooser.setSelectedIndex(toSelect);
        }
        this.auxFileField = new JTextField("", 25);
        this.browseAuxFileButton = new JButton(Globals.lang("Browse"));
        this.browseAuxFileButton.addActionListener(new BrowseAction(this.auxFileField, parent));
        this.notFoundList = new JList();
        JScrollPane listScrollPane = new JScrollPane(this.notFoundList);
        this.statusInfos = new JTextArea("", 5, 20);
        JScrollPane statusScrollPane = new JScrollPane(this.statusInfos);
        this.statusInfos.setEditable(false);
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, left:pref", ""), this.buttons);
        b.appendSeparator(Globals.lang("Options"));
        b.append(Globals.lang("Reference database") + ":");
        b.append((Component)this.dbChooser, 3);
        b.nextLine();
        b.append(Globals.lang("LaTeX AUX file") + ":");
        b.append(this.auxFileField);
        b.append(this.browseAuxFileButton);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        b = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 4dlu, fill:pref:grow", "pref, pref, fill:pref:grow"), this.statusPanel);
        b.appendSeparator(Globals.lang("Unknown bibtex entries") + ":");
        b.append(Globals.lang("Unknown bibtex entries") + ":");
        b.append(Globals.lang("Messages") + ":");
        b.nextLine();
        b.append(listScrollPane);
        b.append(statusScrollPane);
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    void ok_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.dispose();
    }

    void Cancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void generate_actionPerformed(ActionEvent e) {
        this.generateButton.setEnabled(false);
        BasePanel bp = (BasePanel)this.parentTabbedPane.getComponentAt(this.dbChooser.getSelectedIndex());
        this.notFoundList.removeAll();
        this.statusInfos.setText(null);
        BibtexDatabase refBase = bp.getDatabase();
        String auxName = this.auxFileField.getText();
        if (auxName != null && refBase != null && auxName.length() > 0) {
            this.auxParser.clear();
            this.notFoundList.setListData(this.auxParser.generate(auxName, refBase));
            this.statusInfos.append(Globals.lang("keys in database") + " " + refBase.getEntryCount());
            this.statusInfos.append("\n" + Globals.lang("found in aux file") + " " + this.auxParser.getFoundKeysInAux());
            this.statusInfos.append("\n" + Globals.lang("resolved") + " " + this.auxParser.getResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("not found") + " " + this.auxParser.getNotResolvedKeysCount());
            this.statusInfos.append("\n" + Globals.lang("crossreferenced entries included") + " " + this.auxParser.getCrossreferencedEntriesCount());
            int nested = this.auxParser.getNestedAuxCounter();
            if (nested > 0) {
                this.statusInfos.append("\n" + Globals.lang("nested_aux_files") + " " + nested);
            }
            this.okButton.setEnabled(true);
        }
        if (this.auxParser.getGeneratedDatabase().getEntryCount() < 1) {
            this.statusInfos.append("\n" + Globals.lang("empty database"));
            this.okButton.setEnabled(false);
        }
        this.generateButton.setEnabled(true);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public BibtexDatabase getGenerateDB() {
        return this.auxParser.getGeneratedDatabase();
    }

    class BrowseAction
    extends AbstractAction {
        private JTextField comp;
        private JabRefFrame _frame;

        public BrowseAction(JTextField tc, JabRefFrame frame) {
            super(Globals.lang("Browse"));
            this._frame = frame;
            this.comp = tc;
        }

        public void actionPerformed(ActionEvent e) {
            String chosen = null;
            chosen = FileDialogs.getNewFile(this._frame, new File(this.comp.getText()), ".aux", 0, false);
            if (chosen != null) {
                File newFile = new File(chosen);
                this.comp.setText(newFile.getPath());
            }
        }
    }
}

