/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

public class Interval {
    public static final int INTERVAL_POOL_MAX_VALUE = 1000;
    static Interval[] intervals = new Interval[1001];
    public int a;
    public int b;

    public static Interval create(int a, int b) {
        return new Interval(a, b);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Interval other = (Interval)o;
        boolean bl = false;
        if (this.a == other.a && this.b == other.b) {
            bl = true;
        }
        return bl;
    }

    public boolean startsBeforeDisjoint(Interval other) {
        boolean bl = false;
        if (this.a < other.a && this.b < other.a) {
            bl = true;
        }
        return bl;
    }

    public boolean startsBeforeNonDisjoint(Interval other) {
        boolean bl = false;
        if (this.a <= other.a && this.b >= other.a) {
            bl = true;
        }
        return bl;
    }

    public boolean startsAfter(Interval other) {
        boolean bl = false;
        if (this.a > other.a) {
            bl = true;
        }
        return bl;
    }

    public boolean startsAfterDisjoint(Interval other) {
        boolean bl = false;
        if (this.a > other.b) {
            bl = true;
        }
        return bl;
    }

    public boolean startsAfterNonDisjoint(Interval other) {
        boolean bl = false;
        if (this.a > other.a && this.a <= other.b) {
            bl = true;
        }
        return bl;
    }

    public boolean disjoint(Interval other) {
        boolean bl = false;
        if (this.startsBeforeDisjoint(other) || this.startsAfterDisjoint(other)) {
            bl = true;
        }
        return bl;
    }

    public boolean adjacent(Interval other) {
        boolean bl = false;
        if (this.a == other.b + 1 || this.b == other.a - 1) {
            bl = true;
        }
        return bl;
    }

    public boolean properlyContains(Interval other) {
        boolean bl = false;
        if (other.a >= this.a && other.b <= this.b) {
            bl = true;
        }
        return bl;
    }

    public Interval union(Interval other) {
        return new Interval(Math.min(this.a, other.a), Math.max(this.b, other.b));
    }

    public Interval intersection(Interval other) {
        return new Interval(Math.max(this.a, other.a), Math.min(this.b, other.b));
    }

    public Interval differenceNotProperlyContained(Interval other) {
        Interval diff = null;
        if (other.startsBeforeNonDisjoint(this)) {
            diff = new Interval(Math.max(this.a, other.b + 1), this.b);
        } else if (other.startsAfterNonDisjoint(this)) {
            diff = new Interval(this.a, other.a - 1);
        }
        return diff;
    }

    public String toString() {
        return this.a + ".." + this.b;
    }

    public Interval(int a, int b) {
        this.a = a;
        this.b = b;
    }
}

