/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.deserialize.reader;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.sciplore.data.MultiValueMap;
import org.sciplore.deserialize.creator.ObjectCreator;
import org.sciplore.deserialize.reader.ObjectCreatorMapper;
import org.sciplore.deserialize.reader.ReaderWrapperInputStream;
import org.sciplore.deserialize.traversing.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ObjectReader {
    private final ObjectCreatorMapper mapper;

    protected abstract Document getDom(InputStream var1);

    public ObjectReader(ObjectCreatorMapper creatorMapper) {
        if (creatorMapper == null) {
            throw new NullPointerException("argument creatorMapper must not be NULL.");
        }
        this.mapper = creatorMapper;
    }

    public Object parse(Reader reader) {
        Document doc = this.getDom(new ReaderWrapperInputStream(reader));
        if (doc != null) {
            return this.decideReturnType(doc);
        }
        return null;
    }

    public Object parse(InputStream istream) {
        Document doc = this.getDom(istream);
        if (doc != null) {
            return this.decideReturnType(doc);
        }
        return null;
    }

    protected Object decideReturnType(Document document) {
        if (document.getChildNodes().getLength() > 1 && document.getFirstChild().getNodeName().equals(document.getFirstChild().getNextSibling().getNodeName())) {
            return this.createObjectList(document);
        }
        return this.createObject(document.getDocumentElement(), null);
    }

    private Object createObject(Node node, TreePath parent) {
        TreePath path = new TreePath(node.getNodeName(), parent);
        MultiValueMap<String, Object> childObjects = new MultiValueMap<String, Object>();
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeType() == 1) {
                childObjects.put(nodes.item(i).getNodeName(), this.createObject(nodes.item(i), path));
            }
            ++i;
        }
        return this.handleElement(path, node, childObjects);
    }

    private List<Object> createObjectList(Node node) {
        ArrayList<Object> objects = new ArrayList<Object>();
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            if (nodes.item(i).getNodeType() == 1) {
                objects.add(this.createObject(nodes.item(i), null));
            }
            ++i;
        }
        return objects;
    }

    private Object handleElement(TreePath path, Node node, MultiValueMap<String, Object> children) {
        ObjectCreator creator = this.mapper.getCreator(node.getNodeName());
        if (creator != null) {
            return creator.createResource(path, node, children);
        }
        return null;
    }
}

