/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ErrorMessageDisplay;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRuleSet;

public class DatabaseSearch
extends Thread {
    BasePanel panel = null;
    BibtexDatabase thisDatabase = null;
    SearchRuleSet thisRuleSet = null;
    Map<String, String> thisSearchOptions = null;
    String searchValueField = null;
    boolean reorder;
    boolean select;
    boolean grayOut;
    ErrorMessageDisplay errorDisplay;
    Set<BibtexEntry> matches = new HashSet<BibtexEntry>();

    public DatabaseSearch(ErrorMessageDisplay errorDisplay, Map<String, String> searchOptions, SearchRuleSet searchRules, BasePanel panel, String searchValueField, boolean reorder, boolean grayOut, boolean select) {
        this.panel = panel;
        this.errorDisplay = errorDisplay;
        this.thisDatabase = panel.getDatabase();
        this.thisSearchOptions = searchOptions;
        this.thisRuleSet = searchRules;
        this.searchValueField = searchValueField;
        this.reorder = reorder;
        this.select = select;
        this.grayOut = grayOut;
    }

    @Override
    public void run() {
        int searchScore = 0;
        this.matches.clear();
        BibtexEntry bes = null;
        int hits = 0;
        for (String id : this.thisDatabase.getKeySet()) {
            bes = this.thisDatabase.getEntryById(id);
            if (bes == null) continue;
            try {
                searchScore = this.thisRuleSet.applyRule(this.thisSearchOptions, bes);
            }
            catch (PatternSyntaxException ex) {
                this.errorDisplay.reportError("Malformed regular expression", ex);
                return;
            }
            if (searchScore > 0) {
                searchScore = 1;
            }
            bes.setField(this.searchValueField, String.valueOf(searchScore));
            if (searchScore <= 0) continue;
            ++hits;
            this.matches.add(bes);
        }
        final int outputHits = hits;
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                DatabaseSearch.this.panel.output(Globals.lang("Searched database. Global number of hits") + ": " + outputHits);
            }
        });
    }

    public Iterator<BibtexEntry> matches() {
        return this.matches.iterator();
    }
}

