/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.EntryComparator;
import net.sf.jabref.EntrySorter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.ChangeDisplayDialog;
import net.sf.jabref.collab.EntryAddChange;
import net.sf.jabref.collab.EntryChange;
import net.sf.jabref.collab.EntryDeleteChange;
import net.sf.jabref.collab.GroupChange;
import net.sf.jabref.collab.MetaDataChange;
import net.sf.jabref.collab.PreambleChange;
import net.sf.jabref.collab.StringAddChange;
import net.sf.jabref.collab.StringChange;
import net.sf.jabref.collab.StringNameChange;
import net.sf.jabref.collab.StringRemoveChange;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;

public class ChangeScanner
extends Thread {
    final double MATCH_THRESHOLD = 0.4;
    final String[] sortBy = new String[]{"year", "author", "title"};
    File f;
    BibtexDatabase inMem;
    BibtexDatabase inTemp = null;
    MetaData mdInMem;
    MetaData mdInTemp;
    BasePanel panel;
    JabRefFrame frame;
    DefaultMutableTreeNode changes = new DefaultMutableTreeNode(Globals.lang("External changes"));

    public ChangeScanner(JabRefFrame frame, BasePanel bp) {
        this.panel = bp;
        this.frame = frame;
        this.inMem = bp.database();
        this.mdInMem = bp.metaData();
        this.setPriority(1);
    }

    public void changeScan(File f) {
        this.f = f;
        this.start();
    }

    @Override
    public void run() {
        try {
            File tempFile = Globals.fileUpdateMonitor.getTempFile(this.panel.fileMonitorHandle());
            ParserResult pr = OpenDatabaseAction.loadDatabase(tempFile, Globals.prefs.get("defaultEncoding"));
            this.inTemp = pr.getDatabase();
            this.mdInTemp = pr.getMetaData();
            pr = OpenDatabaseAction.loadDatabase(this.f, Globals.prefs.get("defaultEncoding"));
            BibtexDatabase onDisk = pr.getDatabase();
            MetaData mdOnDisk = pr.getMetaData();
            EntryComparator comp = new EntryComparator(false, true, this.sortBy[2]);
            comp = new EntryComparator(false, true, this.sortBy[1], comp);
            comp = new EntryComparator(false, true, this.sortBy[0], comp);
            EntrySorter sInTemp = this.inTemp.getSorter(comp);
            comp = new EntryComparator(false, true, this.sortBy[2]);
            comp = new EntryComparator(false, true, this.sortBy[1], comp);
            comp = new EntryComparator(false, true, this.sortBy[0], comp);
            EntrySorter sOnDisk = onDisk.getSorter(comp);
            comp = new EntryComparator(false, true, this.sortBy[2]);
            comp = new EntryComparator(false, true, this.sortBy[1], comp);
            comp = new EntryComparator(false, true, this.sortBy[0], comp);
            EntrySorter sInMem = this.inMem.getSorter(comp);
            this.scanMetaData(this.mdInMem, this.mdInTemp, mdOnDisk);
            this.scanPreamble(this.inMem, this.inTemp, onDisk);
            this.scanStrings(this.inMem, this.inTemp, onDisk);
            this.scanEntries(sInMem, sInTemp, sOnDisk);
            this.scanGroups(this.mdInMem, this.mdInTemp, mdOnDisk);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean changesFound() {
        return this.changes.getChildCount() > 0;
    }

    public void displayResult(final DisplayResultCallback fup) {
        if (this.changes.getChildCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangeDisplayDialog dial = new ChangeDisplayDialog(ChangeScanner.this.frame, ChangeScanner.this.panel, ChangeScanner.this.inTemp, ChangeScanner.this.changes);
                    Util.placeDialog(dial, ChangeScanner.this.frame);
                    dial.setVisible(true);
                    fup.scanResultsResolved(dial.isOkPressed());
                    if (dial.isOkPressed()) {
                        ChangeScanner.this.storeTempDatabase();
                    }
                }
            });
        } else {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("No actual changes found."), Globals.lang("External changes"), 1);
            fup.scanResultsResolved(true);
        }
    }

    private void storeTempDatabase() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SaveSession ss = FileActions.saveDatabase(ChangeScanner.this.inTemp, ChangeScanner.this.mdInTemp, Globals.fileUpdateMonitor.getTempFile(ChangeScanner.this.panel.fileMonitorHandle()), Globals.prefs, false, false, ChangeScanner.this.panel.getEncoding(), true);
                    ss.commit();
                }
                catch (SaveException ex) {
                    System.out.println("Problem updating tmp file after accepting external changes");
                }
            }
        }).start();
    }

    private void scanMetaData(MetaData inMem, MetaData inTemp, MetaData onDisk) {
        MetaDataChange mdc = new MetaDataChange(inMem, inTemp);
        ArrayList<String> handledOnDisk = new ArrayList<String>();
        for (String key : inTemp) {
            Vector<String> vod = onDisk.getData(key);
            if (vod == null) {
                mdc.insertMetaDataRemoval(key);
                continue;
            }
            Vector<String> vit = inTemp.getData(key);
            if (!vod.equals(vit)) {
                mdc.insertMetaDataChange(key, vod);
            }
            handledOnDisk.add(key);
        }
        for (String key : onDisk) {
            if (handledOnDisk.contains(key)) continue;
            mdc.insertMetaDataAddition(key, onDisk.getData(key));
        }
        if (mdc.getChangeCount() > 0) {
            this.changes.add(mdc);
        }
    }

    private void scanEntries(EntrySorter mem, EntrySorter tmp, EntrySorter disk) {
        int piv1 = 0;
        int piv2 = 0;
        HashSet<String> used = new HashSet<String>(disk.getEntryCount());
        HashSet<Integer> notMatched = new HashSet<Integer>(tmp.getEntryCount());
        block0: for (piv1 = 0; piv1 < tmp.getEntryCount(); ++piv1) {
            double comp = -1.0;
            if (!used.contains("" + piv2) && piv2 < disk.getEntryCount()) {
                comp = DuplicateCheck.compareEntriesStrictly(tmp.getEntryAt(piv1), disk.getEntryAt(piv2));
            }
            if (comp > 1.0) {
                used.add("" + piv2);
                ++piv2;
                continue;
            }
            if (piv2 < disk.getEntryCount() - 1) {
                for (int i = piv2 + 1; i < disk.getEntryCount(); ++i) {
                    comp = !used.contains("" + i) ? DuplicateCheck.compareEntriesStrictly(tmp.getEntryAt(piv1), disk.getEntryAt(i)) : -1.0;
                    if (!(comp > 1.0)) continue;
                    used.add("" + i);
                    continue block0;
                }
            }
            notMatched.add(new Integer(piv1));
        }
        if (notMatched.size() > 0) {
            Iterator it = notMatched.iterator();
            while (it.hasNext()) {
                Change ec;
                Integer integ = (Integer)it.next();
                piv1 = integ;
                int bestMatchI = -1;
                double bestMatch = 0.0;
                double comp = -1.0;
                if (piv2 < disk.getEntryCount() - 1) {
                    for (int i = piv2; i < disk.getEntryCount(); ++i) {
                        comp = !used.contains("" + i) ? DuplicateCheck.compareEntriesStrictly(tmp.getEntryAt(piv1), disk.getEntryAt(i)) : -1.0;
                        if (!(comp > bestMatch)) continue;
                        bestMatch = comp;
                        bestMatchI = i;
                    }
                }
                if (bestMatch > 0.4) {
                    used.add("" + bestMatchI);
                    it.remove();
                    ec = new EntryChange(this.bestFit(tmp, mem, piv1), tmp.getEntryAt(piv1), disk.getEntryAt(bestMatchI));
                    this.changes.add(ec);
                    continue;
                }
                ec = new EntryDeleteChange(this.bestFit(tmp, mem, piv1), tmp.getEntryAt(piv1));
                this.changes.add(ec);
            }
        }
        if (used.size() < disk.getEntryCount()) {
            for (int i = 0; i < disk.getEntryCount(); ++i) {
                if (used.contains("" + i)) continue;
                boolean hasAlready = false;
                for (int j = 0; j < mem.getEntryCount(); ++j) {
                    if (!(DuplicateCheck.compareEntriesStrictly(mem.getEntryAt(j), disk.getEntryAt(i)) >= 1.0)) continue;
                    hasAlready = true;
                    break;
                }
                if (hasAlready) continue;
                EntryAddChange ec = new EntryAddChange(disk.getEntryAt(i));
                this.changes.add(ec);
            }
        }
    }

    private BibtexEntry bestFit(EntrySorter old, EntrySorter neu, int index) {
        double comp = -1.0;
        int found = 0;
        for (int i = 0; i < neu.getEntryCount(); ++i) {
            double res = DuplicateCheck.compareEntriesStrictly(old.getEntryAt(index), neu.getEntryAt(i));
            if (res > comp) {
                comp = res;
                found = i;
            }
            if (comp > 1.0) break;
        }
        return neu.getEntryAt(found);
    }

    private void scanPreamble(BibtexDatabase inMem, BibtexDatabase onTmp, BibtexDatabase onDisk) {
        String mem = inMem.getPreamble();
        String tmp = onTmp.getPreamble();
        String disk = onDisk.getPreamble();
        if (tmp != null) {
            if (disk == null || !tmp.equals(disk)) {
                this.changes.add(new PreambleChange(tmp, mem, disk));
            }
        } else if (disk != null && !disk.equals("")) {
            this.changes.add(new PreambleChange(tmp, mem, disk));
        }
    }

    private void scanStrings(BibtexDatabase inMem, BibtexDatabase onTmp, BibtexDatabase onDisk) {
        BibtexString tmp;
        int nTmp = onTmp.getStringCount();
        int nDisk = onDisk.getStringCount();
        if (nTmp == 0 && nDisk == 0) {
            return;
        }
        HashSet<String> used = new HashSet<String>();
        HashSet<Object> usedInMem = new HashSet<Object>();
        HashSet<String> notMatched = new HashSet<String>(onTmp.getStringCount());
        block0: for (String key : onTmp.getStringKeySet()) {
            tmp = onTmp.getString(key);
            for (String diskId : onDisk.getStringKeySet()) {
                BibtexString disk;
                if (used.contains(diskId) || !(disk = onDisk.getString(diskId)).getName().equals(tmp.getName())) continue;
                if (tmp.getContent() != null && !tmp.getContent().equals(disk.getContent())) {
                    BibtexString mem = this.findString(inMem, tmp.getName(), usedInMem);
                    if (mem != null) {
                        this.changes.add(new StringChange(mem, tmp, tmp.getName(), mem.getContent(), tmp.getContent(), disk.getContent()));
                    } else {
                        this.changes.add(new StringChange(null, tmp, tmp.getName(), null, tmp.getContent(), disk.getContent()));
                    }
                }
                used.add(diskId);
                continue block0;
            }
            notMatched.add(tmp.getId());
        }
        if (notMatched.size() > 0) {
            Iterator<Object> i = notMatched.iterator();
            while (i.hasNext()) {
                BibtexString tmp2 = onTmp.getString((String)i.next());
                for (String diskId : onDisk.getStringKeySet()) {
                    BibtexString disk;
                    if (used.contains(diskId) || !(disk = onDisk.getString(diskId)).getContent().equals(tmp2.getContent())) continue;
                    BibtexString bsMem = null;
                    for (String memId : inMem.getStringKeySet()) {
                        BibtexString bsMem_cand = inMem.getString(memId);
                        if (!bsMem_cand.getContent().equals(disk.getContent()) || usedInMem.contains(memId)) continue;
                        usedInMem.add(memId);
                        bsMem = bsMem_cand;
                        break;
                    }
                    this.changes.add(new StringNameChange(bsMem, tmp2, bsMem.getName(), tmp2.getName(), disk.getName(), tmp2.getContent()));
                    i.remove();
                    used.add(diskId);
                }
            }
        }
        if (notMatched.size() > 0) {
            for (String nmId : notMatched) {
                tmp = onTmp.getString(nmId);
                BibtexString mem = this.findString(inMem, tmp.getName(), usedInMem);
                if (mem == null) continue;
                this.changes.add(new StringRemoveChange(tmp, tmp, mem));
            }
        }
        for (String diskId : onDisk.getStringKeySet()) {
            if (used.contains(diskId)) continue;
            BibtexString disk = onDisk.getString(diskId);
            used.add(diskId);
            this.changes.add(new StringAddChange(disk));
        }
    }

    private BibtexString findString(BibtexDatabase base, String name, HashSet<Object> used) {
        if (!base.hasStringLabel(name)) {
            return null;
        }
        for (String key : base.getStringKeySet()) {
            BibtexString bs = base.getString(key);
            if (!bs.getName().equals(name) || used.contains(key)) continue;
            used.add(key);
            return bs;
        }
        return null;
    }

    public void scanGroups(MetaData inMem, MetaData onTmp, MetaData onDisk) {
        GroupTreeNode groupsTmp = onTmp.getGroups();
        GroupTreeNode groupsDisk = onDisk.getGroups();
        if (groupsTmp == null && groupsDisk == null) {
            return;
        }
        if (groupsTmp != null && groupsDisk == null || groupsTmp == null && groupsDisk != null) {
            this.changes.add(new GroupChange(groupsDisk, groupsTmp));
            return;
        }
        if (groupsTmp.equals(groupsDisk)) {
            return;
        }
        this.changes.add(new GroupChange(groupsDisk, groupsTmp));
    }

    public static interface DisplayResultCallback {
        public void scanResultsResolved(boolean var1);
    }
}

