/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.VerifyingWriter;

public class SaveSession {
    public static final String LOCKFILE_SUFFIX = ".lock";
    public static final long LOCKFILE_CRITICAL_AGE = 60000L;
    private static final String TEMP_PREFIX = "jabref";
    private static final String TEMP_SUFFIX = "save.bib";
    File file;
    File tmp;
    File backupFile;
    String encoding;
    boolean backup;
    boolean useLockFile;
    VerifyingWriter writer;

    public SaveSession(File file, String encoding, boolean backup) throws IOException, UnsupportedCharsetException {
        this.file = file;
        this.tmp = File.createTempFile(TEMP_PREFIX, TEMP_SUFFIX);
        this.useLockFile = Globals.prefs.getBoolean("useLockFiles");
        this.backup = backup;
        this.encoding = encoding;
        this.writer = new VerifyingWriter((OutputStream)new FileOutputStream(this.tmp), encoding);
    }

    public VerifyingWriter getWriter() {
        return this.writer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseBackup(boolean useBackup) {
        this.backup = useBackup;
    }

    public void commit() throws SaveException {
        if (this.file == null) {
            return;
        }
        if (this.file.exists() && this.backup) {
            String name = this.file.getName();
            String path = this.file.getParent();
            File backupFile = new File(path, name + GUIGlobals.backupExt);
            try {
                Util.copyFile(this.file, backupFile, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw SaveException.BACKUP_CREATION;
            }
        }
        try {
            if (this.useLockFile) {
                try {
                    if (this.createLockFile() && !Util.waitForFileLock(this.file, 10)) {
                        throw SaveException.FILE_LOCKED;
                    }
                }
                catch (IOException ex) {
                    System.err.println("Error when creating lock file");
                    ex.printStackTrace();
                }
            }
            Util.copyFile(this.tmp, this.file, true);
        }
        catch (IOException ex2) {
            throw new SaveException(Globals.lang("Save failed while committing changes") + ": " + ex2.getMessage());
        }
        finally {
            if (this.useLockFile) {
                try {
                    this.deleteLockFile();
                }
                catch (IOException ex) {
                    System.err.println("Error when deleting lock file");
                    ex.printStackTrace();
                }
            }
        }
        this.tmp.delete();
    }

    public void cancel() throws IOException {
        this.tmp.delete();
    }

    private boolean createLockFile() throws IOException {
        File lock = new File(this.file.getPath() + LOCKFILE_SUFFIX);
        if (lock.exists()) {
            return true;
        }
        FileOutputStream out = new FileOutputStream(lock);
        out.write(0);
        try {
            out.close();
        }
        catch (IOException ex) {
            System.err.println("Error when creating lock file");
            ex.printStackTrace();
        }
        lock.deleteOnExit();
        return false;
    }

    private boolean deleteLockFile() throws IOException {
        File lock = new File(this.file.getPath() + LOCKFILE_SUFFIX);
        if (!lock.exists()) {
            return false;
        }
        lock.delete();
        return true;
    }

    public File getTemporaryFile() {
        return this.tmp;
    }
}

