/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.UndoableFieldChange;

public class AttachFileAction
extends BaseAction {
    BibtexEntry entry = null;
    private BasePanel panel;

    public AttachFileAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void action() {
        if (this.panel.getSelectedEntries().length != 1) {
            return;
        }
        this.entry = this.panel.getSelectedEntries()[0];
        FileListEntry flEntry = new FileListEntry("", "", null);
        FileListEntryEditor editor = new FileListEntryEditor(this.panel.frame(), flEntry, false, true, this.panel.metaData());
        editor.setVisible(true, true);
        if (editor.okPressed()) {
            FileListTableModel model = new FileListTableModel();
            String oldVal = this.entry.getField("file");
            if (oldVal != null) {
                model.setContent(oldVal);
            }
            model.addEntry(model.getRowCount(), flEntry);
            String newVal = model.getStringRepresentation();
            UndoableFieldChange ce = new UndoableFieldChange(this.entry, "file", oldVal, newVal);
            this.entry.setField("file", newVal);
            this.panel.undoManager.addEdit(ce);
            this.panel.markBaseChanged();
        }
    }
}

