/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToVim
implements PushToApplication {
    private JPanel settings = null;
    private JTextField vimPath = new JTextField(30);
    private JTextField vimServer = new JTextField(30);
    private JTextField citeCommand = new JTextField(30);
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into Vim");
    }

    @Override
    public String getApplicationName() {
        return "Vim";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to Vim");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("vim");
    }

    @Override
    public String getKeyStrokeName() {
        return null;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.vimPath.setText(Globals.prefs.get("vim"));
        this.vimServer.setText(Globals.prefs.get("vimServer"));
        this.citeCommand.setText(Globals.prefs.get("citeCommandVim"));
        return this.settings;
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("vim", this.vimPath.getText());
        Globals.prefs.put("vimServer", this.vimServer.getText());
        Globals.prefs.put("citeCommandVim", this.citeCommand.getText());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        builder.append(new JLabel(Globals.lang("Path to Vim") + ":"));
        builder.append(this.vimPath);
        BrowseAction action = new BrowseAction(null, this.vimPath, false);
        JButton browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(action);
        builder.append(browse);
        builder.nextLine();
        builder.append(Globals.lang("Vim Server Name") + ":");
        builder.append(this.vimServer);
        builder.nextLine();
        builder.append(Globals.lang("Cite command") + ":");
        builder.append(this.citeCommand);
        this.settings = builder.getPanel();
    }

    @Override
    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, String keys, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        try {
            String[] com = new String[]{Globals.prefs.get("vim"), "--servername", Globals.prefs.get("vimServer"), "--remote-send", "<C-\\><C-N>a" + Globals.prefs.get("citeCommandVim") + "{" + keys + "}"};
            final Process p = Runtime.getRuntime().exec(com);
            Runnable errorListener = new Runnable(){

                @Override
                public void run() {
                    InputStream out = p.getErrorStream();
                    StringBuffer sb = new StringBuffer();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (sb.toString().trim().length() > 0) {
                        System.out.println(sb.toString());
                        PushToVim.this.couldNotConnect = true;
                        return;
                    }
                }
            };
            Thread t = new Thread(errorListener);
            t.start();
            t.join();
        }
        catch (IOException excep) {
            this.couldNotRunClient = true;
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(panel.frame(), "<HTML>" + Globals.lang("Could not connect to Vim server. Make sure that Vim is running<BR>with correct server name.") + "</HTML>", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            JOptionPane.showMessageDialog(panel.frame(), Globals.lang("Could not run the 'vim' program."), Globals.lang("Error"), 0);
        } else {
            panel.output(Globals.lang("Pushed citations to Vim"));
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }
}

